/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.method.MethodValidator;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.method.ControllerAdviceBean;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.ExceptionHandlerMethodResolver;
import org.springframework.web.method.annotation.HandlerMethodValidator;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.InvocableHandlerMethod;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.SyncInvocableHandlerMethod;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.reactive.result.method.annotation.ContinuationHandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.CookieValueMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ErrorsMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ExpressionValueMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.HttpEntityMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.MatrixVariableMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.MatrixVariableMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ModelAttributeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ModelMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PathVariableMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PathVariableMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PrincipalMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestAttributeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestBodyMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestHeaderMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestHeaderMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestParamMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestPartMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ServerWebExchangeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.SessionAttributeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.SessionAttributesHandler;
import org.springframework.web.reactive.result.method.annotation.SessionStatusMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.WebSessionMethodArgumentResolver;

class ControllerMethodResolver {
    private static final ReflectionUtils.MethodFilter INIT_BINDER_METHODS = method -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, InitBinder.class);
    private static final ReflectionUtils.MethodFilter MODEL_ATTRIBUTE_METHODS = method -> !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, RequestMapping.class) && AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, ModelAttribute.class);
    private static final boolean BEAN_VALIDATION_PRESENT = ClassUtils.isPresent((String)"jakarta.validation.Validator", (ClassLoader)HandlerMethod.class.getClassLoader());
    private static final Log logger = LogFactory.getLog(ControllerMethodResolver.class);
    private final List<SyncHandlerMethodArgumentResolver> initBinderResolvers;
    private final List<HandlerMethodArgumentResolver> modelAttributeResolvers;
    private final List<HandlerMethodArgumentResolver> requestMappingResolvers;
    private final List<HandlerMethodArgumentResolver> exceptionHandlerResolvers;
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;
    @Nullable
    private final MethodValidator methodValidator;
    private final Map<Class<?>, Set<Method>> initBinderMethodCache = new ConcurrentHashMap(64);
    private final Map<Class<?>, Set<Method>> modelAttributeMethodCache = new ConcurrentHashMap(64);
    private final Map<Class<?>, ExceptionHandlerMethodResolver> exceptionHandlerCache = new ConcurrentHashMap(64);
    private final Map<ControllerAdviceBean, Set<Method>> initBinderAdviceCache = new LinkedHashMap<ControllerAdviceBean, Set<Method>>(64);
    private final Map<ControllerAdviceBean, Set<Method>> modelAttributeAdviceCache = new LinkedHashMap<ControllerAdviceBean, Set<Method>>(64);
    private final Map<ControllerAdviceBean, ExceptionHandlerMethodResolver> exceptionHandlerAdviceCache = new LinkedHashMap<ControllerAdviceBean, ExceptionHandlerMethodResolver>(64);
    private final Map<Class<?>, SessionAttributesHandler> sessionAttributesHandlerCache = new ConcurrentHashMap(64);

    ControllerMethodResolver(ArgumentResolverConfigurer customResolvers, ReactiveAdapterRegistry adapterRegistry, ConfigurableApplicationContext context, List<HttpMessageReader<?>> readers, @Nullable WebBindingInitializer webBindingInitializer) {
        Assert.notNull((Object)customResolvers, (String)"ArgumentResolverConfigurer is required");
        Assert.notNull((Object)adapterRegistry, (String)"ReactiveAdapterRegistry is required");
        Assert.notNull((Object)context, (String)"ApplicationContext is required");
        Assert.notNull(readers, (String)"HttpMessageReader List is required");
        this.initBinderResolvers = this.initBinderResolvers(customResolvers, adapterRegistry, context);
        this.modelAttributeResolvers = ControllerMethodResolver.modelMethodResolvers(customResolvers, adapterRegistry, context);
        this.requestMappingResolvers = ControllerMethodResolver.requestMappingResolvers(customResolvers, adapterRegistry, context, readers);
        this.exceptionHandlerResolvers = ControllerMethodResolver.exceptionHandlerResolvers(customResolvers, adapterRegistry, context);
        this.reactiveAdapterRegistry = adapterRegistry;
        this.methodValidator = BEAN_VALIDATION_PRESENT ? HandlerMethodValidator.from((WebBindingInitializer)webBindingInitializer, null, ControllerMethodResolver.methodParamPredicate(this.requestMappingResolvers, ModelAttributeMethodArgumentResolver.class), ControllerMethodResolver.methodParamPredicate(this.requestMappingResolvers, RequestParamMethodArgumentResolver.class)) : null;
        this.initControllerAdviceCaches((ApplicationContext)context);
    }

    private List<SyncHandlerMethodArgumentResolver> initBinderResolvers(ArgumentResolverConfigurer customResolvers, ReactiveAdapterRegistry adapterRegistry, ConfigurableApplicationContext context) {
        return ControllerMethodResolver.initResolvers(customResolvers, adapterRegistry, context, false, Collections.emptyList()).stream().filter(SyncHandlerMethodArgumentResolver.class::isInstance).map(SyncHandlerMethodArgumentResolver.class::cast).toList();
    }

    private static List<HandlerMethodArgumentResolver> modelMethodResolvers(ArgumentResolverConfigurer customResolvers, ReactiveAdapterRegistry adapterRegistry, ConfigurableApplicationContext context) {
        return ControllerMethodResolver.initResolvers(customResolvers, adapterRegistry, context, true, Collections.emptyList());
    }

    private static List<HandlerMethodArgumentResolver> requestMappingResolvers(ArgumentResolverConfigurer customResolvers, ReactiveAdapterRegistry adapterRegistry, ConfigurableApplicationContext context, List<HttpMessageReader<?>> readers) {
        return ControllerMethodResolver.initResolvers(customResolvers, adapterRegistry, context, true, readers);
    }

    private static List<HandlerMethodArgumentResolver> exceptionHandlerResolvers(ArgumentResolverConfigurer customResolvers, ReactiveAdapterRegistry adapterRegistry, ConfigurableApplicationContext context) {
        return ControllerMethodResolver.initResolvers(customResolvers, adapterRegistry, context, false, Collections.emptyList());
    }

    private static List<HandlerMethodArgumentResolver> initResolvers(ArgumentResolverConfigurer customResolvers, ReactiveAdapterRegistry adapterRegistry, ConfigurableApplicationContext context, boolean supportDataBinding, List<HttpMessageReader<?>> readers) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        boolean requestMappingMethod = !readers.isEmpty() && supportDataBinding;
        ArrayList<HandlerMethodArgumentResolver> result = new ArrayList<HandlerMethodArgumentResolver>(30);
        result.add(new RequestParamMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry, false));
        result.add(new RequestParamMapMethodArgumentResolver(adapterRegistry));
        result.add(new PathVariableMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        result.add(new PathVariableMapMethodArgumentResolver(adapterRegistry));
        result.add(new MatrixVariableMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        result.add(new MatrixVariableMapMethodArgumentResolver(adapterRegistry));
        if (!readers.isEmpty()) {
            result.add(new RequestBodyMethodArgumentResolver(readers, adapterRegistry));
            result.add(new RequestPartMethodArgumentResolver(readers, adapterRegistry));
        }
        if (supportDataBinding) {
            result.add(new ModelAttributeMethodArgumentResolver(adapterRegistry, false));
        }
        result.add(new RequestHeaderMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        result.add(new RequestHeaderMapMethodArgumentResolver(adapterRegistry));
        result.add(new CookieValueMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        result.add(new ExpressionValueMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        result.add(new SessionAttributeMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        result.add(new RequestAttributeMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        if (!readers.isEmpty()) {
            result.add(new HttpEntityMethodArgumentResolver(readers, adapterRegistry));
        }
        result.add(new ModelMethodArgumentResolver(adapterRegistry));
        if (supportDataBinding) {
            result.add(new ErrorsMethodArgumentResolver(adapterRegistry));
        }
        result.add(new ServerWebExchangeMethodArgumentResolver(adapterRegistry));
        result.add(new PrincipalMethodArgumentResolver(adapterRegistry));
        if (requestMappingMethod) {
            result.add(new SessionStatusMethodArgumentResolver());
        }
        result.add(new WebSessionMethodArgumentResolver(adapterRegistry));
        if (KotlinDetector.isKotlinPresent()) {
            result.add(new ContinuationHandlerMethodArgumentResolver());
        }
        result.addAll(customResolvers.getCustomResolvers());
        result.add(new RequestParamMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry, true));
        if (supportDataBinding) {
            result.add(new ModelAttributeMethodArgumentResolver(adapterRegistry, true));
        }
        return result;
    }

    private void initControllerAdviceCaches(ApplicationContext applicationContext) {
        List beans = ControllerAdviceBean.findAnnotatedBeans((ApplicationContext)applicationContext);
        for (ControllerAdviceBean bean : beans) {
            ExceptionHandlerMethodResolver resolver;
            Set binderMethods;
            Class beanType = bean.getBeanType();
            if (beanType == null) continue;
            Set attrMethods = MethodIntrospector.selectMethods((Class)beanType, (ReflectionUtils.MethodFilter)MODEL_ATTRIBUTE_METHODS);
            if (!attrMethods.isEmpty()) {
                this.modelAttributeAdviceCache.put(bean, attrMethods);
            }
            if (!(binderMethods = MethodIntrospector.selectMethods((Class)beanType, (ReflectionUtils.MethodFilter)INIT_BINDER_METHODS)).isEmpty()) {
                this.initBinderAdviceCache.put(bean, binderMethods);
            }
            if (!(resolver = new ExceptionHandlerMethodResolver(beanType)).hasExceptionMappings()) continue;
            this.exceptionHandlerAdviceCache.put(bean, resolver);
        }
        if (logger.isDebugEnabled()) {
            int modelSize = this.modelAttributeAdviceCache.size();
            int binderSize = this.initBinderAdviceCache.size();
            int handlerSize = this.exceptionHandlerAdviceCache.size();
            if (modelSize == 0 && binderSize == 0 && handlerSize == 0) {
                logger.debug((Object)"ControllerAdvice beans: none");
            } else {
                logger.debug((Object)("ControllerAdvice beans: " + modelSize + " @ModelAttribute, " + binderSize + " @InitBinder, " + handlerSize + " @ExceptionHandler"));
            }
        }
    }

    private static Predicate<MethodParameter> methodParamPredicate(List<HandlerMethodArgumentResolver> resolvers, Class<?> resolverType) {
        return parameter -> {
            for (HandlerMethodArgumentResolver resolver : resolvers) {
                if (!resolver.supportsParameter((MethodParameter)parameter)) continue;
                return resolverType.isInstance(resolver);
            }
            return false;
        };
    }

    public InvocableHandlerMethod getRequestMappingMethod(HandlerMethod handlerMethod) {
        InvocableHandlerMethod invocable = new InvocableHandlerMethod(handlerMethod);
        invocable.setArgumentResolvers(this.requestMappingResolvers);
        invocable.setReactiveAdapterRegistry(this.reactiveAdapterRegistry);
        invocable.setMethodValidator(this.methodValidator);
        return invocable;
    }

    public List<SyncInvocableHandlerMethod> getInitBinderMethods(HandlerMethod handlerMethod) {
        ArrayList<SyncInvocableHandlerMethod> result = new ArrayList<SyncInvocableHandlerMethod>();
        Class handlerType = handlerMethod.getBeanType();
        this.initBinderAdviceCache.forEach((adviceBean, methods) -> {
            if (adviceBean.isApplicableToBeanType(handlerType)) {
                Object bean = adviceBean.resolveBean();
                methods.forEach(method -> result.add(this.getInitBinderMethod(bean, (Method)method)));
            }
        });
        this.initBinderMethodCache.computeIfAbsent(handlerType, clazz -> MethodIntrospector.selectMethods((Class)handlerType, (ReflectionUtils.MethodFilter)INIT_BINDER_METHODS)).forEach(method -> {
            Object bean = handlerMethod.getBean();
            result.add(this.getInitBinderMethod(bean, (Method)method));
        });
        return result;
    }

    private SyncInvocableHandlerMethod getInitBinderMethod(Object bean, Method method) {
        SyncInvocableHandlerMethod invocable = new SyncInvocableHandlerMethod(bean, method);
        invocable.setArgumentResolvers(this.initBinderResolvers);
        return invocable;
    }

    public List<InvocableHandlerMethod> getModelAttributeMethods(HandlerMethod handlerMethod) {
        ArrayList<InvocableHandlerMethod> result = new ArrayList<InvocableHandlerMethod>();
        Class handlerType = handlerMethod.getBeanType();
        this.modelAttributeAdviceCache.forEach((adviceBean, methods) -> {
            if (adviceBean.isApplicableToBeanType(handlerType)) {
                Object bean = adviceBean.resolveBean();
                methods.forEach(method -> result.add(this.createAttributeMethod(bean, (Method)method)));
            }
        });
        this.modelAttributeMethodCache.computeIfAbsent(handlerType, clazz -> MethodIntrospector.selectMethods((Class)handlerType, (ReflectionUtils.MethodFilter)MODEL_ATTRIBUTE_METHODS)).forEach(method -> {
            Object bean = handlerMethod.getBean();
            result.add(this.createAttributeMethod(bean, (Method)method));
        });
        return result;
    }

    private InvocableHandlerMethod createAttributeMethod(Object bean, Method method) {
        InvocableHandlerMethod invocable = new InvocableHandlerMethod(bean, method);
        invocable.setArgumentResolvers(this.modelAttributeResolvers);
        return invocable;
    }

    @Nullable
    public InvocableHandlerMethod getExceptionHandlerMethod(Throwable ex, @Nullable HandlerMethod handlerMethod) {
        Class handlerType = handlerMethod != null ? handlerMethod.getBeanType() : null;
        Object exceptionHandlerObject = null;
        Method exceptionHandlerMethod = null;
        if (handlerType != null) {
            exceptionHandlerObject = handlerMethod.getBean();
            exceptionHandlerMethod = this.exceptionHandlerCache.computeIfAbsent(handlerType, ExceptionHandlerMethodResolver::new).resolveMethodByThrowable(ex);
        }
        if (exceptionHandlerMethod == null) {
            for (Map.Entry<ControllerAdviceBean, ExceptionHandlerMethodResolver> entry : this.exceptionHandlerAdviceCache.entrySet()) {
                ControllerAdviceBean advice = entry.getKey();
                if (!advice.isApplicableToBeanType(handlerType) || (exceptionHandlerMethod = entry.getValue().resolveMethodByThrowable(ex)) == null) continue;
                exceptionHandlerObject = advice.resolveBean();
                break;
            }
        }
        if (exceptionHandlerObject == null || exceptionHandlerMethod == null) {
            return null;
        }
        InvocableHandlerMethod invocable = new InvocableHandlerMethod(exceptionHandlerObject, exceptionHandlerMethod);
        invocable.setArgumentResolvers(this.exceptionHandlerResolvers);
        return invocable;
    }

    public boolean hasMethodValidator() {
        return this.methodValidator != null;
    }

    public SessionAttributesHandler getSessionAttributesHandler(HandlerMethod handlerMethod) {
        Class handlerType = handlerMethod.getBeanType();
        return this.sessionAttributesHandlerCache.computeIfAbsent(handlerType, SessionAttributesHandler::new);
    }
}

