/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.security;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.exceptions.AuthTokenManagerExecutionException;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.internal.util.Futures;

public class ValidatingAuthTokenManager
implements AuthTokenManager {
    private final Logger log;
    private final AuthTokenManager delegate;

    public ValidatingAuthTokenManager(AuthTokenManager delegate, Logging logging) {
        Objects.requireNonNull(delegate, "delegate must not be null");
        Objects.requireNonNull(logging, "logging must not be null");
        this.delegate = delegate;
        this.log = logging.getLog(this.getClass());
    }

    @Override
    public CompletionStage<AuthToken> getToken() {
        CompletionStage<AuthToken> tokenStage;
        try {
            tokenStage = this.delegate.getToken();
        }
        catch (Throwable throwable2) {
            tokenStage = CompletableFuture.failedFuture(throwable2);
        }
        if (tokenStage == null) {
            tokenStage = CompletableFuture.failedFuture(new NullPointerException(String.format("null returned by %s.getToken method", this.delegate.getClass().getName())));
        }
        return tokenStage.thenApply(token -> Objects.requireNonNull(token, "token must not be null")).handle((token, throwable) -> {
            if (throwable != null) {
                throw new AuthTokenManagerExecutionException(String.format("invalid execution outcome on %s.getToken method", this.delegate.getClass().getName()), Futures.completionExceptionCause(throwable));
            }
            return token;
        });
    }

    @Override
    public boolean handleSecurityException(AuthToken authToken, SecurityException exception) {
        Objects.requireNonNull(authToken, "authToken must not be null");
        Objects.requireNonNull(exception, "exception must not be null");
        boolean retryable = false;
        try {
            retryable = this.delegate.handleSecurityException(authToken, exception);
        }
        catch (Throwable throwable) {
            this.log.warn(String.format("%s has been thrown by %s.onExpired method", throwable.getClass().getName(), this.delegate.getClass().getName()), new Object[0]);
            this.log.debug(String.format("%s has been thrown by %s.onExpired method", throwable.getClass().getName(), this.delegate.getClass().getName()), throwable);
        }
        return retryable;
    }
}

