/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.api.SerializableLibrary;
import com.oracle.truffle.nfi.backend.libffi.LibFFIContext;
import com.oracle.truffle.nfi.backend.libffi.LibFFIType;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentBuffer;
import com.oracle.truffle.nfi.backend.libffi.SerializeArgumentNodeFactory;
import java.nio.ByteOrder;

abstract class SerializeArgumentNode
extends Node {
    final LibFFIType.CachedTypeInfo type;

    SerializeArgumentNode(LibFFIType.CachedTypeInfo type) {
        this.type = type;
    }

    public final void serialize(Object arg, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
        buffer.align(this.type.alignment);
        this.execute(arg, buffer);
    }

    abstract void execute(Object var1, NativeArgumentBuffer var2) throws UnsupportedTypeException;

    @GenerateInline(value=false)
    static abstract class GetDoubleArrayTagNode
    extends GetTypeTagNode {
        GetDoubleArrayTagNode() {
        }

        @Specialization
        NativeArgumentBuffer.TypeTag doDoubleArray(double[] array) {
            assert (array != null);
            return NativeArgumentBuffer.TypeTag.DOUBLE_ARRAY;
        }
    }

    @GenerateInline(value=false)
    static abstract class GetFloatArrayTagNode
    extends GetTypeTagNode {
        GetFloatArrayTagNode() {
        }

        @Specialization
        NativeArgumentBuffer.TypeTag doFloatArray(float[] array) {
            assert (array != null);
            return NativeArgumentBuffer.TypeTag.FLOAT_ARRAY;
        }
    }

    @GenerateInline(value=false)
    static abstract class GetLongArrayTagNode
    extends GetTypeTagNode {
        GetLongArrayTagNode() {
        }

        @Specialization
        NativeArgumentBuffer.TypeTag doLongArray(long[] array) {
            assert (array != null);
            return NativeArgumentBuffer.TypeTag.LONG_ARRAY;
        }
    }

    @GenerateInline(value=false)
    static abstract class GetIntArrayTagNode
    extends GetTypeTagNode {
        GetIntArrayTagNode() {
        }

        @Specialization
        NativeArgumentBuffer.TypeTag doIntArray(int[] array) {
            assert (array != null);
            return NativeArgumentBuffer.TypeTag.INT_ARRAY;
        }
    }

    @GenerateInline(value=false)
    static abstract class GetShortArrayTagNode
    extends GetTypeTagNode {
        GetShortArrayTagNode() {
        }

        @Specialization
        NativeArgumentBuffer.TypeTag doShortArray(short[] array) {
            assert (array != null);
            return NativeArgumentBuffer.TypeTag.SHORT_ARRAY;
        }

        @Specialization
        NativeArgumentBuffer.TypeTag doCharArray(char[] array) {
            assert (array != null);
            return NativeArgumentBuffer.TypeTag.CHAR_ARRAY;
        }
    }

    @GenerateInline(value=false)
    static abstract class GetByteArrayTagNode
    extends GetTypeTagNode {
        GetByteArrayTagNode() {
        }

        @Specialization
        NativeArgumentBuffer.TypeTag doBooleanArray(boolean[] array) {
            assert (array != null);
            return NativeArgumentBuffer.TypeTag.BOOLEAN_ARRAY;
        }

        @Specialization
        NativeArgumentBuffer.TypeTag doByteArray(byte[] array) {
            assert (array != null);
            return NativeArgumentBuffer.TypeTag.BYTE_ARRAY;
        }
    }

    static abstract class SerializeArrayNode
    extends SerializeArgumentNode {
        @Node.Child
        GetTypeTagNode getTypeTag;

        SerializeArrayNode(LibFFIType.ArrayType type) {
            super(type);
            switch (type.elementType) {
                case UINT8: 
                case SINT8: {
                    this.getTypeTag = SerializeArgumentNodeFactory.GetByteArrayTagNodeGen.create();
                    break;
                }
                case UINT16: 
                case SINT16: {
                    this.getTypeTag = SerializeArgumentNodeFactory.GetShortArrayTagNodeGen.create();
                    break;
                }
                case UINT32: 
                case SINT32: {
                    this.getTypeTag = SerializeArgumentNodeFactory.GetIntArrayTagNodeGen.create();
                    break;
                }
                case UINT64: 
                case SINT64: {
                    this.getTypeTag = SerializeArgumentNodeFactory.GetLongArrayTagNodeGen.create();
                    break;
                }
                case FLOAT: {
                    this.getTypeTag = SerializeArgumentNodeFactory.GetFloatArrayTagNodeGen.create();
                    break;
                }
                case DOUBLE: {
                    this.getTypeTag = SerializeArgumentNodeFactory.GetDoubleArrayTagNodeGen.create();
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere((String)type.elementType.name());
                }
            }
        }

        final boolean isHostObject(Object value) {
            return LibFFIContext.get((Node)this).env.isHostObject(value);
        }

        final Object asHostObject(Object value) {
            return LibFFIContext.get((Node)this).env.asHostObject(value);
        }

        @Specialization(guards={"isHostObject(value)", "tag != null"})
        void doHostObject(Object value, NativeArgumentBuffer buffer, @Bind(value="asHostObject(value)") Object hostObject, @Bind(value="getTypeTag.execute(hostObject)") NativeArgumentBuffer.TypeTag tag) {
            buffer.putObject(tag, hostObject, this.type.size);
        }

        @Specialization(guards={"tag != null"})
        void doArray(Object value, NativeArgumentBuffer buffer, @Bind(value="getTypeTag.execute(value)") NativeArgumentBuffer.TypeTag tag) {
            buffer.putObject(tag, value, this.type.size);
        }

        @Fallback
        void doInteropObject(Object value, NativeArgumentBuffer buffer, @Cached(parameters={"type"}) SerializePointerNode serialize) throws UnsupportedTypeException {
            serialize.execute(value, buffer);
        }
    }

    static abstract class GetTypeTagNode
    extends Node {
        GetTypeTagNode() {
        }

        abstract NativeArgumentBuffer.TypeTag execute(Object var1);

        @Fallback
        NativeArgumentBuffer.TypeTag doOther(Object value) {
            return null;
        }
    }

    static final class SerializeEnvNode
    extends SerializeArgumentNode {
        SerializeEnvNode(LibFFIType.EnvType type) {
            super(type);
        }

        @Override
        void execute(Object value, NativeArgumentBuffer buffer) {
            assert (value == null);
            buffer.putObject(NativeArgumentBuffer.TypeTag.ENV, null, this.type.size);
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static abstract class SerializeNullableNode
    extends SerializeArgumentNode {
        SerializeNullableNode(LibFFIType.NullableType type) {
            super(type);
        }

        @Specialization(limit="3")
        void putObject(Object value, NativeArgumentBuffer buffer, @CachedLibrary(value="value") InteropLibrary interop) {
            if (interop.isNull(value)) {
                buffer.putPointer(0L, this.type.size);
            } else {
                buffer.putObject(NativeArgumentBuffer.TypeTag.OBJECT, value, this.type.size);
            }
        }
    }

    static final class SerializeObjectNode
    extends SerializeArgumentNode {
        SerializeObjectNode(LibFFIType.ObjectType type) {
            super(type);
        }

        @Override
        void execute(Object value, NativeArgumentBuffer buffer) {
            buffer.putObject(NativeArgumentBuffer.TypeTag.OBJECT, value, this.type.size);
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static abstract class SerializeStringNode
    extends SerializeArgumentNode {
        SerializeStringNode(LibFFIType.StringType type) {
            super(type);
        }

        @Specialization(limit="3", guards={"interop.isPointer(value)"}, rewriteOn={UnsupportedMessageException.class})
        void putPointer(Object value, NativeArgumentBuffer buffer, @CachedLibrary(value="value") InteropLibrary interop) throws UnsupportedMessageException {
            buffer.putPointerKeepalive(value, interop.asPointer(value), this.type.size);
        }

        @Specialization(limit="3", guards={"!interop.isPointer(value)", "interop.isString(value)"}, rewriteOn={UnsupportedMessageException.class})
        void putString(Object value, NativeArgumentBuffer buffer, @CachedLibrary(value="value") InteropLibrary interop) throws UnsupportedMessageException {
            buffer.putObject(NativeArgumentBuffer.TypeTag.STRING, interop.asString(value), this.type.size);
        }

        @Specialization(limit="3", guards={"!interop.isPointer(value)", "!interop.isString(value)", "interop.isNull(value)"})
        void putNull(Object value, NativeArgumentBuffer buffer, @CachedLibrary(value="value") InteropLibrary interop) {
            buffer.putPointer(0L, this.type.size);
        }

        @Specialization(limit="3", replaces={"putPointer", "putString", "putNull"})
        static void putGeneric(Object value, NativeArgumentBuffer buffer, @CachedLibrary(value="value") InteropLibrary interop, @Bind Node node, @Bind(value="type.size") int size, @Cached InlinedBranchProfile exception) throws UnsupportedTypeException {
            try {
                if (interop.isPointer(value)) {
                    buffer.putPointerKeepalive(value, interop.asPointer(value), size);
                    return;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            try {
                if (interop.isString(value)) {
                    buffer.putObject(NativeArgumentBuffer.TypeTag.STRING, interop.asString(value), size);
                    return;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter(node);
            if (!interop.isNull(value)) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value});
            }
            buffer.putPointer(0L, size);
        }
    }

    static abstract class SerializePointerNode
    extends SerializeArgumentNode {
        SerializePointerNode(LibFFIType.CachedTypeInfo type) {
            super(type);
        }

        @Specialization(limit="3", guards={"interop.isPointer(arg)"}, rewriteOn={UnsupportedMessageException.class})
        void putPointer(Object arg, NativeArgumentBuffer buffer, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedMessageException {
            buffer.putPointerKeepalive(arg, interop.asPointer(arg), this.type.size);
        }

        @Specialization(limit="3", guards={"!interop.isPointer(arg)", "interop.isNull(arg)"})
        void putNull(Object arg, NativeArgumentBuffer buffer, @CachedLibrary(value="arg") InteropLibrary interop) {
            buffer.putPointer(0L, this.type.size);
        }

        @Specialization(limit="3", replaces={"putPointer", "putNull"})
        static void putGeneric(Object arg, NativeArgumentBuffer buffer, @CachedLibrary(value="arg") InteropLibrary interop, @Bind Node node, @Bind(value="type.size") int size, @Cached InlinedBranchProfile exception) throws UnsupportedTypeException {
            try {
                if (!interop.isPointer(arg)) {
                    interop.toNative(arg);
                }
                if (interop.isPointer(arg)) {
                    buffer.putPointerKeepalive(arg, interop.asPointer(arg), size);
                    return;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter(node);
            if (interop.isNull(arg)) {
                buffer.putPointer(0L, size);
                return;
            }
            try {
                if (interop.isNumber(arg)) {
                    buffer.putPointer(interop.asLong(arg), size);
                    return;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            try {
                buffer.putPointerKeepalive(arg, interop.asPointer(arg), size);
                return;
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                throw UnsupportedTypeException.create((Object[])new Object[]{arg});
            }
        }
    }

    static abstract class SerializeSerializableNode
    extends SerializeArgumentNode {
        SerializeSerializableNode(LibFFIType.CachedTypeInfo type) {
            super(type);
        }

        @Specialization(limit="3", guards={"serialize.isSerializable(arg)"})
        void doSerializable(Object arg, NativeArgumentBuffer buffer, @CachedLibrary(value="arg") SerializableLibrary serialize) {
            BufferSlice b = new BufferSlice(buffer, buffer.position(), this.type.size);
            try {
                serialize.serialize(arg, (Object)b);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
            buffer.position(b.startOffset + this.type.size);
        }
    }

    @CompilerDirectives.ValueType
    @ExportLibrary(value=InteropLibrary.class)
    static final class BufferSlice
    implements TruffleObject {
        final NativeArgumentBuffer buffer;
        private final int startOffset;
        private final int limit;

        private BufferSlice(NativeArgumentBuffer buffer, int startOffset, int limit) {
            this.buffer = buffer;
            this.startOffset = startOffset;
            this.limit = limit;
        }

        private void setPosition(long offset, int size) throws InvalidBufferOffsetException {
            if (0L > offset || offset + (long)size > (long)this.limit) {
                throw InvalidBufferOffsetException.create((long)offset, (long)size);
            }
            this.buffer.position(this.startOffset + (int)offset);
        }

        @ExportMessage
        boolean hasBufferElements() {
            return true;
        }

        @ExportMessage
        boolean isBufferWritable() {
            return true;
        }

        @ExportMessage
        long getBufferSize() {
            return this.limit;
        }

        @ExportMessage
        boolean accepts(@Cached.Shared @Cached(value="this.buffer.getClass()") Class<? extends NativeArgumentBuffer> bufferType) {
            return this.buffer.getClass() == bufferType;
        }

        @ExportMessage
        void writeBufferByte(long offset, byte value, @Cached.Shared @Cached(value="this.buffer.getClass()") Class<? extends NativeArgumentBuffer> bufferType) throws InvalidBufferOffsetException {
            this.setPosition(offset, 1);
            ((NativeArgumentBuffer)CompilerDirectives.castExact((Object)this.buffer, bufferType)).putInt8(value);
        }

        @ExportMessage
        void writeBufferShort(ByteOrder order, long offset, short value, @Cached.Shared @Cached(value="this.buffer.getClass()") Class<? extends NativeArgumentBuffer> bufferType) throws InvalidBufferOffsetException {
            assert (order == ByteOrder.nativeOrder());
            this.setPosition(offset, 2);
            ((NativeArgumentBuffer)CompilerDirectives.castExact((Object)this.buffer, bufferType)).putInt16(value);
        }

        @ExportMessage
        void writeBufferInt(ByteOrder order, long offset, int value, @Cached.Shared @Cached(value="this.buffer.getClass()") Class<? extends NativeArgumentBuffer> bufferType) throws InvalidBufferOffsetException {
            assert (order == ByteOrder.nativeOrder());
            this.setPosition(offset, 4);
            ((NativeArgumentBuffer)CompilerDirectives.castExact((Object)this.buffer, bufferType)).putInt32(value);
        }

        @ExportMessage
        void writeBufferLong(ByteOrder order, long offset, long value, @Cached.Shared @Cached(value="this.buffer.getClass()") Class<? extends NativeArgumentBuffer> bufferType) throws InvalidBufferOffsetException {
            assert (order == ByteOrder.nativeOrder());
            this.setPosition(offset, 8);
            ((NativeArgumentBuffer)CompilerDirectives.castExact((Object)this.buffer, bufferType)).putInt64(value);
        }

        @ExportMessage
        void writeBufferFloat(ByteOrder order, long offset, float value, @Cached.Shared @Cached(value="this.buffer.getClass()") Class<? extends NativeArgumentBuffer> bufferType) throws InvalidBufferOffsetException {
            assert (order == ByteOrder.nativeOrder());
            this.setPosition(offset, 4);
            ((NativeArgumentBuffer)CompilerDirectives.castExact((Object)this.buffer, bufferType)).putFloat(value);
        }

        @ExportMessage
        void writeBufferDouble(ByteOrder order, long offset, double value, @Cached.Shared @Cached(value="this.buffer.getClass()") Class<? extends NativeArgumentBuffer> bufferType) throws InvalidBufferOffsetException {
            assert (order == ByteOrder.nativeOrder());
            this.setPosition(offset, 8);
            ((NativeArgumentBuffer)CompilerDirectives.castExact((Object)this.buffer, bufferType)).putDouble(value);
        }

        @ExportMessage
        byte readBufferByte(long offset) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @ExportMessage.Repeat(value={@ExportMessage(name="readBufferShort"), @ExportMessage(name="readBufferInt"), @ExportMessage(name="readBufferLong"), @ExportMessage(name="readBufferFloat"), @ExportMessage(name="readBufferDouble")})
        short readOther(ByteOrder order, long offset) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        void readBuffer(long offset, byte[] destination, int destinationOffset, int length) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    static final class SerializeDoubleNode
    extends SerializeArgumentNode {
        SerializeDoubleNode(LibFFIType.BasicType type) {
            super(type);
        }

        @Override
        void execute(Object arg, NativeArgumentBuffer buffer) {
            buffer.putDouble((Double)arg);
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class SerializeFloatVarargsNode
    extends SerializeArgumentNode {
        SerializeFloatVarargsNode(LibFFIType.BasicType type) {
            super(type);
        }

        @Override
        void execute(Object arg, NativeArgumentBuffer buffer) {
            buffer.putDouble(((Float)arg).floatValue());
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class SerializeFloatNode
    extends SerializeArgumentNode {
        SerializeFloatNode(LibFFIType.BasicType type) {
            super(type);
        }

        @Override
        void execute(Object arg, NativeArgumentBuffer buffer) {
            buffer.putFloat(((Float)arg).floatValue());
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class SerializeInt64Node
    extends SerializeArgumentNode {
        SerializeInt64Node(LibFFIType.BasicType type) {
            super(type);
        }

        @Override
        void execute(Object arg, NativeArgumentBuffer buffer) {
            buffer.putInt64((Long)arg);
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class SerializeInt32Node
    extends SerializeArgumentNode {
        SerializeInt32Node(LibFFIType.BasicType type) {
            super(type);
        }

        @Override
        void execute(Object arg, NativeArgumentBuffer buffer) {
            buffer.putInt32((Integer)arg);
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class SerializeUInt16VarargsNode
    extends SerializeArgumentNode {
        SerializeUInt16VarargsNode(LibFFIType.BasicType type) {
            super(type);
        }

        @Override
        void execute(Object arg, NativeArgumentBuffer buffer) {
            buffer.putInt32((int)((Short)arg & 0xFFFF));
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class SerializeInt16VarargsNode
    extends SerializeArgumentNode {
        SerializeInt16VarargsNode(LibFFIType.BasicType type) {
            super(type);
        }

        @Override
        void execute(Object arg, NativeArgumentBuffer buffer) {
            buffer.putInt32(((Short)arg).shortValue());
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class SerializeInt16Node
    extends SerializeArgumentNode {
        SerializeInt16Node(LibFFIType.BasicType type) {
            super(type);
        }

        @Override
        void execute(Object arg, NativeArgumentBuffer buffer) {
            buffer.putInt16((Short)arg);
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class SerializeUInt8VarargsNode
    extends SerializeArgumentNode {
        SerializeUInt8VarargsNode(LibFFIType.BasicType type) {
            super(type);
        }

        @Override
        void execute(Object arg, NativeArgumentBuffer buffer) {
            buffer.putInt32((int)((Byte)arg & 0xFF));
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class SerializeInt8VarargsNode
    extends SerializeArgumentNode {
        SerializeInt8VarargsNode(LibFFIType.BasicType type) {
            super(type);
        }

        @Override
        void execute(Object arg, NativeArgumentBuffer buffer) {
            buffer.putInt32(((Byte)arg).byteValue());
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class SerializeInt8Node
    extends SerializeArgumentNode {
        SerializeInt8Node(LibFFIType.BasicType type) {
            super(type);
        }

        @Override
        void execute(Object arg, NativeArgumentBuffer buffer) {
            buffer.putInt8((Byte)arg);
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

