/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgsNodeGen;
import com.oracle.graal.python.lib.PyObjectGetMethod;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallQuaternaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateCached
@GenerateInline(inlineByDefault=true)
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyObjectCallMethodObjArgs
extends Node {
    public static Object executeUncached(Object receiver, TruffleString name, Object ... arguments) {
        return PyObjectCallMethodObjArgsNodeGen.getUncached().executeInternal(null, null, receiver, name, arguments);
    }

    public static Object executeUncached(Frame frame, Object receiver, TruffleString name, Object ... arguments) {
        return PyObjectCallMethodObjArgsNodeGen.getUncached().executeInternal(frame, null, receiver, name, arguments);
    }

    public final Object executeCached(Frame frame, Object receiver, TruffleString name, Object ... arguments) {
        return this.executeInternal(frame, this, receiver, name, arguments);
    }

    public final Object execute(Frame frame, Node inliningTarget, Object receiver, TruffleString name, Object ... arguments) {
        return this.executeInternal(frame, inliningTarget, receiver, name, arguments);
    }

    protected abstract Object executeInternal(Frame var1, Node var2, Object var3, TruffleString var4, Object[] var5);

    @Specialization(guards={"arguments.length == 0"})
    static Object callUnary(Frame frame, Node inliningTarget, Object receiver, TruffleString name, Object[] arguments, @Cached.Shared(value="getMethod") @Cached PyObjectGetMethod getMethod, @Cached(inline=false) CallUnaryMethodNode callNode) {
        Object callable = getMethod.execute(frame, inliningTarget, receiver, name);
        return callNode.executeObject(frame, callable, receiver);
    }

    @Specialization(guards={"arguments.length == 1"})
    static Object callBinary(Frame frame, Node inliningTarget, Object receiver, TruffleString name, Object[] arguments, @Cached.Shared(value="getMethod") @Cached PyObjectGetMethod getMethod, @Cached(inline=false) CallBinaryMethodNode callNode) {
        Object callable = getMethod.execute(frame, inliningTarget, receiver, name);
        return callNode.executeObject(frame, callable, receiver, arguments[0]);
    }

    @Specialization(guards={"arguments.length == 2"})
    static Object callTernary(Frame frame, Node inliningTarget, Object receiver, TruffleString name, Object[] arguments, @Cached.Shared(value="getMethod") @Cached PyObjectGetMethod getMethod, @Cached(inline=false) CallTernaryMethodNode callNode) {
        Object callable = getMethod.execute(frame, inliningTarget, receiver, name);
        return callNode.execute(frame, callable, receiver, arguments[0], arguments[1]);
    }

    @Specialization(guards={"arguments.length == 3"})
    static Object callQuad(Frame frame, Node inliningTarget, Object receiver, TruffleString name, Object[] arguments, @Cached.Shared(value="getMethod") @Cached PyObjectGetMethod getMethod, @Cached(inline=false) CallQuaternaryMethodNode callNode) {
        Object callable = getMethod.execute(frame, inliningTarget, receiver, name);
        return callNode.execute(frame, callable, receiver, arguments[0], arguments[1], arguments[2]);
    }

    @Specialization(replaces={"callUnary", "callBinary", "callTernary", "callQuad"})
    static Object call(Frame frame, Node inliningTarget, Object receiver, TruffleString name, Object[] arguments, @Cached.Exclusive @Cached PyObjectGetMethod getMethod, @Cached(inline=false) CallNode callNode, @Cached.Exclusive @Cached InlinedConditionProfile isBoundProfile) {
        Object callable = getMethod.execute(frame, inliningTarget, receiver, name);
        if (isBoundProfile.profile(inliningTarget, callable instanceof BoundDescriptor)) {
            return callNode.execute(frame, ((BoundDescriptor)callable).descriptor, arguments, PKeyword.EMPTY_KEYWORDS);
        }
        Object[] unboundArguments = new Object[arguments.length + 1];
        unboundArguments[0] = receiver;
        PythonUtils.arraycopy(arguments, 0, unboundArguments, 1, arguments.length);
        return callNode.execute(frame, callable, unboundArguments, PKeyword.EMPTY_KEYWORDS);
    }

    @NeverDefault
    public static PyObjectCallMethodObjArgs create() {
        return PyObjectCallMethodObjArgsNodeGen.create();
    }

    public static PyObjectCallMethodObjArgs getUncached() {
        return PyObjectCallMethodObjArgsNodeGen.getUncached();
    }
}

