/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy.llvm;

import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.GraalHPyLLVMContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
public final class GraalHPyInitObject
implements TruffleObject {
    private static final String J_SET_HPY_CONTEXT_NATIVE_TYPE = "setHPyContextNativeType";
    private static final String J_SET_HPY_NATIVE_TYPE = "setHPyNativeType";
    private static final String J_SET_HPY_ARRAY_NATIVE_TYPE = "setHPyArrayNativeType";
    private static final String J_SET_NATIVE_CACHE_FUNCTION_PTR = "setNativeCacheFunctionPtr";
    private final GraalHPyLLVMContext backend;

    public GraalHPyInitObject(GraalHPyLLVMContext backend) {
        this.backend = backend;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        return new PythonAbstractObject.Keys(new String[]{J_SET_HPY_CONTEXT_NATIVE_TYPE, J_SET_HPY_NATIVE_TYPE, J_SET_HPY_ARRAY_NATIVE_TYPE, J_SET_NATIVE_CACHE_FUNCTION_PTR});
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInvocable(String key) {
        return switch (key) {
            case J_SET_HPY_CONTEXT_NATIVE_TYPE, J_SET_HPY_NATIVE_TYPE, J_SET_HPY_ARRAY_NATIVE_TYPE, J_SET_NATIVE_CACHE_FUNCTION_PTR -> true;
            default -> false;
        };
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object invokeMember(String key, Object[] arguments) throws UnsupportedMessageException, ArityException {
        if (arguments.length != 1) {
            throw ArityException.create((int)1, (int)1, (int)arguments.length);
        }
        switch (key) {
            case "setHPyContextNativeType": {
                this.backend.hpyContextNativeTypeID = arguments[0];
                break;
            }
            case "setHPyNativeType": {
                this.backend.hpyNativeTypeID = arguments[0];
                break;
            }
            case "setHPyArrayNativeType": {
                this.backend.hpyArrayNativeTypeID = arguments[0];
                break;
            }
            case "setNativeCacheFunctionPtr": {
                this.backend.setNativeSpaceFunction = arguments[0];
                break;
            }
            default: {
                throw UnsupportedMessageException.create();
            }
        }
        return 0;
    }
}

