/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.spring.file;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.springframework.web.multipart.MultipartFile;

public class MultipartFileWrapper
implements FileWrapper {
    private MultipartFile file;
    private String name;
    private String contentType;
    private InputStream inputStream;
    private Long size;

    public MultipartFileWrapper(MultipartFile file, String name, String contentType, Long size) {
        this.file = file;
        this.name = name;
        this.contentType = contentType;
        this.size = size;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new BufferedInputStream(this.file.getInputStream());
        }
        return this.inputStream;
    }

    public void transferTo(File dest) {
        try {
            this.file.transferTo(dest);
            IoUtil.close((Closeable)this.inputStream);
        }
        catch (Exception ignored) {
            try {
                FileUtil.writeFromStream((InputStream)this.getInputStream(), (File)dest);
            }
            catch (Exception e) {
                throw new FileStorageRuntimeException("\u6587\u4ef6\u79fb\u52a8\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public boolean supportTransfer() {
        return true;
    }

    public MultipartFile getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Long getSize() {
        return this.size;
    }

    public void setFile(MultipartFile file) {
        this.file = file;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public MultipartFileWrapper() {
    }
}

