/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.spring;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.FileStorageServiceBuilder;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.file.FileWrapperAdapter;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.recorder.DefaultFileRecorder;
import org.dromara.x.file.storage.core.recorder.FileRecorder;
import org.dromara.x.file.storage.core.tika.ContentTypeDetect;
import org.dromara.x.file.storage.core.tika.DefaultTikaFactory;
import org.dromara.x.file.storage.core.tika.TikaContentTypeDetect;
import org.dromara.x.file.storage.core.tika.TikaFactory;
import org.dromara.x.file.storage.spring.SpringFileStorageProperties;
import org.dromara.x.file.storage.spring.file.MultipartFileWrapperAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnMissingBean(value={FileStorageService.class})
public class FileStorageAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FileStorageAutoConfiguration.class);
    @Autowired
    private SpringFileStorageProperties properties;
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={FileRecorder.class})
    public FileRecorder fileRecorder() {
        log.warn("\u6ca1\u6709\u627e\u5230 FileRecorder \u7684\u5b9e\u73b0\u7c7b\uff0c\u6587\u4ef6\u4e0a\u4f20\u4e4b\u5916\u7684\u90e8\u5206\u529f\u80fd\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528\uff0c\u5fc5\u987b\u5b9e\u73b0\u8be5\u63a5\u53e3\u624d\u80fd\u4f7f\u7528\u5b8c\u6574\u529f\u80fd\uff01");
        return new DefaultFileRecorder();
    }

    @Bean
    @ConditionalOnMissingBean(value={TikaFactory.class})
    public TikaFactory tikaFactory() {
        return new DefaultTikaFactory();
    }

    @Bean
    @ConditionalOnMissingBean(value={ContentTypeDetect.class})
    public ContentTypeDetect contentTypeDetect(TikaFactory tikaFactory) {
        return new TikaContentTypeDetect(tikaFactory);
    }

    @Bean(destroyMethod="destroy")
    public FileStorageService fileStorageService(FileRecorder fileRecorder, @Autowired(required=false) List<List<? extends FileStorage>> fileStorageLists, @Autowired(required=false) List<FileStorageAspect> aspectList, @Autowired(required=false) List<FileWrapperAdapter> fileWrapperAdapterList, ContentTypeDetect contentTypeDetect, @Autowired(required=false) List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        long localPlusAccessNum;
        long localAccessNum;
        if (fileStorageLists == null) {
            fileStorageLists = new ArrayList<List<? extends FileStorage>>();
        }
        if (aspectList == null) {
            aspectList = new ArrayList<FileStorageAspect>();
        }
        if (fileWrapperAdapterList == null) {
            fileWrapperAdapterList = new ArrayList<FileWrapperAdapter>();
        }
        if (clientFactoryList == null) {
            clientFactoryList = new ArrayList();
        }
        FileStorageServiceBuilder builder = FileStorageServiceBuilder.create((FileStorageProperties)this.properties.toFileStorageProperties()).setFileRecorder(fileRecorder).setAspectList(aspectList).setContentTypeDetect(contentTypeDetect).setFileWrapperAdapterList(fileWrapperAdapterList).setClientFactoryList(clientFactoryList);
        fileStorageLists.forEach(arg_0 -> ((FileStorageServiceBuilder)builder).addFileStorage(arg_0));
        if (this.properties.getEnableByteFileWrapper().booleanValue()) {
            builder.addByteFileWrapperAdapter();
        }
        if (this.properties.getEnableUriFileWrapper().booleanValue()) {
            builder.addUriFileWrapperAdapter();
        }
        if (this.properties.getEnableInputStreamFileWrapper().booleanValue()) {
            builder.addInputStreamFileWrapperAdapter();
        }
        if (this.properties.getEnableLocalFileWrapper().booleanValue()) {
            builder.addLocalFileWrapperAdapter();
        }
        if (this.properties.getEnableHttpServletRequestFileWrapper().booleanValue()) {
            if (FileStorageServiceBuilder.doesNotExistClass((String)"javax.servlet.http.HttpServletRequest") && FileStorageServiceBuilder.doesNotExistClass((String)"jakarta.servlet.http.HttpServletRequest")) {
                log.warn("\u5f53\u524d\u672a\u68c0\u6d4b\u5230 Servlet \u73af\u5883\uff0c\u65e0\u6cd5\u52a0\u8f7d HttpServletRequest \u7684\u6587\u4ef6\u5305\u88c5\u9002\u914d\u5668\uff0c\u8bf7\u5c06\u53c2\u6570\u3010dromara.x-file-storage.enable-http-servlet-request-file-wrapper\u3011\u8bbe\u7f6e\u4e3a \u3010false\u3011\u6765\u6d88\u9664\u6b64\u8b66\u544a");
            } else {
                builder.addHttpServletRequestFileWrapperAdapter();
            }
        }
        if (this.properties.getEnableMultipartFileWrapper().booleanValue()) {
            if (FileStorageServiceBuilder.doesNotExistClass((String)"org.springframework.web.multipart.MultipartFile")) {
                log.warn("\u5f53\u524d\u672a\u68c0\u6d4b\u5230 SpringWeb \u73af\u5883\uff0c\u65e0\u6cd5\u52a0\u8f7d MultipartFile \u7684\u6587\u4ef6\u5305\u88c5\u9002\u914d\u5668\uff0c\u8bf7\u5c06\u53c2\u6570\u3010dromara.x-file-storage.enable-multipart-file-wrapper\u3011\u8bbe\u7f6e\u4e3a \u3010false\u3011\u6765\u6d88\u9664\u6b64\u8b66\u544a");
            } else {
                builder.addFileWrapperAdapter((FileWrapperAdapter)new MultipartFileWrapperAdapter());
            }
        }
        if (FileStorageServiceBuilder.doesNotExistClass((String)"org.springframework.web.servlet.config.annotation.WebMvcConfigurer") && (localAccessNum = this.properties.getLocal().stream().filter(SpringFileStorageProperties.SpringLocalConfig::getEnableStorage).filter(SpringFileStorageProperties.SpringLocalConfig::getEnableAccess).count()) + (localPlusAccessNum = this.properties.getLocalPlus().stream().filter(SpringFileStorageProperties.SpringLocalPlusConfig::getEnableStorage).filter(SpringFileStorageProperties.SpringLocalPlusConfig::getEnableAccess).count()) > 0L) {
            log.warn("\u5f53\u524d\u672a\u68c0\u6d4b\u5230 SpringWeb \u73af\u5883\uff0c\u65e0\u6cd5\u5f00\u542f\u672c\u5730\u5b58\u50a8\u5e73\u53f0\u7684\u672c\u5730\u8bbf\u95ee\u529f\u80fd\uff0c\u8bf7\u5c06\u5173\u95ed\u672c\u5730\u8bbf\u95ee\u6765\u6d88\u9664\u6b64\u8b66\u544a");
        }
        return builder.build();
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void onContextRefreshedEvent() {
        FileStorageService service = (FileStorageService)this.applicationContext.getBean(FileStorageService.class);
        service.setSelf(service);
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.web.servlet.config.annotation.WebMvcConfigurer"})
    public static class FileStorageLocalFileAccessAutoConfiguration {
        @Autowired
        private SpringFileStorageProperties properties;

        @Bean
        public WebMvcConfigurer fileStorageWebMvcConfigurer() {
            return new WebMvcConfigurer(){

                public void addResourceHandlers(@NonNull ResourceHandlerRegistry registry) {
                    if (registry == null) {
                        throw new NullPointerException("registry is marked non-null but is null");
                    }
                    for (SpringFileStorageProperties.SpringLocalConfig springLocalConfig : properties.getLocal()) {
                        if (!springLocalConfig.getEnableStorage().booleanValue() || !springLocalConfig.getEnableAccess().booleanValue()) continue;
                        registry.addResourceHandler(springLocalConfig.getPathPatterns()).addResourceLocations(new String[]{"file:" + springLocalConfig.getBasePath()});
                    }
                    for (SpringFileStorageProperties.SpringLocalPlusConfig springLocalPlusConfig : properties.getLocalPlus()) {
                        if (!springLocalPlusConfig.getEnableStorage().booleanValue() || !springLocalPlusConfig.getEnableAccess().booleanValue()) continue;
                        registry.addResourceHandler(springLocalPlusConfig.getPathPatterns()).addResourceLocations(new String[]{"file:" + springLocalPlusConfig.getStoragePath()});
                    }
                }
            };
        }
    }
}

