/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TrueTypeParser
extends AbstractParser {
    private static final long serialVersionUID = 44788554612243032L;
    private static final MediaType TYPE = MediaType.application((String)"x-font-ttf");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(TYPE);

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TikaInputStream tis = TikaInputStream.cast((InputStream)stream);
        try (TrueTypeFont font = null;){
            TTFParser parser = new TTFParser();
            font = tis != null && tis.hasFile() ? parser.parse(tis.getFile()) : parser.parse(stream);
            metadata.set("Content-Type", TYPE.toString());
            metadata.set(TikaCoreProperties.CREATED, font.getHeader().getCreated());
            metadata.set(TikaCoreProperties.MODIFIED, font.getHeader().getModified());
            metadata.set("DocVersion", Float.toString(font.getHeader().getVersion()));
            NamingTable fontNaming = font.getNaming();
            for (NameRecord nr : fontNaming.getNameRecords()) {
                if (nr.getNameId() == 1) {
                    metadata.set("FontFamilyName", nr.getString());
                }
                if (nr.getNameId() == 2) {
                    metadata.set("FontSubFamilyName", nr.getString());
                }
                if (nr.getNameId() == 4) {
                    metadata.set("FontName", nr.getString());
                    metadata.set(TikaCoreProperties.TITLE, nr.getString());
                }
                if (nr.getNameId() == 6) {
                    metadata.set("PSName", nr.getString());
                }
                if (nr.getNameId() == 0) {
                    metadata.set("Copyright", nr.getString());
                }
                if (nr.getNameId() != 7) continue;
                metadata.set("Trademark", nr.getString());
            }
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }
}

