/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.nkjp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import opennlp.tools.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NKJPTextDocument {
    private Map<String, String> divtypes = new HashMap<String, String>();
    private Map<String, Map<String, Map<String, String>>> texts = new HashMap<String, Map<String, Map<String, String>>>();

    NKJPTextDocument() {
    }

    NKJPTextDocument(Map<String, String> divtypes, Map<String, Map<String, Map<String, String>>> texts) {
        this();
        this.divtypes = divtypes;
        this.texts = texts;
    }

    public static NKJPTextDocument parse(InputStream is) throws IOException {
        HashMap<String, String> divtypes = new HashMap<String, String>();
        HashMap<String, Map<String, Map<String, String>>> texts = new HashMap<String, Map<String, Map<String, String>>>();
        try {
            DocumentBuilder docBuilder = XmlUtil.createDocumentBuilder();
            Document doc = docBuilder.parse(is);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression TEXT_NODES_EXAMPLE = xpath.compile("/teiCorpus/TEI/text/group/text");
            XPathExpression TEXT_NODES_SAMPLE = xpath.compile("/teiCorpus/TEI/text");
            XPathExpression DIV_NODES = xpath.compile("./body/div");
            XPathExpression PARA_NODES = xpath.compile("./p|./ab");
            doc.getDocumentElement().normalize();
            String root = doc.getDocumentElement().getNodeName();
            if (!root.equalsIgnoreCase("teiCorpus")) {
                throw new IOException("Expected root node " + root);
            }
            String current_text = "";
            NodeList textnl = (NodeList)TEXT_NODES_EXAMPLE.evaluate(doc, XPathConstants.NODESET);
            if (textnl.getLength() == 0) {
                textnl = (NodeList)TEXT_NODES_SAMPLE.evaluate(doc, XPathConstants.NODESET);
            }
            for (int i = 0; i < textnl.getLength(); ++i) {
                Node textnode = textnl.item(i);
                current_text = NKJPTextDocument.attrib(textnode, "xml:id", true);
                HashMap current_divs = new HashMap();
                NodeList divnl = (NodeList)DIV_NODES.evaluate(textnode, XPathConstants.NODESET);
                for (int j = 0; j < divnl.getLength(); ++j) {
                    Node divnode = divnl.item(j);
                    String divtype = NKJPTextDocument.attrib(divnode, "type", false);
                    String divid = NKJPTextDocument.attrib(divnode, "xml:id", true);
                    divtypes.put(divid, divtype);
                    HashMap<String, String> current_paras = new HashMap<String, String>();
                    NodeList paranl = (NodeList)PARA_NODES.evaluate(divnode, XPathConstants.NODESET);
                    for (int k = 0; k < paranl.getLength(); ++k) {
                        Node pnode = paranl.item(k);
                        String pid = NKJPTextDocument.attrib(pnode, "xml:id", true);
                        if (pnode.getChildNodes().getLength() != 1 && !pnode.getFirstChild().getNodeName().equals("#text")) {
                            throw new IOException("Unexpected content in p element " + pid);
                        }
                        String ptext = pnode.getTextContent();
                        current_paras.put(pid, ptext);
                    }
                    current_divs.put(divid, current_paras);
                }
                texts.put(current_text, current_divs);
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new IOException("Failed to parse NKJP document", e);
        }
        return new NKJPTextDocument(divtypes, texts);
    }

    static NKJPTextDocument parse(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            NKJPTextDocument nKJPTextDocument = NKJPTextDocument.parse(in);
            return nKJPTextDocument;
        }
    }

    Map<String, String> getDivtypes() {
        return Collections.unmodifiableMap(this.divtypes);
    }

    Map<String, Map<String, Map<String, String>>> getTexts() {
        return Collections.unmodifiableMap(this.texts);
    }

    Map<String, String> getParagraphs() {
        HashMap<String, String> paragraphs = new HashMap<String, String>();
        for (String dockey : this.texts.keySet()) {
            for (String divkey : this.texts.get(dockey).keySet()) {
                for (String pkey : this.texts.get(dockey).get(divkey).keySet()) {
                    paragraphs.put(pkey, this.texts.get(dockey).get(divkey).get(pkey));
                }
            }
        }
        return paragraphs;
    }

    private static String attrib(Node n, String attrib, boolean required) throws IOException {
        if (required && (n.getAttributes() == null || n.getAttributes().getLength() == 0)) {
            throw new IOException("Missing required attributes in node " + n.getNodeName());
        }
        if (n.getAttributes().getNamedItem(attrib) != null) {
            return n.getAttributes().getNamedItem(attrib).getTextContent();
        }
        if (required) {
            throw new IOException("Required attribute \"" + attrib + "\" missing in node " + n.getNodeName());
        }
        return null;
    }
}

