/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.letsmt;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.letsmt.DetokenizeSentenceSampleStream;
import opennlp.tools.formats.letsmt.LetsmtDocument;
import opennlp.tools.formats.letsmt.LetsmtSentenceStream;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.tokenize.DetokenizationDictionary;
import opennlp.tools.tokenize.DictionaryDetokenizer;
import opennlp.tools.util.ObjectStream;

public class LetsmtSentenceStreamFactory<P>
extends AbstractSampleStreamFactory<SentenceSample, P> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(SentenceSample.class, "letsmt", new LetsmtSentenceStreamFactory<Parameters>(Parameters.class));
    }

    protected LetsmtSentenceStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<SentenceSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        CmdLineUtil.checkInputFile("Data", params.getData());
        LetsmtDocument letsmtDoc = null;
        try {
            letsmtDoc = LetsmtDocument.parse(params.getData());
        }
        catch (IOException ex) {
            CmdLineUtil.handleCreateObjectStreamError(ex);
        }
        ObjectStream<SentenceSample> samples = new LetsmtSentenceStream(letsmtDoc);
        if (params.getDetokenizer() != null) {
            try {
                DictionaryDetokenizer detokenizer = new DictionaryDetokenizer(new DetokenizationDictionary(params.getDetokenizer()));
                samples = new DetokenizeSentenceSampleStream(detokenizer, samples);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Failed to load detokenizer rules!", e);
            }
        }
        return samples;
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="dictionary", description="specifies the file with detokenizer dictionary.")
        @ArgumentParser.OptionalParameter
        public File getDetokenizer();
    }
}

