/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.IOException;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.parser.ParserModelLoader;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.Parser;
import opennlp.tools.parser.ParserEvaluationMonitor;
import opennlp.tools.parser.ParserEvaluator;
import opennlp.tools.parser.ParserFactory;
import opennlp.tools.parser.ParserModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserEvaluatorTool
extends AbstractEvaluatorTool<Parse, EvaluatorParams> {
    private static final Logger logger = LoggerFactory.getLogger(ParserEvaluatorTool.class);

    public ParserEvaluatorTool() {
        super(Parse.class, EvaluatorParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the Parser model with the reference data";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        ParserModel model = (ParserModel)new ParserModelLoader().load(((EvaluatorParams)this.params).getModel());
        Parser parser = ParserFactory.create(model);
        ParserEvaluator evaluator = new ParserEvaluator(parser, new ParserEvaluationMonitor[0]);
        logger.info("Evaluating ... ");
        try {
            evaluator.evaluate(this.sampleStream);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        logger.info("done");
        logger.info(evaluator.getFMeasure().toString());
    }
}

