/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.doxia.site.Banner;
import org.apache.maven.doxia.site.Body;
import org.apache.maven.doxia.site.Logo;
import org.apache.maven.doxia.site.Menu;
import org.apache.maven.doxia.site.PublishDate;
import org.apache.maven.doxia.site.SiteUtils;
import org.apache.maven.doxia.site.Skin;
import org.apache.maven.doxia.site.Version;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class SiteModel
implements Serializable,
Cloneable {
    private String name;
    private String combineSelf = "merge";
    private Banner bannerLeft;
    private Banner bannerRight;
    private PublishDate publishDate;
    private Version version;
    private String edit;
    private List<Logo> poweredBy;
    private Skin skin;
    private Body body;
    private Object custom;
    private long lastModified = 0L;
    private String modelEncoding = "UTF-8";
    public static final String MERGE = "merge";
    public static final String OVERRIDE = "override";
    private Map<String, Menu> menusByRef;

    public void addPoweredBy(Logo logo) {
        this.getPoweredBy().add(logo);
    }

    public SiteModel clone() {
        try {
            SiteModel copy = (SiteModel)super.clone();
            if (this.bannerLeft != null) {
                copy.bannerLeft = this.bannerLeft.clone();
            }
            if (this.bannerRight != null) {
                copy.bannerRight = this.bannerRight.clone();
            }
            if (this.publishDate != null) {
                copy.publishDate = this.publishDate.clone();
            }
            if (this.version != null) {
                copy.version = this.version.clone();
            }
            if (this.poweredBy != null) {
                copy.poweredBy = new ArrayList<Logo>();
                for (Logo item : this.poweredBy) {
                    copy.poweredBy.add(item.clone());
                }
            }
            if (this.skin != null) {
                copy.skin = this.skin.clone();
            }
            if (this.body != null) {
                copy.body = this.body.clone();
            }
            if (this.custom != null) {
                copy.custom = new Xpp3Dom((Xpp3Dom)this.custom);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SiteModel)) {
            return false;
        }
        SiteModel that = (SiteModel)other;
        boolean result = true;
        boolean bl = result && (this.getName() == null ? that.getName() == null : this.getName().equals(that.getName())) ? true : (result = false);
        boolean bl2 = result && (this.getBannerLeft() == null ? that.getBannerLeft() == null : this.getBannerLeft().equals(that.getBannerLeft())) ? true : (result = false);
        boolean bl3 = result && (this.getBannerRight() == null ? that.getBannerRight() == null : this.getBannerRight().equals(that.getBannerRight())) ? true : (result = false);
        boolean bl4 = result && (this.getPublishDate() == null ? that.getPublishDate() == null : this.getPublishDate().equals(that.getPublishDate())) ? true : (result = false);
        boolean bl5 = result && (this.getVersion() == null ? that.getVersion() == null : this.getVersion().equals(that.getVersion())) ? true : (result = false);
        boolean bl6 = result && (this.getEdit() == null ? that.getEdit() == null : this.getEdit().equals(that.getEdit())) ? true : (result = false);
        boolean bl7 = result && (this.getPoweredBy() == null ? that.getPoweredBy() == null : this.getPoweredBy().equals(that.getPoweredBy())) ? true : (result = false);
        boolean bl8 = result && (this.getSkin() == null ? that.getSkin() == null : this.getSkin().equals(that.getSkin())) ? true : (result = false);
        boolean bl9 = result && (this.getBody() == null ? that.getBody() == null : this.getBody().equals(that.getBody())) ? true : (result = false);
        result = result && (this.getCustom() == null ? that.getCustom() == null : this.getCustom().equals(that.getCustom()));
        return result;
    }

    public Banner getBannerLeft() {
        return this.bannerLeft;
    }

    public Banner getBannerRight() {
        return this.bannerRight;
    }

    public Body getBody() {
        return this.body;
    }

    public String getCombineSelf() {
        return this.combineSelf;
    }

    public Object getCustom() {
        return this.custom;
    }

    public String getEdit() {
        return this.edit;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public String getName() {
        return this.name;
    }

    public List<Logo> getPoweredBy() {
        if (this.poweredBy == null) {
            this.poweredBy = new ArrayList<Logo>();
        }
        return this.poweredBy;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 37 * result + (this.bannerLeft != null ? this.bannerLeft.hashCode() : 0);
        result = 37 * result + (this.bannerRight != null ? this.bannerRight.hashCode() : 0);
        result = 37 * result + (this.publishDate != null ? this.publishDate.hashCode() : 0);
        result = 37 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 37 * result + (this.edit != null ? this.edit.hashCode() : 0);
        result = 37 * result + (this.poweredBy != null ? this.poweredBy.hashCode() : 0);
        result = 37 * result + (this.skin != null ? this.skin.hashCode() : 0);
        result = 37 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 37 * result + (this.custom != null ? this.custom.hashCode() : 0);
        return result;
    }

    public void removePoweredBy(Logo logo) {
        this.getPoweredBy().remove(logo);
    }

    public void setBannerLeft(Banner bannerLeft) {
        this.bannerLeft = bannerLeft;
    }

    public void setBannerRight(Banner bannerRight) {
        this.bannerRight = bannerRight;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public void setCombineSelf(String combineSelf) {
        this.combineSelf = combineSelf;
    }

    public void setCustom(Object custom) {
        this.custom = custom;
    }

    public void setEdit(String edit) {
        this.edit = edit;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPoweredBy(List<Logo> poweredBy) {
        this.poweredBy = poweredBy;
    }

    public void setPublishDate(PublishDate publishDate) {
        this.publishDate = publishDate;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("name = '");
        buf.append(this.getName());
        buf.append("'");
        buf.append("\n");
        buf.append("bannerLeft = '");
        buf.append(this.getBannerLeft());
        buf.append("'");
        buf.append("\n");
        buf.append("bannerRight = '");
        buf.append(this.getBannerRight());
        buf.append("'");
        buf.append("\n");
        buf.append("publishDate = '");
        buf.append(this.getPublishDate());
        buf.append("'");
        buf.append("\n");
        buf.append("version = '");
        buf.append(this.getVersion());
        buf.append("'");
        buf.append("\n");
        buf.append("edit = '");
        buf.append(this.getEdit());
        buf.append("'");
        buf.append("\n");
        buf.append("poweredBy = '");
        buf.append(this.getPoweredBy());
        buf.append("'");
        buf.append("\n");
        buf.append("skin = '");
        buf.append(this.getSkin());
        buf.append("'");
        buf.append("\n");
        buf.append("body = '");
        buf.append(this.getBody());
        buf.append("'");
        buf.append("\n");
        buf.append("custom = '");
        buf.append(this.getCustom());
        buf.append("'");
        return buf.toString();
    }

    public boolean isMergeParent() {
        return !OVERRIDE.equals(this.combineSelf);
    }

    public PublishDate getPublishDate() {
        if (this.publishDate == null) {
            return new PublishDate();
        }
        return this.publishDate;
    }

    public boolean isDefaultPublishDate() {
        return this.publishDate == null;
    }

    public Version getVersion() {
        if (this.version == null) {
            return new Version();
        }
        return this.version;
    }

    public boolean isDefaultVersion() {
        return this.version == null;
    }

    public Menu getMenuRef(String key) {
        if (this.menusByRef == null) {
            this.menusByRef = new HashMap<String, Menu>();
            if (this.body != null) {
                for (Menu menu : this.body.getMenus()) {
                    if (menu.getRef() == null) continue;
                    this.menusByRef.put(menu.getRef(), menu);
                }
            }
        }
        return this.menusByRef.get(key);
    }

    public void removeMenuRef(String key) {
        if (this.body != null) {
            Iterator<Menu> i = this.body.getMenus().iterator();
            while (i.hasNext()) {
                Menu menu = i.next();
                if (!key.equals(menu.getRef())) continue;
                i.remove();
            }
        }
    }

    public List<Menu> getMenus() {
        List<Menu> menus = this.body != null && this.body.getMenus() != null ? this.body.getMenus() : Collections.emptyList();
        return menus;
    }

    public boolean isLink(String href) {
        return SiteUtils.isLink(href);
    }

    public Object getCustomChild(String path) {
        return SiteUtils.getCustomChild((Xpp3Dom)this.custom, path);
    }

    public String getCustomValue(String path) {
        return SiteUtils.getCustomValue((Xpp3Dom)this.custom, path);
    }

    public String getCustomValue(String path, String defaultValue) {
        return SiteUtils.getCustomValue((Xpp3Dom)this.custom, path, defaultValue);
    }
}

