/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.utils;

import io.swagger.oas.inflector.Constants;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.HashMap;
import java.util.Map;

public class ExtensionsUtil {
    private Map<String, Schema> schemas;

    public void removeExtensions(OpenAPI openAPI) {
        if (openAPI.getComponents() == null || openAPI.getComponents().getSchemas() == null) {
            this.schemas = new HashMap<String, Schema>();
        } else {
            this.schemas = openAPI.getComponents().getSchemas();
            for (String name : this.schemas.keySet()) {
                Schema schema = this.schemas.get(name);
                if (schema.getExtensions() == null || !schema.getExtensions().containsKey(Constants.X_SWAGGER_ROUTER_MODEL)) continue;
                Map extensions = schema.getExtensions();
                Object value = extensions.get(Constants.X_SWAGGER_ROUTER_MODEL);
                extensions.remove(Constants.X_SWAGGER_ROUTER_MODEL, value);
            }
        }
        if (openAPI.getPaths() != null) {
            for (String pathname : openAPI.getPaths().keySet()) {
                PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)pathname);
                this.resolvePath(pathItem, false);
            }
        }
    }

    public void addExtensions(OpenAPI openAPI) {
        if (openAPI.getComponents() == null || openAPI.getComponents().getSchemas() == null) {
            this.schemas = new HashMap<String, Schema>();
        } else {
            this.schemas = openAPI.getComponents().getSchemas();
            for (String name : this.schemas.keySet()) {
                Schema schema = this.schemas.get(name);
                if (schema.getExtensions() != null) {
                    if (schema.getExtensions().containsKey(Constants.X_SWAGGER_ROUTER_MODEL)) continue;
                    schema.addExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
                    continue;
                }
                schema.addExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
            }
        }
        if (openAPI.getPaths() != null) {
            for (String pathname : openAPI.getPaths().keySet()) {
                PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)pathname);
                this.resolvePath(pathItem, true);
            }
        }
    }

    public void resolvePath(PathItem pathItem, boolean addExtensions) {
        for (Operation operation : pathItem.readOperations()) {
            Object controllerExtension;
            if (!addExtensions && operation.getExtensions() != null && (controllerExtension = (String)operation.getExtensions().get(Constants.X_SWAGGER_ROUTER_CONTROLLER)) != null) {
                operation.getExtensions().remove(Constants.X_SWAGGER_ROUTER_CONTROLLER, controllerExtension);
            }
            if (operation.getParameters() != null) {
                controllerExtension = operation.getParameters().iterator();
                while (controllerExtension.hasNext()) {
                    Object constants;
                    Schema resolved;
                    Parameter parameter = (Parameter)controllerExtension.next();
                    if (parameter.getSchema() != null && (resolved = parameter.getSchema()) != null) {
                        for (String name : this.schemas.keySet()) {
                            Schema schema = this.schemas.get(name);
                            if (!resolved.equals((Object)schema) || (constants = schema.getExtensions()) == null) continue;
                            String constant = (String)constants.get(Constants.X_SWAGGER_ROUTER_MODEL);
                            if (addExtensions) {
                                resolved.addExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)constant);
                                continue;
                            }
                            resolved.getExtensions().remove(Constants.X_SWAGGER_ROUTER_MODEL, constant);
                        }
                        parameter.setSchema(resolved);
                    }
                    if (parameter.getContent() == null) continue;
                    Content content = parameter.getContent();
                    for (String key : content.keySet()) {
                        Schema resolved2;
                        if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolved2 = ((MediaType)content.get(key)).getSchema()) == null) continue;
                        constants = this.schemas.keySet().iterator();
                        while (constants.hasNext()) {
                            Map constants2;
                            String name = (String)constants.next();
                            Schema schema = this.schemas.get(name);
                            if (!resolved2.equals((Object)schema) || (constants2 = schema.getExtensions()) == null) continue;
                            String constant = (String)constants2.get(Constants.X_SWAGGER_ROUTER_MODEL);
                            if (addExtensions) {
                                resolved2.addExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)constant);
                                continue;
                            }
                            resolved2.getExtensions().remove(Constants.X_SWAGGER_ROUTER_MODEL, constant);
                        }
                        ((MediaType)content.get(key)).setSchema(resolved2);
                    }
                }
            }
            if (operation.getCallbacks() != null) {
                Map callbacks = operation.getCallbacks();
                for (String name : callbacks.keySet()) {
                    Callback callback = (Callback)callbacks.get(name);
                    if (callback == null) continue;
                    for (String callbackName : callback.keySet()) {
                        PathItem path = (PathItem)callback.get((Object)callbackName);
                        if (path == null) continue;
                        this.resolvePath(path, addExtensions);
                    }
                }
            }
            if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null) {
                Content content = operation.getRequestBody().getContent();
                for (String key : content.keySet()) {
                    Schema resolved;
                    if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolved = ((MediaType)content.get(key)).getSchema()) == null) continue;
                    for (String name : this.schemas.keySet()) {
                        Map constants;
                        Schema schema = this.schemas.get(name);
                        if (!resolved.equals((Object)schema) || schema.getExtensions() == null || (constants = schema.getExtensions()) == null) continue;
                        String constant = (String)constants.get(Constants.X_SWAGGER_ROUTER_MODEL);
                        if (addExtensions) {
                            resolved.addExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)constant);
                            continue;
                        }
                        resolved.getExtensions().remove(Constants.X_SWAGGER_ROUTER_MODEL, constant);
                    }
                    ((MediaType)content.get(key)).setSchema(resolved);
                }
            }
            if (operation.getResponses() == null) continue;
            for (String code : operation.getResponses().keySet()) {
                ApiResponse response = (ApiResponse)operation.getResponses().get((Object)code);
                if (response.getContent() == null) continue;
                Content content = response.getContent();
                for (String mediaType : content.keySet()) {
                    Schema resolved;
                    if (((MediaType)content.get(mediaType)).getSchema() == null || (resolved = ((MediaType)content.get(mediaType)).getSchema()) == null) continue;
                    for (String name : this.schemas.keySet()) {
                        Map constants;
                        Schema schema = this.schemas.get(name);
                        if (!resolved.equals((Object)schema) || schema.getExtensions() == null || (constants = schema.getExtensions()) == null) continue;
                        String constant = (String)constants.get(Constants.X_SWAGGER_ROUTER_MODEL);
                        if (addExtensions) {
                            resolved.addExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)constant);
                            continue;
                        }
                        resolved.getExtensions().remove(Constants.X_SWAGGER_ROUTER_MODEL, constant);
                    }
                    ((MediaType)response.getContent().get((Object)mediaType)).setSchema(resolved);
                }
            }
        }
    }
}

