/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.spring.initializr.metadata.Link;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public final class LinkMapper {
    private static final JsonNodeFactory nodeFactory = JsonNodeFactory.instance;

    private LinkMapper() {
    }

    public static ObjectNode mapLinks(List<Link> links) {
        ObjectNode result = nodeFactory.objectNode();
        LinkedHashMap<String, List> byRel = new LinkedHashMap<String, List>();
        links.forEach(it -> byRel.computeIfAbsent(it.getRel(), k -> new ArrayList()).add(it));
        byRel.forEach((rel, l) -> {
            if (l.size() == 1) {
                ObjectNode root = JsonNodeFactory.instance.objectNode();
                LinkMapper.mapLink((Link)l.get(0), root);
                result.set(rel, (JsonNode)root);
            } else {
                ArrayNode root = JsonNodeFactory.instance.arrayNode();
                l.forEach(link -> {
                    ObjectNode node = JsonNodeFactory.instance.objectNode();
                    LinkMapper.mapLink(link, node);
                    root.add((JsonNode)node);
                });
                result.set(rel, (JsonNode)root);
            }
        });
        return result;
    }

    private static void mapLink(Link link, ObjectNode node) {
        node.put("href", link.getHref());
        if (link.isTemplated()) {
            node.put("templated", true);
        }
        if (link.getDescription() != null) {
            node.put("title", link.getDescription());
        }
    }
}

