/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.controller;

import io.spring.initializr.generator.buildsystem.BuildSystem;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.InitializrMetadataProvider;
import io.spring.initializr.web.project.InvalidProjectRequestException;
import io.spring.initializr.web.project.ProjectGenerationInvoker;
import io.spring.initializr.web.project.ProjectGenerationResult;
import io.spring.initializr.web.project.ProjectRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public abstract class ProjectGenerationController<R extends ProjectRequest> {
    private static final Log logger = LogFactory.getLog(ProjectGenerationController.class);
    private final InitializrMetadataProvider metadataProvider;
    private final ProjectGenerationInvoker<R> projectGenerationInvoker;

    public ProjectGenerationController(InitializrMetadataProvider metadataProvider, ProjectGenerationInvoker<R> projectGenerationInvoker) {
        this.metadataProvider = metadataProvider;
        this.projectGenerationInvoker = projectGenerationInvoker;
    }

    @ModelAttribute
    R projectRequest(@RequestHeader Map<String, String> headers, @RequestParam(name="style", required=false) String style) {
        if (style != null) {
            throw new InvalidProjectRequestException("Dependencies must be specified using 'dependencies'");
        }
        return this.projectRequest(headers);
    }

    public abstract R projectRequest(@RequestHeader Map<String, String> var1);

    protected InitializrMetadata getMetadata() {
        return this.metadataProvider.get();
    }

    @ExceptionHandler
    public void invalidProjectRequest(HttpServletResponse response, InvalidProjectRequestException ex) throws IOException {
        response.sendError(HttpStatus.BAD_REQUEST.value(), ex.getMessage());
    }

    @RequestMapping(path={"/pom", "/pom.xml"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<byte[]> pom(R request) {
        ((ProjectRequest)request).setType("maven-build");
        byte[] mavenPom = this.projectGenerationInvoker.invokeBuildGeneration(request);
        return this.createResponseEntity(mavenPom, "application/octet-stream", "pom.xml");
    }

    @RequestMapping(path={"/build", "/build.gradle"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<byte[]> gradle(R request) {
        ((ProjectRequest)request).setType("gradle-build");
        byte[] gradleBuild = this.projectGenerationInvoker.invokeBuildGeneration(request);
        return this.createResponseEntity(gradleBuild, "application/octet-stream", "build.gradle");
    }

    @RequestMapping(path={"/starter.zip"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<byte[]> springZip(R request) throws IOException {
        ProjectGenerationResult result = this.projectGenerationInvoker.invokeProjectStructureGeneration(request);
        Path archive = this.createArchive(result, "zip", ZipArchiveOutputStream::new, ZipArchiveEntry::new, ZipArchiveEntry::setUnixMode);
        return this.upload(archive, result.getRootDirectory(), this.generateFileName(result.getProjectDescription().getArtifactId(), "zip"), "application/zip");
    }

    @RequestMapping(path={"/starter.tgz"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/x-compress"})
    public ResponseEntity<byte[]> springTgz(R request) throws IOException {
        ProjectGenerationResult result = this.projectGenerationInvoker.invokeProjectStructureGeneration(request);
        Path archive = this.createArchive(result, "tar.gz", this::createTarArchiveOutputStream, TarArchiveEntry::new, TarArchiveEntry::setMode);
        return this.upload(archive, result.getRootDirectory(), this.generateFileName(result.getProjectDescription().getArtifactId(), "tar.gz"), "application/x-compress");
    }

    private TarArchiveOutputStream createTarArchiveOutputStream(OutputStream output) {
        try {
            TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream(output));
            out.setLongFileMode(3);
            return out;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private <T extends ArchiveEntry> Path createArchive(ProjectGenerationResult result, String fileExtension, Function<OutputStream, ? extends ArchiveOutputStream<T>> archiveOutputStream, BiFunction<File, String, T> archiveEntry, BiConsumer<T, Integer> setMode) throws IOException {
        Path archive = this.projectGenerationInvoker.createDistributionFile(result.getRootDirectory(), "." + fileExtension);
        String wrapperScript = ProjectGenerationController.getWrapperScript(result.getProjectDescription());
        try (ArchiveOutputStream output = archiveOutputStream.apply(Files.newOutputStream(archive, new OpenOption[0]));){
            Stream<Path> files;
            try (Stream<Path> stream = files = Files.walk(result.getRootDirectory(), new FileVisitOption[0]);){
                files.filter(path -> !result.getRootDirectory().equals(path)).forEach(path -> {
                    try {
                        String entryName = this.getEntryName(result.getRootDirectory(), (Path)path);
                        ArchiveEntry entry = (ArchiveEntry)archiveEntry.apply(path.toFile(), entryName);
                        setMode.accept(entry, this.getUnixMode(wrapperScript, entryName, (Path)path));
                        output.putArchiveEntry(entry);
                        if (!Files.isDirectory(path, new LinkOption[0])) {
                            Files.copy(path, (OutputStream)output);
                        }
                        output.closeArchiveEntry();
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException(ex);
                    }
                });
            }
        }
        return archive;
    }

    private String getEntryName(Path root, Path path) {
        Object entryName = root.relativize(path).toString().replace('\\', '/');
        if (Files.isDirectory(path, new LinkOption[0])) {
            entryName = (String)entryName + "/";
        }
        return entryName;
    }

    private int getUnixMode(String wrapperScript, String entryName, Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return 16877;
        }
        return 0x8000 | (entryName.equals(wrapperScript) ? 493 : 420);
    }

    private String generateFileName(String artifactId, String extension) {
        String candidate = StringUtils.hasText((String)artifactId) ? artifactId : this.metadataProvider.get().getArtifactId().getContent();
        return URLEncoder.encode(candidate, StandardCharsets.UTF_8) + "." + extension;
    }

    private static String getWrapperScript(ProjectDescription description) {
        BuildSystem buildSystem = description.getBuildSystem();
        String script = buildSystem.id().equals("maven") ? "mvnw" : "gradlew";
        return description.getBaseDirectory() != null ? description.getBaseDirectory() + "/" + script : script;
    }

    private ResponseEntity<byte[]> upload(Path archive, Path dir, String fileName, String contentType) throws IOException {
        byte[] bytes = Files.readAllBytes(archive);
        logger.info((Object)String.format("Uploading: %s (%s bytes)", archive, bytes.length));
        ResponseEntity<byte[]> result = this.createResponseEntity(bytes, contentType, fileName);
        this.projectGenerationInvoker.cleanTempFiles(dir);
        return result;
    }

    private ResponseEntity<byte[]> createResponseEntity(byte[] content, String contentType, String fileName) {
        String contentDispositionValue = "attachment; filename=\"" + fileName + "\"";
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{contentType})).header("Content-Disposition", new String[]{contentDispositionValue})).body((Object)content);
    }
}

