/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.spring.initializr.generator.version.InvalidVersionException;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.generator.version.VersionParser;
import io.spring.initializr.generator.version.VersionRange;
import io.spring.initializr.metadata.BillOfMaterials;
import io.spring.initializr.metadata.InvalidInitializrMetadataException;
import io.spring.initializr.metadata.Repository;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.StringUtils;

public class InitializrConfiguration {
    @NestedConfigurationProperty
    private final Env env = new Env();

    public Env getEnv() {
        return this.env;
    }

    public void validate() {
        this.env.validate();
    }

    public void merge(InitializrConfiguration other) {
        this.env.merge(other.env);
    }

    public String generateApplicationName(String name) {
        String candidate;
        if (!StringUtils.hasText((String)name)) {
            return this.env.fallbackApplicationName;
        }
        String text = InitializrConfiguration.splitCamelCase(name.trim());
        Object result = InitializrConfiguration.unsplitWords(text);
        if (!((String)result).endsWith("Application")) {
            result = (String)result + "Application";
        }
        if (InitializrConfiguration.hasInvalidChar(candidate = StringUtils.capitalize((String)result)) || this.env.invalidApplicationNames.contains(candidate)) {
            return this.env.fallbackApplicationName;
        }
        return candidate;
    }

    public String cleanPackageName(String packageName, String defaultPackageName) {
        if (!StringUtils.hasText((String)packageName)) {
            return defaultPackageName;
        }
        String candidate = InitializrConfiguration.cleanPackageName(packageName);
        if (!StringUtils.hasText((String)candidate)) {
            return defaultPackageName;
        }
        if (InitializrConfiguration.hasInvalidChar(candidate.replace(".", "")) || this.env.invalidPackageNames.contains(candidate)) {
            return defaultPackageName;
        }
        if (InitializrConfiguration.hasReservedKeyword(candidate)) {
            return defaultPackageName;
        }
        return candidate;
    }

    static String cleanPackageName(String packageName) {
        String[] elements = packageName.trim().replaceAll("-", "_").split("\\W+");
        StringBuilder sb = new StringBuilder();
        for (String element : elements) {
            if (!(element = element.replaceFirst("^[0-9]+(?!$)", "_")).matches("[0-9]+") && !sb.isEmpty()) {
                sb.append(".");
            }
            sb.append(element);
        }
        return sb.toString();
    }

    private static String unsplitWords(String text) {
        return String.join((CharSequence)"", (CharSequence[])Arrays.stream(text.split("([_\\- :])+")).map(StringUtils::capitalize).toArray(String[]::new));
    }

    private static String splitCamelCase(String text) {
        return String.join((CharSequence)"", (CharSequence[])Arrays.stream(text.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])")).map(it -> StringUtils.capitalize((String)it.toLowerCase())).toArray(String[]::new));
    }

    private static boolean hasInvalidChar(String text) {
        if (!Character.isJavaIdentifierStart(text.charAt(0))) {
            return true;
        }
        if (text.length() > 1) {
            for (int i = 1; i < text.length(); ++i) {
                if (Character.isJavaIdentifierPart(text.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasReservedKeyword(String packageName) {
        return Arrays.stream(packageName.split("\\.")).anyMatch(SourceVersion::isKeyword);
    }

    public static class Env {
        private String artifactRepository = "https://repo.spring.io/release/";
        private String springBootMetadataUrl = "https://api.spring.io/projects/spring-boot/releases";
        private String googleAnalyticsTrackingCode;
        private String fallbackApplicationName = "Application";
        private List<String> invalidApplicationNames = new ArrayList<String>(Arrays.asList("SpringApplication", "SpringBootApplication"));
        private List<String> invalidPackageNames = new ArrayList<String>(Collections.singletonList("org.springframework"));
        private boolean forceSsl;
        private final Map<String, BillOfMaterials> boms = new LinkedHashMap<String, BillOfMaterials>();
        private final Map<String, Repository> repositories = new LinkedHashMap<String, Repository>();
        @NestedConfigurationProperty
        private final Gradle gradle = new Gradle();
        @NestedConfigurationProperty
        private final Kotlin kotlin = new Kotlin();
        @NestedConfigurationProperty
        private final Maven maven = new Maven();
        @NestedConfigurationProperty
        private final Platform platform = new Platform();

        public Env() {
            try {
                this.repositories.put("spring-snapshots", new Repository("Spring Snapshots", new URL("https://repo.spring.io/snapshot"), false, true));
                this.repositories.put("spring-milestones", new Repository("Spring Milestones", new URL("https://repo.spring.io/milestone"), true, false));
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException("Cannot parse URL", ex);
            }
        }

        public String getSpringBootMetadataUrl() {
            return this.springBootMetadataUrl;
        }

        public void setSpringBootMetadataUrl(String springBootMetadataUrl) {
            this.springBootMetadataUrl = springBootMetadataUrl;
        }

        public String getGoogleAnalyticsTrackingCode() {
            return this.googleAnalyticsTrackingCode;
        }

        public void setGoogleAnalyticsTrackingCode(String googleAnalyticsTrackingCode) {
            this.googleAnalyticsTrackingCode = googleAnalyticsTrackingCode;
        }

        public String getFallbackApplicationName() {
            return this.fallbackApplicationName;
        }

        public void setFallbackApplicationName(String fallbackApplicationName) {
            this.fallbackApplicationName = fallbackApplicationName;
        }

        public List<String> getInvalidApplicationNames() {
            return this.invalidApplicationNames;
        }

        public void setInvalidApplicationNames(List<String> invalidApplicationNames) {
            this.invalidApplicationNames = invalidApplicationNames;
        }

        public List<String> getInvalidPackageNames() {
            return this.invalidPackageNames;
        }

        public void setInvalidPackageNames(List<String> invalidPackageNames) {
            this.invalidPackageNames = invalidPackageNames;
        }

        public boolean isForceSsl() {
            return this.forceSsl;
        }

        public void setForceSsl(boolean forceSsl) {
            this.forceSsl = forceSsl;
        }

        public String getArtifactRepository() {
            return this.artifactRepository;
        }

        public Map<String, BillOfMaterials> getBoms() {
            return this.boms;
        }

        public Map<String, Repository> getRepositories() {
            return this.repositories;
        }

        public Gradle getGradle() {
            return this.gradle;
        }

        public Kotlin getKotlin() {
            return this.kotlin;
        }

        public Maven getMaven() {
            return this.maven;
        }

        public Platform getPlatform() {
            return this.platform;
        }

        public void setArtifactRepository(String artifactRepository) {
            if (!((String)artifactRepository).endsWith("/")) {
                artifactRepository = (String)artifactRepository + "/";
            }
            this.artifactRepository = artifactRepository;
        }

        public void validate() {
            this.maven.parent.validate();
            this.boms.forEach((k, v) -> v.validate());
            this.kotlin.validate();
            this.updateCompatibilityRange(VersionParser.DEFAULT);
        }

        public void updateCompatibilityRange(VersionParser versionParser) {
            this.getBoms().values().forEach(it -> it.updateCompatibilityRange(versionParser));
            this.getKotlin().updateCompatibilityRange(versionParser);
            this.getPlatform().updateCompatibilityRange(versionParser);
        }

        public void merge(Env other) {
            this.artifactRepository = other.artifactRepository;
            this.springBootMetadataUrl = other.springBootMetadataUrl;
            this.googleAnalyticsTrackingCode = other.googleAnalyticsTrackingCode;
            this.fallbackApplicationName = other.fallbackApplicationName;
            this.invalidApplicationNames = other.invalidApplicationNames;
            this.forceSsl = other.forceSsl;
            this.gradle.merge(other.gradle);
            this.kotlin.merge(other.kotlin);
            this.maven.merge(other.maven);
            this.platform.merge(other.platform);
            other.boms.forEach(this.boms::putIfAbsent);
            other.repositories.forEach(this.repositories::putIfAbsent);
        }

        public static class Gradle {
            private String dependencyManagementPluginVersion = "1.0.0.RELEASE";

            private void merge(Gradle other) {
                this.dependencyManagementPluginVersion = other.dependencyManagementPluginVersion;
            }

            public String getDependencyManagementPluginVersion() {
                return this.dependencyManagementPluginVersion;
            }

            public void setDependencyManagementPluginVersion(String dependencyManagementPluginVersion) {
                this.dependencyManagementPluginVersion = dependencyManagementPluginVersion;
            }
        }

        public static class Kotlin {
            private String defaultVersion;
            private final List<Mapping> mappings = new ArrayList<Mapping>();

            public String resolveKotlinVersion(Version bootVersion) {
                for (Mapping mapping : this.mappings) {
                    if (!mapping.range.match(bootVersion)) continue;
                    return mapping.version;
                }
                if (this.defaultVersion == null) {
                    throw new InvalidInitializrMetadataException("No Kotlin version mapping available for " + bootVersion);
                }
                return this.defaultVersion;
            }

            public String getDefaultVersion() {
                return this.defaultVersion;
            }

            public void setDefaultVersion(String defaultVersion) {
                this.defaultVersion = defaultVersion;
            }

            public List<Mapping> getMappings() {
                return this.mappings;
            }

            public void validate() {
                this.mappings.forEach(m -> {
                    if (m.compatibilityRange == null) {
                        throw new InvalidInitializrMetadataException("CompatibilityRange is mandatory, invalid version mapping for " + this);
                    }
                    if (m.version == null) {
                        throw new InvalidInitializrMetadataException("Version is mandatory, invalid version mapping for " + this);
                    }
                });
                this.updateCompatibilityRange(VersionParser.DEFAULT);
            }

            public void updateCompatibilityRange(VersionParser versionParser) {
                this.mappings.forEach(it -> {
                    try {
                        it.range = versionParser.parseRange(it.compatibilityRange);
                    }
                    catch (InvalidVersionException ex) {
                        throw new InvalidInitializrMetadataException("Invalid compatibility range " + it.compatibilityRange + " for " + this, ex);
                    }
                });
            }

            private void merge(Kotlin other) {
                this.defaultVersion = other.defaultVersion;
                this.mappings.clear();
                this.mappings.addAll(other.mappings);
            }

            public static class Mapping {
                private String compatibilityRange;
                private String version;
                @JsonIgnore
                private VersionRange range;

                public String getCompatibilityRange() {
                    return this.compatibilityRange;
                }

                public void setCompatibilityRange(String compatibilityRange) {
                    this.compatibilityRange = compatibilityRange;
                }

                public String getVersion() {
                    return this.version;
                }

                public void setVersion(String version) {
                    this.version = version;
                }
            }
        }

        public static class Maven {
            private static final String DEFAULT_PARENT_GROUP_ID = "org.springframework.boot";
            private static final String DEFAULT_PARENT_ARTIFACT_ID = "spring-boot-starter-parent";
            private final ParentPom parent = new ParentPom();

            public ParentPom getParent() {
                return this.parent;
            }

            private void merge(Maven other) {
                this.parent.groupId = other.parent.groupId;
                this.parent.artifactId = other.parent.artifactId;
                this.parent.version = other.parent.version;
                this.parent.includeSpringBootBom = other.parent.includeSpringBootBom;
            }

            public ParentPom resolveParentPom(String bootVersion) {
                return StringUtils.hasText((String)this.parent.groupId) ? this.parent : new ParentPom(DEFAULT_PARENT_GROUP_ID, DEFAULT_PARENT_ARTIFACT_ID, bootVersion, "");
            }

            public boolean isSpringBootStarterParent(ParentPom parentPom) {
                return DEFAULT_PARENT_GROUP_ID.equals(parentPom.getGroupId()) && DEFAULT_PARENT_ARTIFACT_ID.equals(parentPom.getArtifactId());
            }

            public static class ParentPom {
                private String groupId;
                private String artifactId;
                private String version;
                private String relativePath = "";
                private boolean includeSpringBootBom;

                public ParentPom(String groupId, String artifactId, String version, String relativePath) {
                    this.groupId = groupId;
                    this.artifactId = artifactId;
                    this.version = version;
                    this.relativePath = relativePath;
                }

                public ParentPom() {
                }

                public String getGroupId() {
                    return this.groupId;
                }

                public void setGroupId(String groupId) {
                    this.groupId = groupId;
                }

                public String getArtifactId() {
                    return this.artifactId;
                }

                public void setArtifactId(String artifactId) {
                    this.artifactId = artifactId;
                }

                public String getVersion() {
                    return this.version;
                }

                public void setVersion(String version) {
                    this.version = version;
                }

                public String getRelativePath() {
                    return this.relativePath;
                }

                public void setRelativePath(String relativePath) {
                    this.relativePath = relativePath;
                }

                public boolean isIncludeSpringBootBom() {
                    return this.includeSpringBootBom;
                }

                public void setIncludeSpringBootBom(boolean includeSpringBootBom) {
                    this.includeSpringBootBom = includeSpringBootBom;
                }

                public void validate() {
                    if (!(!StringUtils.hasText((String)this.groupId) && !StringUtils.hasText((String)this.artifactId) && !StringUtils.hasText((String)this.version) || StringUtils.hasText((String)this.groupId) && StringUtils.hasText((String)this.artifactId) && StringUtils.hasText((String)this.version))) {
                        throw new InvalidInitializrMetadataException("Custom maven pom requires groupId, artifactId and version");
                    }
                }
            }
        }
    }

    public static class Platform {
        private String compatibilityRange;
        @JsonIgnore
        private VersionRange range;
        private String v1FormatCompatibilityRange;
        @JsonIgnore
        private VersionRange v1FormatRange;
        private String v2FormatCompatibilityRange;
        @JsonIgnore
        private VersionRange v2FormatRange;

        public void updateCompatibilityRange(VersionParser versionParser) {
            this.range = this.compatibilityRange != null ? versionParser.parseRange(this.compatibilityRange) : null;
            this.v1FormatRange = this.v1FormatCompatibilityRange != null ? versionParser.parseRange(this.v1FormatCompatibilityRange) : null;
            this.v2FormatRange = this.v2FormatCompatibilityRange != null ? versionParser.parseRange(this.v2FormatCompatibilityRange) : null;
        }

        private void merge(Platform other) {
            this.compatibilityRange = other.compatibilityRange;
            this.range = other.range;
            this.v1FormatCompatibilityRange = other.v1FormatCompatibilityRange;
            this.v1FormatRange = other.v1FormatRange;
            this.v2FormatCompatibilityRange = other.v2FormatCompatibilityRange;
            this.v2FormatRange = other.v2FormatRange;
        }

        public boolean isCompatibleVersion(Version platformVersion) {
            return this.range == null || this.range.match(platformVersion);
        }

        public String determineCompatibilityRangeRequirement() {
            return this.range.toString();
        }

        public Version formatPlatformVersion(Version platformVersion) {
            Version.Format format = this.getExpectedVersionFormat(platformVersion);
            return platformVersion.format(format);
        }

        private Version.Format getExpectedVersionFormat(Version version) {
            if (this.v2FormatRange != null && this.v2FormatRange.match(version)) {
                return Version.Format.V2;
            }
            if (this.v1FormatRange != null && this.v1FormatRange.match(version)) {
                return Version.Format.V1;
            }
            return version.getFormat();
        }

        public String getCompatibilityRange() {
            return this.compatibilityRange;
        }

        public void setCompatibilityRange(String compatibilityRange) {
            this.compatibilityRange = compatibilityRange;
        }

        public String getV1FormatCompatibilityRange() {
            return this.v1FormatCompatibilityRange;
        }

        public void setV1FormatCompatibilityRange(String v1FormatCompatibilityRange) {
            this.v1FormatCompatibilityRange = v1FormatCompatibilityRange;
        }

        public String getV2FormatCompatibilityRange() {
            return this.v2FormatCompatibilityRange;
        }

        public void setV2FormatCompatibilityRange(String v2FormatCompatibilityRange) {
            this.v2FormatCompatibilityRange = v2FormatCompatibilityRange;
        }
    }
}

