/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.version;

import io.spring.initializr.generator.version.InvalidVersionException;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.generator.version.VersionRange;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class VersionParser {
    public static final VersionParser DEFAULT = new VersionParser(Collections.emptyList());
    private static final Pattern VERSION_REGEX = Pattern.compile("^(\\d+)\\.(\\d+|x)\\.(\\d+|x)(?:([.|-])([^0-9]+)(\\d+)?)?$");
    private static final Pattern RANGE_REGEX = Pattern.compile("([(\\[])(.*),(.*)([)\\]])");
    private final List<Version> latestVersions;

    public VersionParser(List<Version> latestVersions) {
        this.latestVersions = latestVersions;
    }

    public Version parse(String text) {
        Assert.notNull((Object)text, (String)"Text must not be null");
        Matcher matcher = VERSION_REGEX.matcher(text.trim());
        if (!matcher.matches()) {
            throw new InvalidVersionException("Could not determine version based on '" + text + "': version format is Major.Minor.Patch and an optional Qualifier (e.g. 1.0.5.RELEASE)");
        }
        Integer major = Integer.valueOf(matcher.group(1));
        String minor = matcher.group(2);
        String patch = matcher.group(3);
        Version.Qualifier qualifier = this.parseQualifier(matcher);
        if ("x".equals(minor) || "x".equals(patch)) {
            Integer minorInt = "x".equals(minor) ? null : Integer.valueOf(Integer.parseInt(minor));
            Version latest = this.findLatestVersion(major, minorInt, qualifier);
            if (latest == null) {
                return new Version(major, "x".equals(minor) ? 999 : Integer.parseInt(minor), "x".equals(patch) ? 999 : Integer.parseInt(patch), qualifier);
            }
            return new Version(major, latest.getMinor(), latest.getPatch(), latest.getQualifier());
        }
        return new Version(major, Integer.parseInt(minor), Integer.parseInt(patch), qualifier);
    }

    private Version.Qualifier parseQualifier(Matcher matcher) {
        String qualifierSeparator = matcher.group(4);
        String qualifierId = matcher.group(5);
        if (StringUtils.hasText((String)qualifierSeparator) && StringUtils.hasText((String)qualifierId)) {
            String versionString = matcher.group(6);
            return new Version.Qualifier(qualifierId, versionString != null ? Integer.valueOf(versionString) : null, qualifierSeparator);
        }
        return null;
    }

    public Version safeParse(String text) {
        try {
            return this.parse(text);
        }
        catch (InvalidVersionException ex) {
            return null;
        }
    }

    public VersionRange parseRange(String text) {
        Assert.notNull((Object)text, (String)"Text must not be null");
        Matcher matcher = RANGE_REGEX.matcher(text.trim());
        if (!matcher.matches()) {
            Version version = this.parse(text);
            return new VersionRange(version, true, null, true);
        }
        boolean lowerInclusive = matcher.group(1).equals("[");
        Version lowerVersion = this.parse(matcher.group(2));
        Version higherVersion = this.parse(matcher.group(3));
        boolean higherInclusive = matcher.group(4).equals("]");
        return new VersionRange(lowerVersion, lowerInclusive, higherVersion, higherInclusive);
    }

    private Version findLatestVersion(Integer major, Integer minor, Version.Qualifier qualifier) {
        List<Version> matches = this.latestVersions.stream().filter(it -> {
            if (major != null && !major.equals(it.getMajor())) {
                return false;
            }
            if (minor != null && !minor.equals(it.getMinor())) {
                return false;
            }
            return qualifier == null || qualifier.equals(it.getQualifier());
        }).toList();
        return matches.size() != 1 ? null : matches.get(0);
    }
}

