/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.project.contributor;

import io.spring.initializr.generator.project.contributor.ProjectContributor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.FileCopyUtils;

public class SingleResourceProjectContributor
implements ProjectContributor {
    private final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private final String relativePath;
    private final String resourcePattern;

    public SingleResourceProjectContributor(String relativePath, String resourcePattern) {
        this.relativePath = relativePath;
        this.resourcePattern = resourcePattern;
    }

    @Override
    public void contribute(Path projectRoot) throws IOException {
        Path output = projectRoot.resolve(this.relativePath);
        if (!Files.exists(output, new LinkOption[0])) {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.createFile(output, new FileAttribute[0]);
        }
        Resource resource = this.resolver.getResource(this.resourcePattern);
        FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)Files.newOutputStream(output, StandardOpenOption.APPEND));
    }
}

