/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.project;

import io.spring.initializr.generator.project.ProjectAssetGenerator;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.project.ProjectDirectoryFactory;
import io.spring.initializr.generator.project.ProjectGenerationContext;
import io.spring.initializr.generator.project.contributor.ProjectContributor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class DefaultProjectAssetGenerator
implements ProjectAssetGenerator<Path> {
    private final ProjectDirectoryFactory projectDirectoryFactory;

    public DefaultProjectAssetGenerator(ProjectDirectoryFactory projectDirectoryFactory) {
        this.projectDirectoryFactory = projectDirectoryFactory;
    }

    public DefaultProjectAssetGenerator() {
        this(null);
    }

    @Override
    public Path generate(ProjectGenerationContext context) throws IOException {
        ProjectDescription description = (ProjectDescription)context.getBean(ProjectDescription.class);
        Path projectRoot = this.resolveProjectDirectoryFactory(context).createProjectDirectory(description);
        Path projectDirectory = this.initializerProjectDirectory(projectRoot, description);
        List contributors = context.getBeanProvider(ProjectContributor.class).orderedStream().toList();
        for (ProjectContributor contributor : contributors) {
            contributor.contribute(projectDirectory);
        }
        return projectRoot;
    }

    private ProjectDirectoryFactory resolveProjectDirectoryFactory(ProjectGenerationContext context) {
        return this.projectDirectoryFactory != null ? this.projectDirectoryFactory : (ProjectDirectoryFactory)context.getBean(ProjectDirectoryFactory.class);
    }

    private Path initializerProjectDirectory(Path rootDir, ProjectDescription description) throws IOException {
        Path projectDirectory = this.resolveProjectDirectory(rootDir, description);
        Files.createDirectories(projectDirectory, new FileAttribute[0]);
        return projectDirectory;
    }

    private Path resolveProjectDirectory(Path rootDir, ProjectDescription description) {
        if (description.getBaseDirectory() != null) {
            return rootDir.resolve(description.getBaseDirectory());
        }
        return rootDir;
    }
}

