/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import io.spring.initializr.generator.buildsystem.gradle.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class GradleTask {
    private final String name;
    private final String type;
    private final List<Attribute> attributes;
    private final List<Invocation> invocations;
    private final Map<String, GradleTask> nested;

    protected GradleTask(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.attributes = List.copyOf(builder.attributes.values());
        this.invocations = List.copyOf(builder.invocations);
        this.nested = Collections.unmodifiableMap(GradleTask.resolve(builder.nested));
    }

    private static Map<String, GradleTask> resolve(Map<String, Builder> tasks) {
        LinkedHashMap<String, GradleTask> result = new LinkedHashMap<String, GradleTask>();
        tasks.forEach((name, builder) -> result.put((String)name, builder.build()));
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public List<Invocation> getInvocations() {
        return this.invocations;
    }

    public Map<String, GradleTask> getNested() {
        return this.nested;
    }

    public static class Builder {
        private final String name;
        private final String type;
        private final Map<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();
        private final List<Invocation> invocations = new ArrayList<Invocation>();
        private final Map<String, Builder> nested = new LinkedHashMap<String, Builder>();

        protected Builder(String name, String type) {
            this.name = name;
            this.type = type;
        }

        protected Builder(String name) {
            this(name, null);
        }

        public void attribute(String target, String value) {
            this.attributes.put(target, Attribute.set(target, value));
        }

        public void append(String target, String value) {
            this.attributes.put(target, Attribute.append(target, value));
        }

        public void invoke(String target, String ... arguments) {
            this.invocations.add(new Invocation(target, Arrays.asList(arguments)));
        }

        public void nested(String property, Consumer<Builder> customizer) {
            customizer.accept(this.nested.computeIfAbsent(property, name -> new Builder(property)));
        }

        public GradleTask build() {
            return new GradleTask(this);
        }
    }

    @Deprecated(forRemoval=true)
    public static final class Attribute
    extends io.spring.initializr.generator.buildsystem.gradle.Attribute {
        private Attribute(String name, String value, Attribute.Type type) {
            super(name, value, type);
        }

        private static Attribute.Type toType(Type type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case Type.SET -> Attribute.Type.SET;
                case Type.APPEND -> Attribute.Type.APPEND;
            };
        }

        public static Attribute set(String name, String value) {
            return new Attribute(name, value, Attribute.Type.SET);
        }

        public static Attribute append(String name, String value) {
            return new Attribute(name, value, Attribute.Type.APPEND);
        }

        public static enum Type {
            SET,
            APPEND;

        }
    }

    @Deprecated(forRemoval=true)
    public static class Invocation
    extends io.spring.initializr.generator.buildsystem.gradle.Invocation {
        Invocation(String target, List<String> arguments) {
            super(target, arguments);
        }
    }
}

