/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem;

import java.util.Objects;

public class MavenRepository {
    public static final MavenRepository MAVEN_CENTRAL = MavenRepository.withIdAndUrl("maven-central", "https://repo.maven.apache.org/maven2").name("Maven Central").onlyReleases().build();
    private final String id;
    private final String name;
    private final String url;
    private final boolean releasesEnabled;
    private final boolean snapshotsEnabled;

    protected MavenRepository(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.url = builder.url;
        this.releasesEnabled = builder.releasesEnabled;
        this.snapshotsEnabled = builder.snapshotsEnabled;
    }

    public static Builder withIdAndUrl(String id, String url) {
        return new Builder(id, url);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isReleasesEnabled() {
        return this.releasesEnabled;
    }

    public boolean isSnapshotsEnabled() {
        return this.snapshotsEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRepository that = (MavenRepository)o;
        return this.releasesEnabled == that.releasesEnabled && this.snapshotsEnabled == that.snapshotsEnabled && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.url, this.releasesEnabled, this.snapshotsEnabled);
    }

    public static class Builder {
        private String id;
        private String name;
        private String url;
        private boolean releasesEnabled = true;
        private boolean snapshotsEnabled;

        public Builder(String id, String url) {
            this.id = id;
            this.name = id;
            this.url = url;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder releasesEnabled(boolean releasesEnabled) {
            this.releasesEnabled = releasesEnabled;
            return this;
        }

        public Builder snapshotsEnabled(boolean snapshotsEnabled) {
            this.snapshotsEnabled = snapshotsEnabled;
            return this;
        }

        public Builder onlyReleases() {
            return this.releasesEnabled(true).snapshotsEnabled(false);
        }

        public Builder onlySnapshots() {
            return this.snapshotsEnabled(true).releasesEnabled(false);
        }

        public MavenRepository build() {
            return new MavenRepository(this);
        }
    }
}

