/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.configuration;

import io.spring.initializr.generator.buildsystem.Build;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.project.contributor.ProjectContributor;
import io.spring.initializr.generator.spring.build.BuildMetadataResolver;
import io.spring.initializr.metadata.InitializrMetadata;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class WebFoldersContributor
implements ProjectContributor {
    private final Build build;
    private final BuildMetadataResolver buildMetadataResolver;

    public WebFoldersContributor(Build build, InitializrMetadata metadata, ProjectDescription projectDescription) {
        this.build = build;
        this.buildMetadataResolver = new BuildMetadataResolver(metadata, projectDescription.getPlatformVersion());
    }

    public void contribute(Path projectRoot) throws IOException {
        if (this.buildMetadataResolver.hasFacet(this.build, "web")) {
            Files.createDirectories(projectRoot.resolve("src/main/resources/templates"), new FileAttribute[0]);
            Files.createDirectories(projectRoot.resolve("src/main/resources/static"), new FileAttribute[0]);
        }
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }
}

