/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.build;

import io.spring.initializr.generator.buildsystem.Build;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.metadata.BillOfMaterials;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.Repository;
import io.spring.initializr.metadata.support.MetadataBuildItemMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class DependencyManagementBuildCustomizer
implements BuildCustomizer<Build> {
    private final ProjectDescription description;
    private final InitializrMetadata metadata;

    public DependencyManagementBuildCustomizer(ProjectDescription description, InitializrMetadata metadata) {
        this.description = description;
        this.metadata = metadata;
    }

    @Override
    public void customize(Build build) {
        this.contributeDependencyManagement(build);
    }

    @Override
    public int getOrder() {
        return 0x7FFFFFFA;
    }

    protected void contributeDependencyManagement(Build build) {
        LinkedHashMap<String, BillOfMaterials> resolvedBoms = new LinkedHashMap<String, BillOfMaterials>();
        LinkedHashMap repositories = new LinkedHashMap();
        this.mapDependencies(build).forEach(dependency -> {
            if (dependency.getBom() != null) {
                this.resolveBom(resolvedBoms, dependency.getBom(), this.description.getPlatformVersion());
            }
            if (dependency.getRepository() != null) {
                String repositoryId = dependency.getRepository();
                repositories.computeIfAbsent(repositoryId, key -> (Repository)this.metadata.getConfiguration().getEnv().getRepositories().get(key));
            }
        });
        resolvedBoms.values().forEach(bom -> bom.getRepositories().forEach(repositoryId -> repositories.computeIfAbsent(repositoryId, key -> (Repository)this.metadata.getConfiguration().getEnv().getRepositories().get(key))));
        resolvedBoms.forEach((key, bom) -> {
            build.boms().add(key, (Object)MetadataBuildItemMapper.toBom((BillOfMaterials)bom));
            if (bom.getVersionProperty() != null) {
                build.properties().version(bom.getVersionProperty(), bom.getVersion());
            }
        });
        repositories.keySet().forEach(id -> build.repositories().add(id));
    }

    private Stream<Dependency> mapDependencies(Build build) {
        return build.dependencies().ids().map(id -> this.metadata.getDependencies().get(id)).filter(Objects::nonNull).map(dependency -> dependency.resolve(this.description.getPlatformVersion()));
    }

    private void resolveBom(Map<String, BillOfMaterials> boms, String bomId, Version requestedVersion) {
        if (!boms.containsKey(bomId)) {
            BillOfMaterials bom = ((BillOfMaterials)this.metadata.getConfiguration().getEnv().getBoms().get(bomId)).resolve(requestedVersion);
            bom.getAdditionalBoms().forEach(id -> this.resolveBom(boms, (String)id, requestedVersion));
            boms.put(bomId, bom);
        }
    }
}

