/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.build;

import io.spring.initializr.generator.buildsystem.Build;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.build.BuildMetadataResolver;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.support.MetadataBuildItemMapper;

class DefaultStarterBuildCustomizer
implements BuildCustomizer<Build> {
    static final String DEFAULT_STARTER = "root_starter";
    private final BuildMetadataResolver buildResolver;

    DefaultStarterBuildCustomizer(InitializrMetadata metadata, ProjectDescription projectDescription) {
        this.buildResolver = new BuildMetadataResolver(metadata, projectDescription.getPlatformVersion());
    }

    @Override
    public void customize(Build build) {
        boolean hasStarter = this.buildResolver.dependencies(build).anyMatch(this::isValidStarter);
        if (!hasStarter) {
            Dependency root = Dependency.createSpringBootStarter((String)"");
            root.setId(DEFAULT_STARTER);
            build.dependencies().add((Object)DEFAULT_STARTER, (Object)MetadataBuildItemMapper.toDependency((Dependency)root));
        }
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private boolean isValidStarter(Dependency dependency) {
        return dependency.isStarter() && "compile".equals(dependency.getScope());
    }
}

