/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpClientInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpServerInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.incubator.config.internal.CommonConfig;
import io.opentelemetry.instrumentation.api.incubator.config.internal.InstrumentationConfig;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.ConfigPropertiesBridge;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.function.Function;

public final class InstrumentationConfigUtil {
    private InstrumentationConfigUtil() {
    }

    @CanIgnoreReturnValue
    public static <T, CLIENTREQUEST, CLIENTRESPONSE, SERVERREQUEST, SERVERRESPONSE> T configureClientAndServerBuilder(ConfigProperties config, T builder, Function<T, DefaultHttpClientInstrumenterBuilder<CLIENTREQUEST, CLIENTRESPONSE>> getClientBuilder, Function<T, DefaultHttpServerInstrumenterBuilder<SERVERREQUEST, SERVERRESPONSE>> getServerBuilder) {
        CommonConfig commonConfig = InstrumentationConfigUtil.getConfig(config);
        getClientBuilder.apply(builder).configure(commonConfig);
        getServerBuilder.apply(builder).configure(commonConfig);
        return builder;
    }

    @CanIgnoreReturnValue
    public static <T, REQUEST, RESPONSE> T configureClientBuilder(ConfigProperties config, T builder, Function<T, DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE>> getBuilder) {
        getBuilder.apply(builder).configure(InstrumentationConfigUtil.getConfig(config));
        return builder;
    }

    @CanIgnoreReturnValue
    public static <T, REQUEST, RESPONSE> T configureServerBuilder(ConfigProperties config, T builder, Function<T, DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE>> getBuilder) {
        getBuilder.apply(builder).configure(InstrumentationConfigUtil.getConfig(config));
        return builder;
    }

    private static CommonConfig getConfig(ConfigProperties config) {
        return new CommonConfig((InstrumentationConfig)new ConfigPropertiesBridge(config));
    }

    public static boolean isStatementSanitizationEnabled(ConfigProperties config, String key) {
        return config.getBoolean(key, config.getBoolean("otel.instrumentation.common.db-statement-sanitizer.enabled", true));
    }
}

