/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.webflux;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.InstrumentationConfigUtil;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.SpringWebfluxTelemetry;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.SpringWebfluxBuilderUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.reactive.function.client.WebClient;

final class WebClientBeanPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<OpenTelemetry> openTelemetryProvider;
    private final ObjectProvider<ConfigProperties> configPropertiesProvider;

    WebClientBeanPostProcessor(ObjectProvider<OpenTelemetry> openTelemetryProvider, ObjectProvider<ConfigProperties> configPropertiesProvider) {
        this.openTelemetryProvider = openTelemetryProvider;
        this.configPropertiesProvider = configPropertiesProvider;
    }

    static SpringWebfluxTelemetry getWebfluxTelemetry(OpenTelemetry openTelemetry, ConfigProperties config) {
        return InstrumentationConfigUtil.configureClientAndServerBuilder(config, SpringWebfluxTelemetry.builder((OpenTelemetry)openTelemetry), SpringWebfluxBuilderUtil.getClientBuilderExtractor(), SpringWebfluxBuilderUtil.getServerBuilderExtractor()).build();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof WebClient) {
            WebClient webClient = (WebClient)bean;
            return this.wrapBuilder(webClient.mutate()).build();
        }
        if (bean instanceof WebClient.Builder) {
            WebClient.Builder webClientBuilder = (WebClient.Builder)bean;
            return this.wrapBuilder(webClientBuilder);
        }
        return bean;
    }

    private WebClient.Builder wrapBuilder(WebClient.Builder webClientBuilder) {
        SpringWebfluxTelemetry instrumentation = WebClientBeanPostProcessor.getWebfluxTelemetry((OpenTelemetry)this.openTelemetryProvider.getObject(), (ConfigProperties)this.configPropertiesProvider.getObject());
        return webClientBuilder.filters(arg_0 -> ((SpringWebfluxTelemetry)instrumentation).addClientTracingFilter(arg_0));
    }
}

