/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientSpanNameExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.network.ServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.network.ServerAttributesGetter;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.internal.DbExecution;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.internal.R2dbcNetAttributesGetter;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.internal.R2dbcSqlAttributesGetter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class R2dbcInstrumenterBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.r2dbc-1.0";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<DbExecution, Void>> additionalExtractors = new ArrayList<AttributesExtractor<DbExecution, Void>>();

    public R2dbcInstrumenterBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public R2dbcInstrumenterBuilder addAttributeExtractor(AttributesExtractor<DbExecution, Void> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    public Instrumenter<DbExecution, Void> build(Function<SpanNameExtractor<DbExecution>, ? extends SpanNameExtractor<? super DbExecution>> spanNameExtractorTransformer, boolean statementSanitizationEnabled) {
        SpanNameExtractor<? super DbExecution> spanNameExtractor = spanNameExtractorTransformer.apply((SpanNameExtractor<DbExecution>)DbClientSpanNameExtractor.create((SqlClientAttributesGetter)R2dbcSqlAttributesGetter.INSTANCE));
        return Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, spanNameExtractor).addAttributesExtractor(SqlClientAttributesExtractor.builder((SqlClientAttributesGetter)R2dbcSqlAttributesGetter.INSTANCE).setStatementSanitizationEnabled(statementSanitizationEnabled).build()).addAttributesExtractor((AttributesExtractor)ServerAttributesExtractor.create((ServerAttributesGetter)R2dbcNetAttributesGetter.INSTANCE)).addAttributesExtractors(this.additionalExtractors).buildInstrumenter(SpanKindExtractor.alwaysClient());
    }
}

