/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class McpServerFeatures {

    public record SyncCompletionSpecification(McpSchema.CompleteReference referenceKey, BiFunction<McpSyncServerExchange, McpSchema.CompleteRequest, McpSchema.CompleteResult> completionHandler) {
    }

    public record SyncPromptSpecification(McpSchema.Prompt prompt, BiFunction<McpSyncServerExchange, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler) {
    }

    public record SyncResourceTemplateSpecification(McpSchema.ResourceTemplate resourceTemplate, BiFunction<McpSyncServerExchange, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler) {
    }

    public record SyncResourceSpecification(McpSchema.Resource resource, BiFunction<McpSyncServerExchange, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler) {
    }

    public record SyncToolSpecification(McpSchema.Tool tool, @Deprecated BiFunction<McpSyncServerExchange, Map<String, Object>, McpSchema.CallToolResult> call, BiFunction<McpSyncServerExchange, McpSchema.CallToolRequest, McpSchema.CallToolResult> callHandler) {
        @Deprecated
        public SyncToolSpecification(McpSchema.Tool tool, BiFunction<McpSyncServerExchange, Map<String, Object>, McpSchema.CallToolResult> call) {
            this(tool, call, (exchange, toolReq) -> (McpSchema.CallToolResult)call.apply((McpSyncServerExchange)exchange, toolReq.arguments()));
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private McpSchema.Tool tool;
            private BiFunction<McpSyncServerExchange, McpSchema.CallToolRequest, McpSchema.CallToolResult> callHandler;

            public Builder tool(McpSchema.Tool tool) {
                this.tool = tool;
                return this;
            }

            public Builder callHandler(BiFunction<McpSyncServerExchange, McpSchema.CallToolRequest, McpSchema.CallToolResult> callHandler) {
                this.callHandler = callHandler;
                return this;
            }

            public SyncToolSpecification build() {
                Assert.notNull(this.tool, "Tool must not be null");
                Assert.notNull(this.callHandler, "CallTool function must not be null");
                return new SyncToolSpecification(this.tool, null, this.callHandler);
            }
        }
    }

    public record AsyncCompletionSpecification(McpSchema.CompleteReference referenceKey, BiFunction<McpAsyncServerExchange, McpSchema.CompleteRequest, Mono<McpSchema.CompleteResult>> completionHandler) {
        static AsyncCompletionSpecification fromSync(SyncCompletionSpecification completion, boolean immediateExecution) {
            if (completion == null) {
                return null;
            }
            return new AsyncCompletionSpecification(completion.referenceKey(), (exchange, request) -> {
                Mono completionResult = Mono.fromCallable(() -> completion.completionHandler().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (McpSchema.CompleteRequest)request));
                return immediateExecution ? completionResult : completionResult.subscribeOn(Schedulers.boundedElastic());
            });
        }
    }

    public record AsyncPromptSpecification(McpSchema.Prompt prompt, BiFunction<McpAsyncServerExchange, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler) {
        static AsyncPromptSpecification fromSync(SyncPromptSpecification prompt, boolean immediateExecution) {
            if (prompt == null) {
                return null;
            }
            return new AsyncPromptSpecification(prompt.prompt(), (exchange, req) -> {
                Mono promptResult = Mono.fromCallable(() -> prompt.promptHandler().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (McpSchema.GetPromptRequest)req));
                return immediateExecution ? promptResult : promptResult.subscribeOn(Schedulers.boundedElastic());
            });
        }
    }

    public record AsyncResourceTemplateSpecification(McpSchema.ResourceTemplate resourceTemplate, BiFunction<McpAsyncServerExchange, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler) {
        static AsyncResourceTemplateSpecification fromSync(SyncResourceTemplateSpecification resource, boolean immediateExecution) {
            if (resource == null) {
                return null;
            }
            return new AsyncResourceTemplateSpecification(resource.resourceTemplate(), (exchange, req) -> {
                Mono resourceResult = Mono.fromCallable(() -> resource.readHandler().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (McpSchema.ReadResourceRequest)req));
                return immediateExecution ? resourceResult : resourceResult.subscribeOn(Schedulers.boundedElastic());
            });
        }
    }

    public record AsyncResourceSpecification(McpSchema.Resource resource, BiFunction<McpAsyncServerExchange, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler) {
        static AsyncResourceSpecification fromSync(SyncResourceSpecification resource, boolean immediateExecution) {
            if (resource == null) {
                return null;
            }
            return new AsyncResourceSpecification(resource.resource(), (exchange, req) -> {
                Mono resourceResult = Mono.fromCallable(() -> resource.readHandler().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (McpSchema.ReadResourceRequest)req));
                return immediateExecution ? resourceResult : resourceResult.subscribeOn(Schedulers.boundedElastic());
            });
        }
    }

    public record AsyncToolSpecification(McpSchema.Tool tool, @Deprecated BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> call, BiFunction<McpAsyncServerExchange, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler) {
        @Deprecated
        public AsyncToolSpecification(McpSchema.Tool tool, BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> call) {
            this(tool, call, (exchange, toolReq) -> (Mono)call.apply((McpAsyncServerExchange)exchange, toolReq.arguments()));
        }

        static AsyncToolSpecification fromSync(SyncToolSpecification syncToolSpec) {
            return AsyncToolSpecification.fromSync(syncToolSpec, false);
        }

        static AsyncToolSpecification fromSync(SyncToolSpecification syncToolSpec, boolean immediate) {
            if (syncToolSpec == null) {
                return null;
            }
            BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> deprecatedCall = syncToolSpec.call() != null ? (exchange, map) -> {
                Mono toolResult = Mono.fromCallable(() -> syncToolSpec.call().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (Map<String, Object>)map));
                return immediate ? toolResult : toolResult.subscribeOn(Schedulers.boundedElastic());
            } : null;
            BiFunction<McpAsyncServerExchange, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler = (exchange, req) -> {
                Mono toolResult = Mono.fromCallable(() -> syncToolSpec.callHandler().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (McpSchema.CallToolRequest)req));
                return immediate ? toolResult : toolResult.subscribeOn(Schedulers.boundedElastic());
            };
            return new AsyncToolSpecification(syncToolSpec.tool(), deprecatedCall, callHandler);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private McpSchema.Tool tool;
            private BiFunction<McpAsyncServerExchange, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler;

            public Builder tool(McpSchema.Tool tool) {
                this.tool = tool;
                return this;
            }

            public Builder callHandler(BiFunction<McpAsyncServerExchange, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler) {
                this.callHandler = callHandler;
                return this;
            }

            public AsyncToolSpecification build() {
                Assert.notNull(this.tool, "Tool must not be null");
                Assert.notNull(this.callHandler, "Call handler function must not be null");
                return new AsyncToolSpecification(this.tool, null, this.callHandler);
            }
        }
    }

    record Sync(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<SyncToolSpecification> tools, Map<String, SyncResourceSpecification> resources, Map<String, SyncResourceTemplateSpecification> resourceTemplates, Map<String, SyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, SyncCompletionSpecification> completions, List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeConsumers, String instructions) {
        Sync(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<SyncToolSpecification> tools, Map<String, SyncResourceSpecification> resources, Map<String, SyncResourceTemplateSpecification> resourceTemplates, Map<String, SyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, SyncCompletionSpecification> completions, List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeConsumers, String instructions) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities(null, null, new McpSchema.ServerCapabilities.LoggingCapabilities(), !Utils.isEmpty(prompts) ? new McpSchema.ServerCapabilities.PromptCapabilities(false) : null, !Utils.isEmpty(resources) ? new McpSchema.ServerCapabilities.ResourceCapabilities(false, false) : null, !Utils.isEmpty(tools) ? new McpSchema.ServerCapabilities.ToolCapabilities(false) : null);
            this.tools = tools != null ? tools : new ArrayList();
            this.resources = resources != null ? resources : new HashMap();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : Map.of();
            this.prompts = prompts != null ? prompts : new HashMap();
            this.completions = completions != null ? completions : new HashMap();
            this.rootsChangeConsumers = rootsChangeConsumers != null ? rootsChangeConsumers : new ArrayList();
            this.instructions = instructions;
        }
    }

    record Async(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<AsyncToolSpecification> tools, Map<String, AsyncResourceSpecification> resources, Map<String, AsyncResourceTemplateSpecification> resourceTemplates, Map<String, AsyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, AsyncCompletionSpecification> completions, List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers, String instructions) {
        Async(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<AsyncToolSpecification> tools, Map<String, AsyncResourceSpecification> resources, Map<String, AsyncResourceTemplateSpecification> resourceTemplates, Map<String, AsyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, AsyncCompletionSpecification> completions, List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers, String instructions) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities(null, null, new McpSchema.ServerCapabilities.LoggingCapabilities(), !Utils.isEmpty(prompts) ? new McpSchema.ServerCapabilities.PromptCapabilities(false) : null, !Utils.isEmpty(resources) ? new McpSchema.ServerCapabilities.ResourceCapabilities(false, false) : null, !Utils.isEmpty(tools) ? new McpSchema.ServerCapabilities.ToolCapabilities(false) : null);
            this.tools = tools != null ? tools : List.of();
            this.resources = resources != null ? resources : Map.of();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : Map.of();
            this.prompts = prompts != null ? prompts : Map.of();
            this.completions = completions != null ? completions : Map.of();
            this.rootsChangeConsumers = rootsChangeConsumers != null ? rootsChangeConsumers : List.of();
            this.instructions = instructions;
        }

        static Async fromSync(Sync syncSpec, boolean immediateExecution) {
            ArrayList<AsyncToolSpecification> tools = new ArrayList<AsyncToolSpecification>();
            for (SyncToolSpecification tool : syncSpec.tools()) {
                tools.add(AsyncToolSpecification.fromSync(tool, immediateExecution));
            }
            HashMap<String, AsyncResourceSpecification> resources = new HashMap<String, AsyncResourceSpecification>();
            syncSpec.resources().forEach((key, resource) -> resources.put((String)key, AsyncResourceSpecification.fromSync(resource, immediateExecution)));
            HashMap<String, AsyncResourceTemplateSpecification> resourceTemplates = new HashMap<String, AsyncResourceTemplateSpecification>();
            syncSpec.resourceTemplates().forEach((key, resource) -> resourceTemplates.put((String)key, AsyncResourceTemplateSpecification.fromSync(resource, immediateExecution)));
            HashMap<String, AsyncPromptSpecification> prompts = new HashMap<String, AsyncPromptSpecification>();
            syncSpec.prompts().forEach((key, prompt) -> prompts.put((String)key, AsyncPromptSpecification.fromSync(prompt, immediateExecution)));
            HashMap<McpSchema.CompleteReference, AsyncCompletionSpecification> completions = new HashMap<McpSchema.CompleteReference, AsyncCompletionSpecification>();
            syncSpec.completions().forEach((key, completion) -> completions.put((McpSchema.CompleteReference)key, AsyncCompletionSpecification.fromSync(completion, immediateExecution)));
            ArrayList<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootChangeConsumers = new ArrayList<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>>();
            for (BiConsumer<McpSyncServerExchange, List<McpSchema.Root>> rootChangeConsumer : syncSpec.rootsChangeConsumers()) {
                rootChangeConsumers.add((exchange, list) -> Mono.fromRunnable(() -> rootChangeConsumer.accept(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (List<McpSchema.Root>)list)).subscribeOn(Schedulers.boundedElastic()));
            }
            return new Async(syncSpec.serverInfo(), syncSpec.serverCapabilities(), tools, resources, resourceTemplates, prompts, completions, rootChangeConsumers, syncSpec.instructions());
        }
    }
}

