/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.grpc.DslType;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.PlaceholderGroup;
import io.milvus.grpc.PlaceholderType;
import io.milvus.grpc.PlaceholderValue;
import io.milvus.grpc.QueryRequest;
import io.milvus.grpc.SearchRequest;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.SearchReq;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VectorUtils {
    public QueryRequest ConvertToGrpcQueryRequest(QueryReq request) {
        long limit;
        QueryRequest.Builder builder = QueryRequest.newBuilder().setCollectionName(request.getCollectionName()).addAllPartitionNames(request.getPartitionNames()).addAllOutputFields(request.getOutputFields()).setExpr(request.getFilter());
        if (request.getConsistencyLevel() == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(request.getConsistencyLevel().getCode());
        }
        long offset = request.getOffset();
        if (offset > 0L) {
            builder.addQueryParams(KeyValuePair.newBuilder().setKey("offset").setValue(String.valueOf(offset)).build());
        }
        if ((limit = request.getLimit()) > 0L) {
            builder.addQueryParams(KeyValuePair.newBuilder().setKey("limit").setValue(String.valueOf(limit)).build());
        }
        return builder.build();
    }

    private static long getGuaranteeTimestamp(ConsistencyLevelEnum consistencyLevel, long guaranteeTimestamp, Long gracefulTime) {
        if (consistencyLevel == null) {
            return 1L;
        }
        switch (consistencyLevel) {
            case STRONG: {
                guaranteeTimestamp = 0L;
                break;
            }
            case BOUNDED: {
                guaranteeTimestamp = new Date().getTime() - gracefulTime;
                break;
            }
            case EVENTUALLY: {
                guaranteeTimestamp = 1L;
            }
        }
        return guaranteeTimestamp;
    }

    public SearchRequest ConvertToGrpcSearchRequest(SearchReq request) {
        SearchRequest.Builder builder = SearchRequest.newBuilder().setCollectionName(request.getCollectionName());
        if (!request.getPartitionNames().isEmpty()) {
            request.getPartitionNames().forEach(builder::addPartitionNames);
        }
        PlaceholderType plType = PlaceholderType.None;
        List<?> vectors = request.getData();
        ArrayList<ByteString> byteStrings = new ArrayList<ByteString>();
        for (Object vector : vectors) {
            if (vector instanceof List) {
                plType = PlaceholderType.FloatVector;
                List list = (List)vector;
                ByteBuffer buf = ByteBuffer.allocate(4 * list.size());
                buf.order(ByteOrder.LITTLE_ENDIAN);
                list.forEach(buf::putFloat);
                byte[] array = buf.array();
                ByteString bs = ByteString.copyFrom((byte[])array);
                byteStrings.add(bs);
                continue;
            }
            if (vector instanceof ByteBuffer) {
                plType = PlaceholderType.BinaryVector;
                ByteBuffer buf = (ByteBuffer)vector;
                byte[] array = buf.array();
                ByteString bs = ByteString.copyFrom((byte[])array);
                byteStrings.add(bs);
                continue;
            }
            String msg = "Search target vector type is illegal(Only allow List<Float> or ByteBuffer)";
            throw new ParamException(msg);
        }
        PlaceholderValue.Builder pldBuilder = PlaceholderValue.newBuilder().setTag("$0").setType(plType);
        byteStrings.forEach(pldBuilder::addValues);
        PlaceholderValue plv = pldBuilder.build();
        PlaceholderGroup placeholderGroup = PlaceholderGroup.newBuilder().addPlaceholders(plv).build();
        ByteString byteStr = placeholderGroup.toByteString();
        builder.setPlaceholderGroup(byteStr);
        builder.addSearchParams(KeyValuePair.newBuilder().setKey("anns_field").setValue(request.getAnnsField()).build()).addSearchParams(KeyValuePair.newBuilder().setKey("topk").setValue(String.valueOf(request.getTopK())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("round_decimal").setValue(String.valueOf(request.getRoundDecimal())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("ignore_growing").setValue(String.valueOf(request.isIgnoreGrowing())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("offset").setValue(String.valueOf(request.getOffset())).build());
        if (null != request.getSearchParams()) {
            try {
                Gson gson = new Gson();
                String searchParams = gson.toJson(request.getSearchParams());
                builder.addSearchParams(KeyValuePair.newBuilder().setKey("params").setValue(searchParams).build());
            }
            catch (IllegalArgumentException e) {
                throw new ParamException(e.getMessage() + e.getCause().getMessage());
            }
        }
        if (!request.getOutputFields().isEmpty()) {
            request.getOutputFields().forEach(builder::addOutputFields);
        }
        builder.setDslType(DslType.BoolExprV1);
        if (request.getFilter() != null && !request.getFilter().isEmpty()) {
            builder.setDsl(request.getFilter());
        }
        long guaranteeTimestamp = VectorUtils.getGuaranteeTimestamp(ConsistencyLevelEnum.valueOf(request.getConsistencyLevel().name()), request.getGuaranteeTimestamp(), request.getGracefulTime());
        builder.setGuaranteeTimestamp(guaranteeTimestamp);
        if (request.getConsistencyLevel() == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(request.getConsistencyLevel().getCode());
        }
        return builder.build();
    }

    public String getExprById(String primaryFieldName, List<?> ids) {
        StringBuilder sb = new StringBuilder();
        sb.append(primaryFieldName).append(" in [");
        for (Object id : ids) {
            if (id instanceof String) {
                sb.append("\"").append(id.toString()).append("\",");
                continue;
            }
            sb.append(id.toString()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }
}

