/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.io.DeserializationException;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.io.IOException;
import io.jsonwebtoken.lang.Assert;
import java.nio.charset.StandardCharsets;

class JwtDeserializer<T>
implements Deserializer<T> {
    static final String MALFORMED_ERROR = "Malformed JWT JSON: ";
    static final String MALFORMED_COMPLEX_ERROR = "Malformed or excessively complex JWT JSON. This could reflect a potential malicious JWT, please investigate the JWT source further. JSON: ";
    private final Deserializer<T> deserializer;

    JwtDeserializer(Deserializer<T> deserializer) {
        Assert.notNull(deserializer, (String)"deserializer cannot be null.");
        this.deserializer = deserializer;
    }

    public T deserialize(byte[] bytes) throws DeserializationException {
        try {
            return (T)this.deserializer.deserialize(bytes);
        }
        catch (DeserializationException e) {
            throw new MalformedJwtException(MALFORMED_ERROR + new String(bytes, StandardCharsets.UTF_8), (Throwable)e);
        }
        catch (StackOverflowError e) {
            throw new IOException(MALFORMED_COMPLEX_ERROR + new String(bytes, StandardCharsets.UTF_8), (Throwable)e);
        }
    }
}

