/*
 * Decompiled with CFR 0.152.
 */
package io.qifan.infrastructure.oss.tencent;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import io.qifan.infrastructure.oss.service.OSSService;
import io.qifan.infrastructure.oss.tencent.TencentOSSProperties;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TencentOSSService
implements OSSService {
    private final TencentOSSProperties properties;

    @Override
    public String upload(MultipartFile multipartFile) {
        String filename = multipartFile.getOriginalFilename();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String objectName = sdf.format(new Date()) + filename;
        return this.basicUpload(objectName, multipartFile.getInputStream());
    }

    @Override
    public String upload(String objectName, InputStream inputStream) {
        return this.basicUpload(objectName, inputStream);
    }

    public String basicUpload(String objectName, InputStream inputStream) {
        String bucketName = this.properties.getBucket();
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, objectName, inputStream, new ObjectMetadata());
        COSClient tencentOSS = this.getTencentOSS();
        PutObjectResult putObjectResult = tencentOSS.putObject(putObjectRequest);
        return tencentOSS.getObjectUrl(bucketName, objectName).toString();
    }

    public COSClient getTencentOSS() {
        BasicCOSCredentials cred = new BasicCOSCredentials(this.properties.getSecretId(), this.properties.getSecretKey());
        Region region = new Region(this.properties.getRegion());
        ClientConfig clientConfig = new ClientConfig(region);
        return new COSClient((COSCredentials)cred, clientConfig);
    }

    public TencentOSSService(TencentOSSProperties properties) {
        this.properties = properties;
    }
}

