/*
 * Decompiled with CFR 0.152.
 */
package io.qifan.infrastructure.oss.local;

import io.qifan.infrastructure.common.constants.BaseEnum;
import io.qifan.infrastructure.common.constants.ResultCode;
import io.qifan.infrastructure.common.exception.BusinessException;
import io.qifan.infrastructure.oss.local.LocalOSSProperties;
import io.qifan.infrastructure.oss.service.OSSService;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LocalOSSService
implements OSSService {
    private static final Logger log = LoggerFactory.getLogger(LocalOSSService.class);
    private final LocalOSSProperties localOSSProperties;

    @Override
    public String upload(MultipartFile multipartFile) {
        return this.basicUpload(multipartFile.getOriginalFilename(), multipartFile.getInputStream());
    }

    @Override
    public String upload(String objectName, InputStream inputStream) {
        return this.basicUpload(objectName, inputStream);
    }

    public String basicUpload(String objectName, InputStream inputStream) {
        byte[] bytes = inputStream.readAllBytes();
        String fileName = String.valueOf(UUID.randomUUID()) + "_" + objectName;
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.localOSSProperties.getPath() + "/" + fileName);){
            fileOutputStream.write(bytes);
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessException((BaseEnum)ResultCode.Fail, "\u4e0a\u4f20\u5931\u8d25");
        }
        return this.localOSSProperties.getUrl() + fileName;
    }

    public LocalOSSService(LocalOSSProperties localOSSProperties) {
        this.localOSSProperties = localOSSProperties;
    }
}

