/*
 * Decompiled with CFR 0.152.
 */
package io.qifan.infrastructure.oss.aliyun;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.StorageClass;
import io.qifan.infrastructure.oss.aliyun.AliYunOSSProperties;
import io.qifan.infrastructure.oss.service.OSSService;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class AliYunOSSService
implements OSSService {
    private static final Logger log = LoggerFactory.getLogger(AliYunOSSService.class);
    private final AliYunOSSProperties aliYunOSSProperties;

    public AliYunOSSService(AliYunOSSProperties aliYunOSSProperties) {
        this.aliYunOSSProperties = aliYunOSSProperties;
    }

    @Override
    public String upload(MultipartFile multipartFile) {
        String filename = multipartFile.getOriginalFilename();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String objectName = sdf.format(new Date()) + filename;
        return this.basicUpload(objectName, multipartFile.getInputStream());
    }

    @Override
    public String upload(String objectName, InputStream inputStream) {
        return this.basicUpload(objectName, inputStream);
    }

    public String basicUpload(String objectName, InputStream inputStream) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.aliYunOSSProperties.getBucketName(), objectName, inputStream);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setHeader("x-oss-storage-class", (Object)StorageClass.Standard.toString());
        metadata.setObjectAcl(CannedAccessControlList.PublicRead);
        putObjectRequest.setMetadata(metadata);
        PutObjectResult putObjectResult = this.getAliYunOSS().putObject(putObjectRequest);
        return "https://" + this.aliYunOSSProperties.getBucketName() + "." + this.aliYunOSSProperties.getEndpoint().replace("https://", "") + "/" + objectName;
    }

    public OSS getAliYunOSS() {
        return new OSSClientBuilder().build(this.aliYunOSSProperties.getEndpoint(), this.aliYunOSSProperties.getAccessKeyId(), this.aliYunOSSProperties.getAccessKeySecret());
    }
}

