/*
 * Decompiled with CFR 0.152.
 */
package io.qifan.infrastructure.oss;

import io.qifan.infrastructure.oss.OSSProperties;
import io.qifan.infrastructure.oss.aliyun.AliYunOSSProperties;
import io.qifan.infrastructure.oss.aliyun.AliYunOSSService;
import io.qifan.infrastructure.oss.local.LocalOSSProperties;
import io.qifan.infrastructure.oss.local.LocalOSSService;
import io.qifan.infrastructure.oss.service.OSSService;
import io.qifan.infrastructure.oss.tencent.TencentOSSProperties;
import io.qifan.infrastructure.oss.tencent.TencentOSSService;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={OSSProperties.class, TencentOSSProperties.class, AliYunOSSProperties.class, LocalOSSProperties.class})
public class OSSAutoConfiguration {

    @AutoConfiguration
    @ConditionalOnProperty(prefix="oss", name={"provider"}, havingValue="TENANT")
    @EnableConfigurationProperties(value={TencentOSSProperties.class})
    public static class TencentConfig {
        @Bean
        @ConditionalOnMissingBean(value={OSSService.class})
        public OSSService tencentOSSService(TencentOSSProperties properties) {
            return new TencentOSSService(properties);
        }
    }

    @AutoConfiguration
    @ConditionalOnProperty(prefix="oss", name={"provider"}, havingValue="ALI_YUN")
    @EnableConfigurationProperties(value={AliYunOSSProperties.class})
    public static class AliYunConfig {
        @Bean
        @ConditionalOnMissingBean(value={OSSService.class})
        public OSSService aliYunOSSService(AliYunOSSProperties aliYunOSSProperties) {
            return new AliYunOSSService(aliYunOSSProperties);
        }
    }

    @AutoConfiguration
    @ConditionalOnProperty(prefix="oss", name={"provider"}, havingValue="LOCAL")
    @EnableConfigurationProperties(value={LocalOSSProperties.class})
    public static class LocalConfig {
        @Bean
        @ConditionalOnMissingBean(value={OSSService.class})
        public OSSService localOSSService(LocalOSSProperties localOSSProperties) {
            return new LocalOSSService(localOSSProperties);
        }
    }
}

