/*
 * Decompiled with CFR 0.152.
 */
package io.qifan.infrastructure.common.constants;

import io.qifan.infrastructure.common.constants.BaseEnum;
import java.util.Arrays;
import java.util.Optional;

public enum ResultCode implements BaseEnum
{
    Success(1, "\u64cd\u4f5c\u6210\u529f"),
    Fail(0, "\u64cd\u4f5c\u5931\u8d25"),
    NotFindError(10001, "\u672a\u67e5\u8be2\u5230\u4fe1\u606f"),
    SaveError(10002, "\u4fdd\u5b58\u4fe1\u606f\u5931\u8d25"),
    UpdateError(10003, "\u66f4\u65b0\u4fe1\u606f\u5931\u8d25"),
    ValidateError(10004, "\u6570\u636e\u68c0\u9a8c\u5931\u8d25"),
    StatusHasValid(10005, "\u72b6\u6001\u5df2\u7ecf\u88ab\u542f\u7528"),
    StatusHasInvalid(10006, "\u72b6\u6001\u5df2\u7ecf\u88ab\u7981\u7528"),
    SystemError(10007, "\u7cfb\u7edf\u5f02\u5e38"),
    BusinessError(10008, "\u4e1a\u52a1\u5f02\u5e38"),
    ParamSetIllegal(10009, "\u53c2\u6570\u8bbe\u7f6e\u975e\u6cd5"),
    TransferStatusError(10010, "\u5f53\u524d\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4"),
    NotGrant(10011, "\u6743\u9650\u4e0d\u8db3"),
    Unauthorized(10012, "\u8bf7\u767b\u5f55");

    private final Integer code;
    private final String name;

    private ResultCode(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static Optional<ResultCode> of(Integer code) {
        return Arrays.stream(ResultCode.values()).filter(resultCode -> resultCode.getCode().equals(code)).findFirst();
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

