/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorexclient.res;

import java.util.List;

public class PageResult<T> {
    private List<T> data;
    private long totalRecords;
    private int totalPages;
    private int pageIndex;
    private int pageSize;

    public PageResult(List<T> data, long totalRecords, int pageIndex, int pageSize) {
        this.data = data;
        this.totalRecords = totalRecords;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.totalPages = (int)Math.ceil((double)totalRecords / (double)pageSize);
    }

    public List<T> getData() {
        return this.data;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalRecords() != other.getTotalRecords()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getPageIndex() != other.getPageIndex()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalRecords = this.getTotalRecords();
        result = result * 59 + (int)($totalRecords >>> 32 ^ $totalRecords);
        result = result * 59 + this.getTotalPages();
        result = result * 59 + this.getPageIndex();
        result = result * 59 + this.getPageSize();
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "PageResult(data=" + this.getData() + ", totalRecords=" + this.getTotalRecords() + ", totalPages=" + this.getTotalPages() + ", pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ")";
    }
}

