/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.Clob;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.LongDataParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class ReaderParameter
implements Cloneable,
LongDataParameterHolder {
    private Reader reader;
    private Clob clob;
    private final long length;
    private final boolean noBackslashEscapes;

    public ReaderParameter(Reader reader, long length, boolean noBackslashEscapes) {
        this.reader = reader;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
        this.clob = null;
    }

    public ReaderParameter(Clob clob, long length, boolean noBackslashEscapes) {
        this.clob = clob;
        this.reader = null;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public ReaderParameter(Reader reader, boolean noBackslashEscapes) {
        this(reader, Long.MAX_VALUE, noBackslashEscapes);
    }

    private void setReader() throws SQLException {
        if (this.clob != null) {
            this.reader = this.clob.getCharacterStream();
        }
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException, SQLException {
        this.setReader();
        pos.write(39);
        if (this.length == Long.MAX_VALUE) {
            pos.write(this.reader, true, this.noBackslashEscapes);
        } else {
            pos.write(this.reader, this.length, true, this.noBackslashEscapes);
        }
        pos.write(39);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return -1;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException, SQLException {
        this.setReader();
        if (this.length == Long.MAX_VALUE) {
            pos.write(this.reader, false, this.noBackslashEscapes);
        } else {
            pos.write(this.reader, this.length, false, this.noBackslashEscapes);
        }
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.STRING;
    }

    @Override
    public String toString() {
        return "<Reader>";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return true;
    }

    @Override
    public boolean writePieceData(PacketOutputStream pos, boolean first, Options options) throws IOException {
        return false;
    }

    @Override
    public boolean writeLongData(PacketOutputStream writer, Options options, int statementId, short paramIndex) throws IOException, SQLException {
        int len;
        this.setReader();
        char[] buffer = new char[8192];
        int totoalReadLen = 0;
        int currentPacketLen = 0;
        int lastReadLen = 0;
        boolean isEmpty = true;
        int sizeToSend = options.blobSendChunkSize;
        writer.startPacket(0);
        writer.write(24);
        writer.writeInt(statementId);
        writer.writeShort(paramIndex);
        while ((len = this.reader.read(buffer)) != -1) {
            isEmpty = false;
            byte[] data = new String(buffer, 0, len).getBytes(options.getCharacterEncoding());
            writer.write(data, 0, data.length);
            totoalReadLen += len;
            if ((currentPacketLen += len) < sizeToSend) continue;
            currentPacketLen = 0;
            lastReadLen = totoalReadLen;
            writer.flush();
            writer.startPacket(0);
            writer.write(24);
            writer.writeInt(statementId);
            writer.writeShort(paramIndex);
        }
        if (lastReadLen != totoalReadLen) {
            writer.flush();
        }
        if (isEmpty) {
            writer.flush();
        }
        return true;
    }
}

