/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.resultset.rowprotocol;

import com.oceanbase.jdbc.JDBC4ResultSet;
import com.oceanbase.jdbc.extend.datatype.BINARY_DOUBLE;
import com.oceanbase.jdbc.extend.datatype.BINARY_FLOAT;
import com.oceanbase.jdbc.extend.datatype.ComplexData;
import com.oceanbase.jdbc.extend.datatype.ComplexDataType;
import com.oceanbase.jdbc.extend.datatype.DataTypeUtilities;
import com.oceanbase.jdbc.extend.datatype.INTERVALDS;
import com.oceanbase.jdbc.extend.datatype.INTERVALYM;
import com.oceanbase.jdbc.extend.datatype.NUMBER;
import com.oceanbase.jdbc.extend.datatype.NUMBER_FLOAT;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMP;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPLTZ;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPTZ;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.util.Options;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Pattern;

public abstract class RowProtocol {
    public static final int BIT_LAST_FIELD_NOT_NULL = 0;
    public static final int BIT_LAST_FIELD_NULL = 1;
    public static final int BIT_LAST_ZERO_DATE = 2;
    public static final int TINYINT1_IS_BIT = 1;
    public static final int YEAR_IS_DATE_TYPE = 2;
    public static final DateTimeFormatter TEXT_LOCAL_DATE_TIME;
    public static final DateTimeFormatter TEXT_OFFSET_DATE_TIME;
    public static final DateTimeFormatter TEXT_ZONED_DATE_TIME;
    public static final Pattern isIntegerRegex;
    protected static final int NULL_LENGTH = -1;
    private Protocol protocol;
    private Calendar calendarWithoutTimeZone;
    private Calendar calendarWithTimeZone;
    protected final int maxFieldSize;
    protected final Options options;
    public int lastValueNull;
    public byte[] buf;
    public int pos;
    public int length;
    protected int index;
    public int[] complexEndPos;
    protected boolean useCalLenientFlag;
    protected boolean yearIsZero;

    public RowProtocol(int maxFieldSize, Options options) {
        this.maxFieldSize = maxFieldSize;
        this.options = options;
    }

    public void resetRow(byte[] buf) {
        this.buf = buf;
        this.index = -1;
    }

    Charset getCurrentEncoding(ColumnType columnType) {
        switch (columnType) {
            case NVARCHAR2: 
            case NCHAR: {
                if (this.options.nCharacterEncoding != null && !this.options.nCharacterEncoding.isEmpty()) {
                    return Charset.forName(this.options.nCharacterEncoding);
                }
            }
            case VARCHAR: 
            case VARCHAR2: 
            case VARSTRING: 
            case RAW: 
            case STRING: {
                return Charset.forName(this.options.getCharacterEncoding());
            }
        }
        return StandardCharsets.UTF_8;
    }

    public abstract void setPosition(int var1, JDBC4ResultSet var2) throws SQLException;

    public int getLengthMaxFieldSize() {
        return this.maxFieldSize != 0 && this.maxFieldSize < this.length ? this.maxFieldSize : this.length;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public Calendar getCalendarInstance(Calendar calendar) {
        if (calendar != null) {
            return (Calendar)calendar.clone();
        }
        if (this.calendarWithoutTimeZone == null) {
            this.calendarWithoutTimeZone = Calendar.getInstance();
        }
        return this.calendarWithoutTimeZone;
    }

    public Calendar getCalendarInstanceWithTimezone(Calendar calendar, TimeZone timeZone) {
        if (calendar != null) {
            return (Calendar)calendar.clone();
        }
        if (this.calendarWithTimeZone == null) {
            this.calendarWithTimeZone = Calendar.getInstance(timeZone);
        }
        this.calendarWithTimeZone.setTimeZone(timeZone);
        return this.calendarWithTimeZone;
    }

    public abstract String getInternalString(ColumnDefinition var1, Calendar var2, TimeZone var3) throws SQLException;

    public abstract int getInternalInt(ColumnDefinition var1) throws SQLException;

    public abstract long getInternalLong(ColumnDefinition var1) throws SQLException;

    public abstract float getInternalFloat(ColumnDefinition var1) throws SQLException;

    public abstract double getInternalDouble(ColumnDefinition var1) throws SQLException;

    public abstract BigDecimal getInternalBigDecimal(ColumnDefinition var1) throws SQLException;

    public abstract Date getInternalDate(ColumnDefinition var1, Calendar var2, TimeZone var3) throws SQLException;

    public abstract Time getInternalTime(ColumnDefinition var1, Calendar var2, TimeZone var3) throws SQLException;

    public abstract Timestamp getInternalTimestamp(ColumnDefinition var1, Calendar var2, TimeZone var3) throws SQLException;

    public abstract Array getInternalArray(ColumnDefinition var1, ComplexDataType var2, Connection var3) throws SQLException;

    public abstract Struct getInternalStruct(ColumnDefinition var1, ComplexDataType var2, Connection var3) throws SQLException;

    public abstract ComplexData getInternalComplexCursor(ColumnDefinition var1, ComplexDataType var2, Connection var3) throws SQLException;

    public String getEncoding() {
        return this.options.getCharacterEncoding();
    }

    public TIMESTAMP getInternalTIMESTAMP(ColumnDefinition columnInfo, Calendar userCalendar, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.TIMESTAMP_NANO) {
            if (this.length < 12) {
                throw new SQLException("timestamp field data length is invalid, expected 12 at least, actual length is " + this.length);
            }
            return this.buildTIMETAMP(this.buf, this.pos, this.length);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as TIMESTAMP");
    }

    public TIMESTAMPTZ getInternalTIMESTAMPTZ(ColumnDefinition columnInfo, Calendar userCalendar, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.TIMESTAMP_TZ) {
            if (this.length < 12) {
                throw new SQLException("timestamp field data length is invalid, expected 12 at least, actual length is " + this.length);
            }
            byte[] returnBytes = new byte[this.length];
            System.arraycopy(this.buf, this.pos, returnBytes, 0, this.length);
            TIMESTAMPTZ timestamptz = new TIMESTAMPTZ(returnBytes);
            timestamptz.setByte(11, returnBytes[11]);
            return timestamptz;
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as TIMESTAMP");
    }

    public TIMESTAMPLTZ getInternalTIMESTAMPLTZ(ColumnDefinition columnInfo, Calendar userCalendar, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.TIMESTAMP_LTZ) {
            if (this.length < 12) {
                throw new SQLException("timestamp field data length is invalid, expected 12 at least, actual length is " + this.length);
            }
            byte[] returnBytes = new byte[this.length];
            System.arraycopy(this.buf, this.pos, returnBytes, 0, this.length);
            return new TIMESTAMPLTZ(returnBytes);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as TIMESTAMP");
    }

    protected TIMESTAMP buildTIMETAMP(byte[] bytes, int pos, int length) throws SQLException {
        int index;
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildTimestamp(bytes[pos]));
        sb.append(this.buildTimestamp(bytes[pos + 1]));
        sb.append("-");
        sb.append(this.buildTimestamp(bytes[pos + 2]));
        sb.append("-");
        sb.append(this.buildTimestamp(bytes[pos + 3]));
        sb.append(" ");
        sb.append(this.buildTimestamp(bytes[pos + 4]));
        sb.append(":");
        sb.append(this.buildTimestamp(bytes[pos + 5]));
        sb.append(":");
        sb.append(this.buildTimestamp(bytes[pos + 6]));
        sb.append(".");
        byte[] nanosBytes = new byte[4];
        System.arraycopy(bytes, pos + 7, nanosBytes, 0, 4);
        int nanos = DataTypeUtilities.getNanos(nanosBytes, 0);
        String temp = String.format("%09d", nanos);
        char[] chars = temp.toCharArray();
        for (index = chars.length; index > 1 && chars[index - 1] == '0'; --index) {
        }
        byte scale = bytes[pos + 11];
        if (scale > (temp = temp.substring(0, index)).length()) {
            int x = scale - temp.length();
            StringBuilder strBuf = new StringBuilder();
            for (int i = 0; i < x; ++i) {
                strBuf.append("0");
            }
            temp = temp + strBuf.toString();
        }
        sb.append(temp);
        TIMESTAMP timestamp = new TIMESTAMP(Timestamp.valueOf(sb.toString()));
        timestamp.setByte(11, bytes[pos + 11]);
        return timestamp;
    }

    private String buildTimestamp(byte b) {
        if (b < 10) {
            return "0" + b;
        }
        return "" + b;
    }

    public abstract Object getInternalObject(ColumnDefinition var1, TimeZone var2) throws SQLException;

    public abstract boolean getInternalBoolean(ColumnDefinition var1) throws SQLException;

    public abstract byte getInternalByte(ColumnDefinition var1) throws SQLException;

    public abstract short getInternalShort(ColumnDefinition var1) throws SQLException;

    public abstract String getInternalTimeString(ColumnDefinition var1) throws SQLException;

    public abstract BigInteger getInternalBigInteger(ColumnDefinition var1) throws SQLException;

    public abstract ZonedDateTime getInternalZonedDateTime(ColumnDefinition var1, Class var2, TimeZone var3) throws SQLException;

    public abstract OffsetTime getInternalOffsetTime(ColumnDefinition var1, TimeZone var2) throws SQLException;

    public abstract OffsetDateTime getInternalOffsetDateTime(ColumnDefinition var1, TimeZone var2) throws SQLException;

    public abstract LocalTime getInternalLocalTime(ColumnDefinition var1, TimeZone var2) throws SQLException;

    public abstract LocalDate getInternalLocalDate(ColumnDefinition var1, TimeZone var2) throws SQLException;

    public abstract INTERVALDS getInternalINTERVALDS(ColumnDefinition var1) throws SQLException;

    public abstract INTERVALYM getInternalINTERVALYM(ColumnDefinition var1) throws SQLException;

    public abstract boolean isBinaryEncoded();

    public boolean lastValueWasNull() {
        return (this.lastValueNull & 1) != 0;
    }

    protected String zeroFillingIfNeeded(String value, ColumnDefinition columnDefinition) {
        if (columnDefinition.isZeroFill()) {
            StringBuilder zeroAppendStr = new StringBuilder();
            long zeroToAdd = columnDefinition.getDisplaySize() - value.length();
            while (zeroToAdd-- > 0L) {
                zeroAppendStr.append("0");
            }
            return zeroAppendStr.append(value).toString();
        }
        return value;
    }

    protected int getInternalTinyInt(ColumnDefinition columnInfo) {
        if (this.lastValueWasNull()) {
            return 0;
        }
        int value = this.buf[this.pos];
        if (!columnInfo.isSigned()) {
            value = this.buf[this.pos] & 0xFF;
        }
        return value;
    }

    protected long parseBit() {
        if (this.length == 1) {
            return this.buf[this.pos];
        }
        long val = 0L;
        int ind = 0;
        do {
            val += (long)(this.buf[this.pos + ind] & 0xFF) << 8 * (this.length - ++ind);
        } while (ind < this.length);
        return val;
    }

    protected int getInternalSmallInt(ColumnDefinition columnInfo) {
        if (this.lastValueWasNull()) {
            return 0;
        }
        int value = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8);
        if (!columnInfo.isSigned()) {
            return value & 0xFFFF;
        }
        return (short)value;
    }

    protected long getInternalMediumInt(ColumnDefinition columnInfo) {
        if (this.lastValueWasNull()) {
            return 0L;
        }
        long value = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16) + ((this.buf[this.pos + 3] & 0xFF) << 24);
        if (!columnInfo.isSigned()) {
            value &= 0xFFFFFFFFL;
        }
        return value;
    }

    boolean isNUMBERTYPE(ColumnType columnType) {
        return columnType == ColumnType.NUMBER || columnType == ColumnType.FLOAT || columnType == ColumnType.DECIMAL || columnType == ColumnType.BINARY_DOUBLE || columnType == ColumnType.BINARY_FLOAT;
    }

    protected NUMBER zgetNUMBER(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.isNUMBERTYPE(columnInfo.getColumnType())) {
            byte[] b = new byte[this.length];
            System.arraycopy(this.buf, this.pos, b, 0, this.length);
            return new NUMBER(b);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as NUMBER");
    }

    protected NUMBER_FLOAT getNUMBER_FLOAT(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        if (columnInfo.getColumnType() == ColumnType.NUMBER_FLOAT) {
            return new NUMBER_FLOAT(new Float(value).floatValue(), this.buf);
        }
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as NUMBER_FLOAT");
    }

    protected BINARY_DOUBLE getBINARY_DOUBLE(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.BINARY_DOUBLE) {
            return new BINARY_DOUBLE(this.buf[this.pos]);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as BINARY_DOUBLE");
    }

    protected BINARY_FLOAT getBINARY_FLOAT(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.BINARY_FLOAT) {
            return new BINARY_FLOAT(this.buf[this.pos]);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as BINARY_FLOAT");
    }

    protected INTERVALDS getINTERVALDS(ColumnDefinition columnInfo) throws Exception {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.INTERVALDS) {
            return new INTERVALDS(this.buf);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as INTERVALDS");
    }

    protected INTERVALYM getINTERVALYM(ColumnDefinition columnInfo) throws Exception {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.INTERVALYM) {
            return new INTERVALYM(this.buf);
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as INTERVALYM");
    }

    protected void rangeCheck(Object className, long minValue, long maxValue, BigDecimal value, ColumnDefinition columnInfo) throws SQLException {
        if (value.compareTo(BigDecimal.valueOf(minValue)) < 0 || value.compareTo(BigDecimal.valueOf(maxValue)) > 0) {
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in " + className + " range", "22003", 1264);
        }
    }

    protected void rangeCheck(Object className, long minValue, long maxValue, double value, ColumnDefinition columnInfo) throws SQLException {
        if (value < (double)minValue || value > (double)maxValue) {
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in " + className + " range", "22003", 1264);
        }
    }

    protected void rangeCheck(Object className, long minValue, long maxValue, long value, ColumnDefinition columnInfo) throws SQLException {
        if (value < minValue || value > maxValue) {
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in " + className + " range", "22003", 1264);
        }
    }

    protected int extractNanos(String timestring) throws SQLException {
        int index = timestring.indexOf(46);
        if (index == -1) {
            return 0;
        }
        int nanos = 0;
        for (int i = index + 1; i < index + 10; ++i) {
            int digit;
            if (i >= timestring.length()) {
                digit = 0;
            } else {
                char value = timestring.charAt(i);
                if (value < '0' || value > '9') {
                    throw new SQLException("cannot parse sub-second part in timestamp string '" + timestring + "'");
                }
                digit = value - 48;
            }
            nanos = nanos * 10 + digit;
        }
        return nanos;
    }

    public boolean wasNull() {
        return (this.lastValueNull & 1) != 0 || (this.lastValueNull & 2) != 0;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public int[] getTimestampPart(ColumnDefinition columnInfo) throws SQLException {
        byte b;
        int begin;
        int nanoCount = 0;
        int nanoBegin = -1;
        int[] timestampsPart = new int[]{0, 0, 0, 0, 0, 0, 0};
        boolean onlyTimeFormat = false;
        boolean withColon = false;
        int partIdx = 0;
        for (begin = this.pos; begin < this.pos + this.length; ++begin) {
            b = this.buf[begin];
            if (b != 58) continue;
            onlyTimeFormat = true;
        }
        for (begin = this.pos; begin < this.pos + this.length; ++begin) {
            b = this.buf[begin];
            if (b == 32 || b == 45 || b == 47) {
                onlyTimeFormat = false;
            }
            if (b == 58) {
                withColon = true;
            }
            if (b == 45 || b == 32 || b == 58) {
                ++partIdx;
                continue;
            }
            if (b == 46) {
                ++partIdx;
                nanoBegin = begin;
                continue;
            }
            if (b < 48 || b > 57) {
                throw new SQLException("cannot parse data in timestamp string '" + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + "'");
            }
            if (nanoBegin != -1) {
                ++nanoCount;
            }
            timestampsPart[partIdx] = timestampsPart[partIdx] * 10 + b - 48;
        }
        if (timestampsPart[0] == 0 && timestampsPart[1] == 0 && timestampsPart[2] == 0 && timestampsPart[3] == 0 && timestampsPart[4] == 0 && timestampsPart[5] == 0 && timestampsPart[6] == 0) {
            if (this.getProtocol().isOracleMode()) {
                this.lastValueNull |= 2;
                return null;
            }
            if (this.options.zeroDateTimeBehavior.equalsIgnoreCase("exception") && !onlyTimeFormat) {
                throw new SQLException("Value '" + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + "' can not be represented as java.sql.Timestamp");
            }
            if (this.options.zeroDateTimeBehavior.equalsIgnoreCase("convertToNull") && !onlyTimeFormat) {
                return null;
            }
            timestampsPart[0] = 1;
            timestampsPart[1] = 1;
            timestampsPart[2] = 1;
        }
        if (this.length == 8 && !this.getProtocol().isOracleMode()) {
            timestampsPart[0] = 1970;
            timestampsPart[1] = 1;
            timestampsPart[2] = 1;
        }
        for (int i = nanoCount; i <= 8; ++i) {
            timestampsPart[6] = timestampsPart[6] * 10;
        }
        return timestampsPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Timestamp buildTimestmap(int year, int month, int day, int hour, int minutes, int seconds, int nanos, Calendar calendar, TimeZone timezone) {
        Timestamp tt;
        Calendar localCal = this.getCalendarInstance(calendar);
        if (this.options.useLegacyDatetimeCode) {
            localCal.setTimeZone(timezone);
        }
        this.yearIsZero = !this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8 && year == 0;
        Calendar calendar2 = localCal;
        synchronized (calendar2) {
            if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8 && !this.useCalLenientFlag) {
                localCal.setLenient(false);
            }
            localCal.clear();
            localCal.set(year, month - 1, day, hour, minutes, seconds);
            try {
                tt = new Timestamp(localCal.getTimeInMillis());
            }
            finally {
                if (this.useCalLenientFlag) {
                    this.useCalLenientFlag = false;
                }
                localCal.setLenient(true);
            }
        }
        tt.setNanos(nanos);
        return tt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestampFromString(ColumnDefinition columnInfo, String stringValue, Calendar calendar, TimeZone timezone) throws SQLException {
        try {
            int year = 1970;
            int month = 0;
            int day = 0;
            int hour = 0;
            int minutes = 0;
            int seconds = 0;
            int nanos = 0;
            stringValue = stringValue.trim();
            int length = stringValue.length();
            if (length > 0 && stringValue.charAt(0) == '0' && (stringValue.equals("0000-00-00") || stringValue.equals("0000-00-00 00:00:00") || stringValue.equals("00000000000000") || stringValue.equals("0"))) {
                Timestamp tt;
                Calendar localCal;
                if (this.options.zeroDateTimeBehavior.equalsIgnoreCase("exception")) {
                    if (this.options.compatibleMysqlVersion == 8) {
                        throw new SQLException("Zero date value prohibited");
                    }
                    throw new SQLException("Value '" + new String(this.buf, this.pos, length, this.getCurrentEncoding(columnInfo.getColumnType())) + "' can not be represented as java.sql.Timestamp");
                }
                if (this.options.zeroDateTimeBehavior.equalsIgnoreCase("convertToNull")) {
                    this.lastValueNull |= 2;
                    return null;
                }
                year = 1;
                month = 1;
                day = 1;
                Calendar calendar2 = localCal = this.getCalendarInstance(calendar);
                synchronized (calendar2) {
                    localCal.clear();
                    localCal.set(year, month - 1, day, hour, minutes, seconds);
                    tt = new Timestamp(localCal.getTimeInMillis());
                }
                tt.setNanos(nanos);
                return tt;
            }
            int decimalIndex = stringValue.indexOf(".");
            if (decimalIndex == length - 1) {
                --length;
            } else if (decimalIndex != -1) {
                if (decimalIndex + 2 <= length) {
                    nanos = Integer.parseInt(stringValue.substring(decimalIndex + 1));
                    int numDigits = length - (decimalIndex + 1);
                    if (numDigits < 9) {
                        int factor = (int)Math.pow(10.0, 9 - numDigits);
                        nanos *= factor;
                    }
                    length = decimalIndex;
                } else {
                    throw new IllegalArgumentException();
                }
            }
            switch (length) {
                case 2: 
                case 4: 
                case 6: {
                    year = Integer.parseInt(stringValue.substring(0, 2));
                    if (year <= 69) {
                        year += 100;
                    }
                    year += 1900;
                    switch (length) {
                        case 2: {
                            month = 1;
                            day = 1;
                            break;
                        }
                        case 4: {
                            month = Integer.parseInt(stringValue.substring(2, 4));
                            day = 1;
                            break;
                        }
                        case 6: {
                            month = Integer.parseInt(stringValue.substring(2, 4));
                            day = Integer.parseInt(stringValue.substring(4, 6));
                        }
                    }
                    break;
                }
                case 12: {
                    year = Integer.parseInt(stringValue.substring(0, 2));
                    if (year <= 69) {
                        year += 100;
                    }
                    year += 1900;
                    month = Integer.parseInt(stringValue.substring(2, 4));
                    day = Integer.parseInt(stringValue.substring(4, 6));
                    hour = Integer.parseInt(stringValue.substring(6, 8));
                    minutes = Integer.parseInt(stringValue.substring(8, 10));
                    seconds = Integer.parseInt(stringValue.substring(10, 12));
                    break;
                }
                case 14: {
                    year = Integer.parseInt(stringValue.substring(0, 4));
                    month = Integer.parseInt(stringValue.substring(4, 6));
                    day = Integer.parseInt(stringValue.substring(6, 8));
                    hour = Integer.parseInt(stringValue.substring(8, 10));
                    minutes = Integer.parseInt(stringValue.substring(10, 12));
                    seconds = Integer.parseInt(stringValue.substring(12, 14));
                    break;
                }
                case 10: {
                    if (columnInfo.getColumnType() == ColumnType.DATE || stringValue.indexOf("-") != -1) {
                        year = Integer.parseInt(stringValue.substring(0, 4));
                        month = Integer.parseInt(stringValue.substring(5, 7));
                        day = Integer.parseInt(stringValue.substring(8, 10));
                        hour = 0;
                        minutes = 0;
                        break;
                    }
                    year = Integer.parseInt(stringValue.substring(0, 2));
                    if (year <= 69) {
                        year += 100;
                    }
                    month = Integer.parseInt(stringValue.substring(2, 4));
                    day = Integer.parseInt(stringValue.substring(4, 6));
                    hour = Integer.parseInt(stringValue.substring(6, 8));
                    minutes = Integer.parseInt(stringValue.substring(8, 10));
                    year += 1900;
                    break;
                }
                case 8: {
                    if (stringValue.indexOf(":") != -1) {
                        hour = Integer.parseInt(stringValue.substring(0, 2));
                        minutes = Integer.parseInt(stringValue.substring(3, 5));
                        seconds = Integer.parseInt(stringValue.substring(6, 8));
                        year = 1970;
                        month = 1;
                        day = 1;
                        break;
                    }
                    year = Integer.parseInt(stringValue.substring(0, 4));
                    month = Integer.parseInt(stringValue.substring(4, 6));
                    day = Integer.parseInt(stringValue.substring(6, 8));
                    year -= 1900;
                    --month;
                    break;
                }
                default: {
                    if (length >= 19 && length <= 26) {
                        year = Integer.parseInt(stringValue.substring(0, 4));
                        month = Integer.parseInt(stringValue.substring(5, 7));
                        day = Integer.parseInt(stringValue.substring(8, 10));
                        hour = Integer.parseInt(stringValue.substring(11, 13));
                        minutes = Integer.parseInt(stringValue.substring(14, 16));
                        seconds = Integer.parseInt(stringValue.substring(17, 19));
                        break;
                    }
                    throw new SQLException("Bad format for Timestamp ");
                }
            }
            return this.buildTimestmap(year, month, day, hour, minutes, seconds, nanos, calendar, timezone);
        }
        catch (NumberFormatException e) {
            SQLException sqlException = new SQLException("Cannot convert value " + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + " to TIMESTAMP.");
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    public static int getInt(byte[] buf, int offset, int endpos) throws NumberFormatException {
        int len = endpos - offset;
        int res = 0;
        for (int i = 0; i < len; ++i) {
            int power = len - i - 1;
            res += (int)((double)(buf[offset + i] - 48) * Math.pow(10.0, power));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestampFromBytes(ColumnDefinition columnInfo, Calendar calendar, TimeZone timezone) throws SQLException {
        int start;
        int end = this.pos + this.length - 1;
        for (start = this.pos; start <= end && Character.isWhitespace(this.buf[start]); ++start) {
        }
        while (end >= start && Character.isWhitespace(this.buf[end])) {
            --end;
        }
        int newLength = end - start + 1;
        byte[] bytes = new byte[newLength];
        System.arraycopy(this.buf, start, bytes, 0, newLength);
        int length = bytes.length;
        int nanosPos = -1;
        int nanosLength = 0;
        boolean haveHalfLine = false;
        boolean haveColon = false;
        for (int i = 0; i < length; ++i) {
            if (bytes[i] == 45) {
                haveHalfLine = true;
            }
            if (bytes[i] == 58) {
                haveColon = true;
            }
            if (bytes[i] != 46) continue;
            length = i;
            nanosPos = i;
            nanosLength = bytes.length - length - 1;
        }
        try {
            boolean dateTimeIsZero;
            int year = 1970;
            int month = 0;
            int day = 0;
            int hour = 0;
            int minutes = 0;
            int seconds = 0;
            int nanos = 0;
            if (nanosLength > 0 && nanosPos > 0) {
                nanos = RowProtocol.getInt(bytes, nanosPos + 1, bytes.length);
                if (nanosLength < 9) {
                    int factor = (int)Math.pow(10.0, 9 - nanosLength);
                    nanos *= factor;
                }
            }
            switch (length) {
                case 2: 
                case 4: 
                case 6: {
                    year = RowProtocol.getInt(bytes, 0, 2);
                    if (year <= 69) {
                        year += 100;
                    }
                    year += 1900;
                    switch (length) {
                        case 2: {
                            month = 1;
                            day = 1;
                            break;
                        }
                        case 4: {
                            month = RowProtocol.getInt(bytes, 2, 4);
                            day = 1;
                            break;
                        }
                        case 6: {
                            month = RowProtocol.getInt(bytes, 2, 4);
                            day = RowProtocol.getInt(bytes, 4, 6);
                        }
                    }
                    break;
                }
                case 12: {
                    year = RowProtocol.getInt(bytes, 0, 2);
                    if (year <= 69) {
                        year += 100;
                    }
                    year += 1900;
                    month = RowProtocol.getInt(bytes, 2, 4);
                    day = RowProtocol.getInt(bytes, 4, 6);
                    hour = RowProtocol.getInt(bytes, 6, 8);
                    minutes = RowProtocol.getInt(bytes, 8, 10);
                    seconds = RowProtocol.getInt(bytes, 10, 12);
                    break;
                }
                case 14: {
                    year = RowProtocol.getInt(bytes, 0, 4);
                    month = RowProtocol.getInt(bytes, 4, 6);
                    day = RowProtocol.getInt(bytes, 6, 8);
                    hour = RowProtocol.getInt(bytes, 8, 10);
                    minutes = RowProtocol.getInt(bytes, 10, 12);
                    seconds = RowProtocol.getInt(bytes, 12, 14);
                    break;
                }
                case 10: {
                    if (columnInfo.getColumnType() == ColumnType.DATE || haveHalfLine) {
                        year = RowProtocol.getInt(bytes, 0, 4);
                        month = RowProtocol.getInt(bytes, 5, 7);
                        day = RowProtocol.getInt(bytes, 8, 10);
                        hour = 0;
                        minutes = 0;
                        break;
                    }
                    year = RowProtocol.getInt(bytes, 0, 2);
                    if (year <= 69) {
                        year += 100;
                    }
                    month = RowProtocol.getInt(bytes, 2, 4);
                    day = RowProtocol.getInt(bytes, 4, 6);
                    hour = RowProtocol.getInt(bytes, 6, 8);
                    minutes = RowProtocol.getInt(bytes, 8, 10);
                    year += 1900;
                    break;
                }
                case 8: {
                    if (haveColon) {
                        hour = RowProtocol.getInt(bytes, 0, 2);
                        minutes = RowProtocol.getInt(bytes, 3, 5);
                        seconds = RowProtocol.getInt(bytes, 6, 8);
                        year = 1970;
                        month = 1;
                        day = 1;
                        break;
                    }
                    year = RowProtocol.getInt(bytes, 0, 4);
                    month = RowProtocol.getInt(bytes, 4, 6);
                    day = RowProtocol.getInt(bytes, 6, 8);
                    year -= 1900;
                    --month;
                    break;
                }
                default: {
                    if (length >= 19 && length <= 26) {
                        year = RowProtocol.getInt(bytes, 0, 4);
                        month = RowProtocol.getInt(bytes, 5, 7);
                        day = RowProtocol.getInt(bytes, 8, 10);
                        hour = RowProtocol.getInt(bytes, 11, 13);
                        minutes = RowProtocol.getInt(bytes, 14, 16);
                        seconds = RowProtocol.getInt(bytes, 17, 19);
                        break;
                    }
                    throw new SQLException("Bad format for Timestamp ");
                }
            }
            boolean dateIsZero = year + month + day == 0;
            boolean bl = dateTimeIsZero = year + month + day + hour + minutes + seconds == 0;
            if (bytes[0] == 48 && (dateIsZero || dateTimeIsZero)) {
                Timestamp tt;
                Calendar localCal;
                if (this.options.zeroDateTimeBehavior.equalsIgnoreCase("exception")) {
                    if (this.options.compatibleMysqlVersion == 8) {
                        throw new SQLException("Zero date value prohibited");
                    }
                    throw new SQLException("Value '" + new String(this.buf, this.pos, length, this.getCurrentEncoding(columnInfo.getColumnType())) + "' can not be represented as java.sql.Timestamp");
                }
                if (this.options.zeroDateTimeBehavior.equalsIgnoreCase("convertToNull")) {
                    this.lastValueNull |= 2;
                    return null;
                }
                year = 1;
                month = 1;
                day = 1;
                Calendar calendar2 = localCal = this.getCalendarInstance(calendar);
                synchronized (calendar2) {
                    localCal.clear();
                    localCal.set(year, month - 1, day, hour, minutes, seconds);
                    tt = new Timestamp(localCal.getTimeInMillis());
                }
                tt.setNanos(nanos);
                return tt;
            }
            Timestamp timestamp = this.buildTimestmap(year, month, day, hour, minutes, seconds, nanos, calendar, timezone);
            return timestamp;
        }
        catch (NumberFormatException e) {
            SQLException sqlException = new SQLException("Cannot convert value " + new String(this.buf, this.pos, length, this.getCurrentEncoding(columnInfo.getColumnType())) + " to TIMESTAMP.");
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    public Time getTimeFromString(String raw, Calendar cal) throws SQLException {
        String[] rawPart;
        String newRaw = raw;
        if (raw.contains(".")) {
            String[] split = raw.split("\\.");
            newRaw = split[0];
        }
        if (!this.options.useLegacyDatetimeCode && (raw.startsWith("-") || raw.split(":").length != 3 || raw.indexOf(":") > 3 || newRaw.length() != 5 && newRaw.length() != 8)) {
            throw new SQLException("Time format \"" + raw + "\" incorrect, must be HH:mm:ss");
        }
        boolean negate = raw.startsWith("-");
        if (negate) {
            raw = raw.substring(1);
        }
        if ((rawPart = raw.split(":")).length == 3) {
            int hour = Integer.parseInt(rawPart[0]);
            int minutes = Integer.parseInt(rawPart[1]);
            int seconds = Integer.parseInt(rawPart[2].substring(0, 2));
            Calendar calendar = this.getCalendarInstance(cal);
            if (this.options.useLegacyDatetimeCode) {
                calendar.setLenient(true);
            }
            calendar.clear();
            calendar.set(1970, 0, 1, (negate ? -1 : 1) * hour, minutes, seconds);
            int nanoseconds = this.extractNanos(raw);
            calendar.set(14, nanoseconds / 1000000);
            return new Time(calendar.getTimeInMillis());
        }
        throw new SQLException(raw + " cannot be parse as time. time must have \"99:99:99\" format");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDateFromString(String raw, Calendar cal, ColumnDefinition columnInfo) throws SQLException {
        if (raw == null) {
            return null;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int index = raw.indexOf(".");
        if (index > -1) {
            raw = raw.substring(0, index);
        }
        if (raw.equals("00000000000000") || raw.equals("0") || raw.equals("0000-00-00") || raw.equals("0000-00-00 00:00:00")) {
            if (this.options.zeroDateTimeBehavior.equalsIgnoreCase("exception")) {
                throw new SQLException("Value '" + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + "' can not be represented as java.sql.Timestamp");
            }
            if (this.options.zeroDateTimeBehavior.equalsIgnoreCase("convertToNull")) {
                this.lastValueNull |= 2;
                return null;
            }
            year = 1;
            month = 1;
            day = 1;
            Calendar calendar = this.getCalendarInstance(cal);
            if (this.options.useLegacyDatetimeCode) {
                calendar.setLenient(true);
            }
            calendar.clear();
            calendar.set(year, month - 1, day);
            Date dt = new Date(calendar.getTimeInMillis());
            return dt;
        }
        if (raw.length() < 10) {
            if (raw.length() == 8) {
                Calendar calendar = this.getCalendarInstance(cal);
                if (this.options.useLegacyDatetimeCode) {
                    calendar.setLenient(true);
                }
                Calendar dt = calendar;
                synchronized (dt) {
                    Date date;
                    java.util.Date origCalDate = calendar.getTime();
                    try {
                        calendar.clear();
                        calendar.set(14, 0);
                        calendar.set(1970, 0, 1, 0, 0, 0);
                        long dateAsMillis = calendar.getTimeInMillis();
                        date = new Date(dateAsMillis);
                        calendar.setTime(origCalDate);
                    }
                    catch (Throwable throwable) {
                        calendar.setTime(origCalDate);
                        throw throwable;
                    }
                    return date;
                }
            }
            throw new SQLException("date format error");
        }
        if (raw.length() != 18) {
            year = Integer.parseInt(raw.substring(0, 4));
            month = Integer.parseInt(raw.substring(5, 7));
            day = Integer.parseInt(raw.substring(8, 10));
        }
        Calendar calendar = this.getCalendarInstance(cal);
        if (this.options.useLegacyDatetimeCode) {
            calendar.setLenient(true);
        }
        calendar.clear();
        calendar.set(year, month - 1, day, 0, 0, 0);
        Date dt = new Date(calendar.getTimeInMillis());
        return dt;
    }

    public int convertToZeroWithEmptyCheck() throws SQLException {
        if (this.options.emptyStringsConvertToZero) {
            return 0;
        }
        throw new SQLException("Can't convert empty string ('') to numeric");
    }

    static {
        isIntegerRegex = Pattern.compile("^-?\\d+\\.[0-9]+$");
        TEXT_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
        TEXT_OFFSET_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(TEXT_LOCAL_DATE_TIME).appendOffsetId().toFormatter();
        TEXT_ZONED_DATE_TIME = new DateTimeFormatterBuilder().append(TEXT_OFFSET_DATE_TIME).optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter();
    }
}

