/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.ClientSidePreparedStatement;
import com.oceanbase.jdbc.JDBC4ResultSet;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.OceanBaseOracleDatabaseMetadata;
import com.oceanbase.jdbc.OceanBaseStatement;
import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.io.input.StandardPacketInputStream;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.constant.Version;
import com.oceanbase.jdbc.internal.util.dao.Identifier;
import com.oceanbase.jdbc.util.Options;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBC4DatabaseMetaData
extends OceanBaseOracleDatabaseMetadata {
    public static final String DRIVER_NAME = "OceanBase Connector/J";
    private final UrlParser urlParser;
    private final OceanBaseConnection connection;
    private boolean datePrecisionColumnExist = true;
    Protocol protocol = null;
    private static final Pattern RETURN_PATTERN = Pattern.compile("\\s*(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*(CHARSET\\s+)?(\\w+)?\\s*", 2);
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\s*(IN\\s+|OUT\\s+|INOUT\\s+)?(\\`[\\w\\d\\S]+\\`)\\s+(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*", 2);
    private static final Pattern ORALCLE_PARAMETER_PATTERN = Pattern.compile("\\s*(IN\\s+|OUT\\s+|INOUT\\s+)?(\"[\\w\\d\\S]+\")\\s+(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*", 2);
    private static final Pattern SQL_WILDCARD_PATTERN = Pattern.compile("^%|^_|[^/]%|[^/]_", 2);
    private static final Pattern SQL_ESCAPE_PATTERN = Pattern.compile("/", 2);
    String[] exportKeysColumnNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
    ColumnType[] exportKeysColumnTypes = new ColumnType[]{ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.SMALLINT, ColumnType.SMALLINT, ColumnType.SMALLINT, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.SMALLINT};

    public JDBC4DatabaseMetaData(Connection connection, UrlParser urlParser) {
        super(urlParser, connection);
        this.connection = (OceanBaseConnection)connection;
        this.urlParser = urlParser;
        this.protocol = this.connection.getProtocol();
    }

    private static String columnTypeClause(Options options) {
        String upperCaseWithoutSize = " UCASE(IF( COLUMN_TYPE LIKE '%(%)%', CONCAT(SUBSTRING( COLUMN_TYPE,1, LOCATE('(',COLUMN_TYPE) - 1 ), SUBSTRING(COLUMN_TYPE ,1+locate(')', COLUMN_TYPE))), COLUMN_TYPE))";
        if (options.tinyInt1isBit) {
            String type = null;
            type = options.transformedBitIsBoolean ? "BOOLEAN" : "BIT";
            upperCaseWithoutSize = " IF(COLUMN_TYPE like 'tinyint(1)%', '" + type + "', " + upperCaseWithoutSize + ")";
        }
        if (!options.yearIsDateType) {
            return " IF(COLUMN_TYPE IN ('year(2)', 'year(4)'), 'SMALLINT', " + upperCaseWithoutSize + ")";
        }
        return upperCaseWithoutSize;
    }

    private static int skipWhite(char[] part, int startPos) {
        for (int i = startPos; i < part.length; ++i) {
            if (Character.isWhitespace(part[i])) continue;
            return i;
        }
        return part.length;
    }

    private static int parseIdentifier(char[] part, int startPos, Identifier identifier) throws ParseException {
        int pos = JDBC4DatabaseMetaData.skipWhite(part, startPos);
        if (part[pos] != '`') {
            throw new ParseException(new String(part), pos);
        }
        ++pos;
        StringBuilder sb = new StringBuilder();
        int quotes = 0;
        while (pos < part.length) {
            char ch = part[pos];
            if (ch == '`') {
                ++quotes;
            } else {
                for (int j = 0; j < quotes / 2; ++j) {
                    sb.append('`');
                }
                if (quotes % 2 == 1) {
                    if (ch == '.') {
                        if (identifier.schema != null) {
                            throw new ParseException(new String(part), pos);
                        }
                        identifier.schema = sb.toString();
                        return JDBC4DatabaseMetaData.parseIdentifier(part, pos + 1, identifier);
                    }
                    identifier.name = sb.toString();
                    return pos;
                }
                quotes = 0;
                sb.append(ch);
            }
            ++pos;
        }
        throw new ParseException(new String(part), startPos);
    }

    private static int parseIdentifierList(char[] part, int startPos, List<Identifier> list) throws ParseException {
        int pos = JDBC4DatabaseMetaData.skipWhite(part, startPos);
        if (part[pos] != '(') {
            throw new ParseException(new String(part), pos);
        }
        ++pos;
        block5: while (true) {
            pos = JDBC4DatabaseMetaData.skipWhite(part, pos);
            char ch = part[pos];
            switch (ch) {
                case ')': {
                    return pos + 1;
                }
                case '`': {
                    Identifier id = new Identifier();
                    pos = JDBC4DatabaseMetaData.parseIdentifier(part, pos, id);
                    list.add(id);
                    continue block5;
                }
                case ',': {
                    ++pos;
                    continue block5;
                }
            }
            break;
        }
        throw new ParseException(new String(part, startPos, part.length - startPos), startPos);
    }

    private static int skipKeyword(char[] part, int startPos, String keyword) throws ParseException {
        int pos = JDBC4DatabaseMetaData.skipWhite(part, startPos);
        int i = 0;
        while (i < keyword.length()) {
            if (part[pos] != keyword.charAt(i)) {
                throw new ParseException(new String(part), pos);
            }
            ++i;
            ++pos;
        }
        return pos;
    }

    private static int getImportedKeyAction(String actionKey) {
        if (actionKey == null) {
            return 1;
        }
        switch (actionKey) {
            case "NO ACTION": {
                return 3;
            }
            case "CASCADE": {
                return 0;
            }
            case "SET NULL": {
                return 2;
            }
            case "SET DEFAULT": {
                return 4;
            }
            case "RESTRICT": {
                return 1;
            }
        }
        throw new IllegalArgumentException("Illegal key action '" + actionKey + "' specified.");
    }

    private static ResultSet getImportedKeys(String tableDef, String tableName, String catalog, OceanBaseConnection connection) throws ParseException {
        String[] columnNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        ColumnType[] columnTypes = new ColumnType[]{ColumnType.VARCHAR, ColumnType.NULL, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.NULL, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.SMALLINT, ColumnType.SMALLINT, ColumnType.SMALLINT, ColumnType.VARCHAR, ColumnType.NULL, ColumnType.SMALLINT};
        String[] parts = tableDef.split("\n");
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (String part : parts) {
            if (!(part = part.trim()).startsWith("CONSTRAINT") && !part.contains("FOREIGN KEY")) continue;
            char[] partChar = part.toCharArray();
            Identifier constraintName = new Identifier();
            int pos = JDBC4DatabaseMetaData.skipKeyword(partChar, 0, "CONSTRAINT");
            pos = JDBC4DatabaseMetaData.parseIdentifier(partChar, pos, constraintName);
            pos = JDBC4DatabaseMetaData.skipKeyword(partChar, pos, "FOREIGN KEY");
            ArrayList<Identifier> foreignKeyCols = new ArrayList<Identifier>();
            pos = JDBC4DatabaseMetaData.parseIdentifierList(partChar, pos, foreignKeyCols);
            pos = JDBC4DatabaseMetaData.skipKeyword(partChar, pos, "REFERENCES");
            Identifier pkTable = new Identifier();
            pos = JDBC4DatabaseMetaData.parseIdentifier(partChar, pos, pkTable);
            ArrayList<Identifier> primaryKeyCols = new ArrayList<Identifier>();
            JDBC4DatabaseMetaData.parseIdentifierList(partChar, pos, primaryKeyCols);
            if (primaryKeyCols.size() != foreignKeyCols.size()) {
                throw new ParseException(tableDef, 0);
            }
            int onUpdateReferenceAction = 1;
            int onDeleteReferenceAction = 1;
            for (String referenceAction : new String[]{"RESTRICT", "CASCADE", "SET NULL", "NO ACTION"}) {
                if (part.contains("ON UPDATE " + referenceAction)) {
                    onUpdateReferenceAction = JDBC4DatabaseMetaData.getImportedKeyAction(referenceAction);
                }
                if (!part.contains("ON DELETE " + referenceAction)) continue;
                onDeleteReferenceAction = JDBC4DatabaseMetaData.getImportedKeyAction(referenceAction);
            }
            for (int i = 0; i < primaryKeyCols.size(); ++i) {
                String[] row = new String[columnNames.length];
                row[0] = pkTable.schema;
                if (row[0] == null) {
                    row[0] = catalog;
                }
                row[1] = null;
                row[2] = pkTable.name;
                row[3] = ((Identifier)primaryKeyCols.get((int)i)).name;
                row[4] = catalog;
                row[5] = null;
                row[6] = tableName;
                row[7] = ((Identifier)foreignKeyCols.get((int)i)).name;
                row[8] = Integer.toString(i + 1);
                row[9] = Integer.toString(onUpdateReferenceAction);
                row[10] = Integer.toString(onDeleteReferenceAction);
                row[11] = constraintName.name;
                row[12] = null;
                row[13] = Integer.toString(7);
                data.add(row);
            }
        }
        String[][] arr = (String[][])data.toArray((T[])new String[0][]);
        Arrays.sort(arr, (row1, row2) -> {
            int result = row1[0].compareTo(row2[0]);
            if (result == 0 && (result = row1[2].compareTo(row2[2])) == 0 && (result = row1[8].length() - row2[8].length()) == 0) {
                result = row1[8].compareTo(row2[8]);
            }
            return result;
        });
        return SelectResultSet.createResultSet(columnNames, columnTypes, arr, connection.getProtocol());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return this.keysQuery(null, null, schema, table, "ORDER BY pktable_schem, pktable_name, key_seq");
        }
        if (table == null) {
            throw new SQLException("Table not specified.");
        }
        if (table.contains("`")) {
            table = table.replace("`", "");
        }
        ArrayList<String> tableNameList = new ArrayList<String>();
        tableNameList.add(table);
        try (ResultSet allTableRS = this.getAllTablesResultSet(tableNameList, catalog);){
            ArrayList<String[]> list = new ArrayList<String[]>();
            while (allTableRS.next()) {
                String[] data = new String[14];
                String tableType = allTableRS.getString("Type");
                if (tableType == null || !tableType.toUpperCase(Locale.ROOT).equals("INNODB") && !tableType.toUpperCase(Locale.ROOT).equals("SUPPORTS_FK")) continue;
                String tableComment = allTableRS.getString("Comment").trim();
                String fkTableName = allTableRS.getString("Name");
                if (tableComment == null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(tableComment, ";", false);
                if (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                }
                while (stringTokenizer.hasMoreTokens()) {
                    String keys = stringTokenizer.nextToken();
                    int fkParamOpenIndex = keys.indexOf("(");
                    if (fkParamOpenIndex == -1) {
                        throw new SQLException("Error parsing foreign keys definition, couldn't find start of local columns list.");
                    }
                    String constraintName = keys.substring(1, fkParamOpenIndex);
                    int fkParamCloseIndex = (keys = keys.substring(fkParamOpenIndex)).indexOf(")");
                    if (fkParamCloseIndex == -1) {
                        throw new SQLException("Error parsing foreign keys definition, couldn't find start of local columns list.");
                    }
                    String fkParamNames = keys.substring(1, fkParamCloseIndex);
                    int refIndex = keys.indexOf("REFER");
                    if (refIndex == -1) {
                        throw new SQLException("Error parsing foreign keys definition, couldn't find start of referenced tables list");
                    }
                    int refParamOpenIndex = keys.indexOf("(", refIndex);
                    if (refParamOpenIndex == -1) {
                        throw new SQLException("Error parsing foreign keys definition, couldn't find start of referenced columns list");
                    }
                    String refCatalogAndTable = keys.substring(refIndex + "REFER".length() + 1, refParamOpenIndex);
                    int slashIndex = refCatalogAndTable.indexOf("/");
                    if (slashIndex == -1) {
                        throw new SQLException("Error parsing foreign keys definition, couldn't find name of referenced catalog.");
                    }
                    String refCatalog = refCatalogAndTable.substring(0, slashIndex);
                    refCatalog = this.removeQuoted(refCatalog);
                    String refTableName = refCatalogAndTable.substring(slashIndex + 1);
                    refTableName = this.removeQuoted(refTableName);
                    if (fkTableName.compareTo(table) != 0) continue;
                    int refParamCloseIndex = keys.indexOf(")", refParamOpenIndex);
                    if (refParamCloseIndex == -1) {
                        throw new SQLException("Error parsing foreign keys definition, couldn't find end of referenced columns list.");
                    }
                    String refParamNames = keys.substring(refParamOpenIndex + 1, refParamCloseIndex);
                    String[] refParamList = refParamNames.split(",");
                    String[] fkParamList = fkParamNames.split(",");
                    int fkCur = 0;
                    int refCur = 0;
                    int keySeq = 1;
                    while (fkCur < fkParamList.length) {
                        String lColumnName = this.removeQuoted(fkParamList[fkCur++]);
                        String rColumnName = null;
                        if (refCur < refParamList.length) {
                            rColumnName = this.removeQuoted(refParamList[refCur++]);
                        }
                        int updateRuleAction = 3;
                        int deleteRuleAction = 3;
                        int lastIndex = keys.lastIndexOf(")");
                        if (lastIndex != keys.length() - 1) {
                            String options = keys.substring(lastIndex + 1);
                            String optionsForUpdate = options.substring(options.indexOf("ON UPDATE"));
                            if (optionsForUpdate.startsWith("ON UPDATE CASCADE")) {
                                updateRuleAction = 0;
                            } else if (optionsForUpdate.startsWith("ON UPDATE SET NUL")) {
                                updateRuleAction = 2;
                            } else if (optionsForUpdate.startsWith("ON UPDATE RESTRICT")) {
                                updateRuleAction = 1;
                            } else if (optionsForUpdate.startsWith("ON UPDATE NO ACTION")) {
                                updateRuleAction = 3;
                            }
                            String optionsForDelete = options.substring(options.indexOf("ON DELETE"));
                            if (optionsForDelete.startsWith("ON DELETE CASCADE")) {
                                deleteRuleAction = 0;
                            } else if (optionsForDelete.startsWith("ON DELETE SET NUL")) {
                                deleteRuleAction = 2;
                            } else if (optionsForDelete.startsWith("ON DELETE RESTRICT")) {
                                deleteRuleAction = 1;
                            } else if (optionsForDelete.startsWith("ON DELETE NO ACTIO")) {
                                deleteRuleAction = 3;
                            }
                        }
                        data[0] = refCatalog;
                        data[1] = null;
                        data[2] = refTableName;
                        data[3] = rColumnName;
                        data[4] = catalog == null ? this.protocol.getCatalog() : catalog;
                        data[5] = null;
                        data[6] = table;
                        data[7] = lColumnName;
                        data[8] = Integer.toString(keySeq++);
                        data[9] = Integer.toString(updateRuleAction);
                        data[10] = Integer.toString(deleteRuleAction);
                        data[11] = constraintName;
                        data[12] = null;
                        data[13] = Integer.toString(7);
                        list.add(data);
                        data = new String[14];
                    }
                }
            }
            String[][] val = new String[list.size()][];
            for (int j = 0; j < list.size(); ++j) {
                val[j] = (String[])list.get(j);
            }
            JDBC4ResultSet jDBC4ResultSet = SelectResultSet.createResultSet(this.exportKeysColumnNames, this.exportKeysColumnTypes, val, this.protocol);
            return jDBC4ResultSet;
        }
    }

    private String dataTypeClause(String fullTypeColumnName) {
        Options options = this.urlParser.getOptions();
        return " CASE data_type WHEN 'bit' THEN -7 WHEN 'tinyblob' THEN -3 WHEN 'mediumblob' THEN -4 WHEN 'longblob' THEN -4 WHEN 'blob' THEN -4 WHEN 'tinytext' THEN 12 WHEN 'mediumtext' THEN -1 WHEN 'longtext' THEN -1 WHEN 'text' THEN -1 WHEN 'date' THEN 91 WHEN 'datetime' THEN 93 WHEN 'decimal' THEN 3 WHEN 'double' THEN 8 WHEN 'enum' THEN 12 WHEN 'float' THEN 7 WHEN 'int' THEN IF( " + fullTypeColumnName + " like '%unsigned%', " + 4 + "," + 4 + ") WHEN 'bigint' THEN " + -5 + " WHEN 'mediumint' THEN " + 4 + " WHEN 'null' THEN " + 0 + " WHEN 'set' THEN " + 12 + " WHEN 'smallint' THEN IF( " + fullTypeColumnName + " like '%unsigned%', " + 5 + "," + 5 + ") WHEN 'varchar' THEN " + 12 + " WHEN 'varbinary' THEN " + -3 + " WHEN 'char' THEN " + 1 + " WHEN 'binary' THEN " + -2 + " WHEN 'time' THEN " + 92 + " WHEN 'timestamp' THEN " + 93 + " WHEN 'tinyint' THEN " + (options.tinyInt1isBit ? "IF(" + fullTypeColumnName + " like 'tinyint(1)%'," + (options.transformedBitIsBoolean ? 16 : -7) + "," + -6 + ") " : Integer.valueOf(-6)) + " WHEN 'year' THEN " + (options.yearIsDateType ? 91 : 5) + " ELSE " + 1111 + " END ";
    }

    private String escapeQuote(String value) {
        if (value == null) {
            return "NULL";
        }
        return "'" + Utils.escapeString(value, this.connection.getProtocol().noBackslashEscapes()) + "'";
    }

    private String catalogCond(String columnName, String catalog) {
        if (catalog == null) {
            if (this.connection.nullCatalogMeansCurrent) {
                return "(ISNULL(database()) OR (" + columnName + " = database()))";
            }
            return "(1 = 1)";
        }
        if (catalog.isEmpty()) {
            return "(ISNULL(database()) OR (" + columnName + " = database()))";
        }
        return "(" + columnName + " = " + this.escapeQuote(catalog) + ")";
    }

    private String patternCond(String columnName, String tableName) {
        if (tableName == null) {
            return "";
        }
        String predicate = tableName.indexOf(37) == -1 && tableName.indexOf(95) == -1 ? "=" : "LIKE";
        return " AND " + columnName + " " + predicate + " '" + Utils.escapeString(tableName, true) + "' ";
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getPrimaryKeys(catalog, schema, table);
        }
        if (table != null && table.contains("`")) {
            table = table.replace("`", "");
        }
        String sql = "SELECT A.TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM, A.TABLE_NAME, A.COLUMN_NAME, B.SEQ_IN_INDEX KEY_SEQ, B.INDEX_NAME PK_NAME  FROM INFORMATION_SCHEMA.COLUMNS A, INFORMATION_SCHEMA.STATISTICS B WHERE A.COLUMN_KEY in ('PRI','pri') AND B.INDEX_NAME='PRIMARY'  AND " + this.catalogCond("A.TABLE_SCHEMA", catalog) + " AND " + this.catalogCond("B.TABLE_SCHEMA", catalog) + this.patternCond("A.TABLE_NAME", table) + this.patternCond("B.TABLE_NAME", table) + " AND A.TABLE_SCHEMA = B.TABLE_SCHEMA AND A.TABLE_NAME = B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME  ORDER BY A.COLUMN_NAME";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getTables(catalog, schemaPattern, tableNamePattern, types);
        }
        Protocol protocol = this.connection.getProtocol();
        Options options = protocol.getOptions();
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"};
        ColumnType[] columnTypes = new ColumnType[]{ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR};
        if (options.useInformationSchema) {
            return this.getTablesUsingInfoSchema(columnTypes, columnNames, tableNamePattern, types, catalog);
        }
        ResultSet rs = this.getTablesImpl(columnTypes, columnNames, tableNamePattern, types, catalog);
        return rs;
    }

    ResultSet getTablesUsingInfoSchema(ColumnType[] columnTypes, String[] columnNames, String tableNamePattern, String[] types, String catalog) throws SQLException {
        if (catalog == null || catalog.length() == 0) {
            catalog = this.connection.getCatalog();
        }
        StringBuilder sqlBuf = new StringBuilder("SELECT TABLE_SCHEMA AS TABLE_CAT, NULL AS TABLE_SCHEM,");
        sqlBuf.append(" TABLE_NAME, CASE WHEN TABLE_TYPE='BASE TABLE' THEN CASE WHEN TABLE_SCHEMA = 'mysql' OR TABLE_SCHEMA = 'performance_schema' THEN 'SYSTEM TABLE' ");
        sqlBuf.append("ELSE 'TABLE' END WHEN TABLE_TYPE='TEMPORARY' THEN 'LOCAL_TEMPORARY' ELSE TABLE_TYPE END AS TABLE_TYPE, ");
        sqlBuf.append("TABLE_COMMENT AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, ");
        sqlBuf.append("NULL AS REF_GENERATION FROM INFORMATION_SCHEMA.TABLES");
        if (catalog != null || tableNamePattern != null) {
            sqlBuf.append(" WHERE");
        }
        if (catalog != null) {
            sqlBuf.append(" TABLE_SCHEMA = ?");
        }
        if (tableNamePattern != null) {
            if (catalog != null) {
                sqlBuf.append(" AND");
            }
            sqlBuf.append(tableNamePattern.indexOf(37) > -1 || tableNamePattern.indexOf(95) > -1 ? " TABLE_NAME LIKE ?" : " TABLE_NAME = ?");
        }
        if (types != null && types.length > 0) {
            sqlBuf.append(" HAVING TABLE_TYPE IN (?,?,?,?,?)");
        }
        sqlBuf.append(" ORDER BY TABLE_TYPE, TABLE_SCHEMA, TABLE_NAME");
        try (ClientSidePreparedStatement pStmt = this.connection.clientPrepareStatement(sqlBuf.toString());){
            int nextId = 1;
            if (catalog != null) {
                pStmt.setString(nextId++, catalog);
            }
            if (tableNamePattern != null) {
                pStmt.setString(nextId++, tableNamePattern);
            }
            if (types != null && types.length > 0) {
                int i;
                for (i = 0; i < 5; ++i) {
                    pStmt.setNull(nextId + i, 12);
                }
                for (i = 0; i < types.length; ++i) {
                    TableType tableType = TableType.getTableTypeEqualTo(types[i]);
                    if (tableType == TableType.UNKNOWN) continue;
                    pStmt.setString(nextId++, tableType.getName());
                }
            }
            ResultSet rs = pStmt.executeQuery();
            rs.last();
            int totalRows = rs.getRow();
            String[][] val = new String[totalRows][];
            rs.first();
            int resultIndex = 0;
            while (totalRows != 0) {
                String[] data = new String[]{rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getString(8), rs.getString(9), rs.getString(10)};
                val[resultIndex] = data;
                ++resultIndex;
                if (rs.next()) continue;
            }
            JDBC4ResultSet jDBC4ResultSet = JDBC4ResultSet.createResultSet(columnNames, columnTypes, val, this.protocol);
            return jDBC4ResultSet;
        }
    }

    ResultSet getTablesImpl(ColumnType[] columnTypes, String[] columnNames, String tableNamePattern, String[] types, String catalog) throws SQLException {
        boolean isSystemDb;
        boolean bl = isSystemDb = "information_schema".equalsIgnoreCase(catalog) || "mysql".equalsIgnoreCase(catalog) || "performance_schema".equalsIgnoreCase(catalog);
        if (catalog == null || catalog.length() == 0) {
            catalog = this.connection.getCatalog();
        }
        StringBuilder getTablesSql = new StringBuilder();
        getTablesSql.append("SHOW FULL TABLES FROM ");
        getTablesSql.append("`");
        getTablesSql.append(catalog);
        getTablesSql.append("` LIKE '");
        if (tableNamePattern == null) {
            getTablesSql.append("%");
        } else {
            if (!this.protocol.isOracleMode()) {
                tableNamePattern = this.removeQuoted(tableNamePattern);
            }
            getTablesSql.append(tableNamePattern);
        }
        getTablesSql.append("'");
        try (ResultSet rs = this.executeQuery(getTablesSql.toString());){
            boolean isTables = false;
            boolean isViews = false;
            boolean isSystemTables = false;
            boolean isSystemViews = false;
            boolean isLocalTemporaries = false;
            if (types == null || types.length == 0) {
                isTables = true;
                isViews = true;
                isSystemTables = true;
                isSystemViews = true;
                isLocalTemporaries = true;
            } else {
                for (int i = 0; i < types.length; ++i) {
                    if ("TABLE".equals(types[i]) || "BASE TABLE".equals(types[i])) {
                        isTables = true;
                        continue;
                    }
                    if ("VIEW".equals(types[i])) {
                        isViews = true;
                        continue;
                    }
                    if ("SYSTEM TABLE".equals(types[i])) {
                        isSystemTables = true;
                        continue;
                    }
                    if ("SYSTEM VIEW".equals(types[i])) {
                        isSystemViews = true;
                        continue;
                    }
                    if (!"LOCAL TEMPORARY".equals(types[i])) continue;
                    isLocalTemporaries = true;
                }
            }
            int columnIndex = 1;
            boolean hasTableType = true;
            columnIndex = rs.findColumn("table_type");
            TreeMap<TableMetaData, String[]> map = new TreeMap<TableMetaData, String[]>();
            while (rs.next()) {
                String[] data = new String[10];
                boolean shouldPut = false;
                data[0] = catalog;
                data[1] = null;
                data[2] = rs.getString(1);
                data[4] = new byte[0].toString();
                data[5] = null;
                data[6] = null;
                data[7] = null;
                data[8] = null;
                data[9] = null;
                TableMetaData key = null;
                if (hasTableType) {
                    String tableType = rs.getString(columnIndex);
                    if ("TABLE".equals(tableType) || "BASE TABLE".equals(tableType)) {
                        if (isSystemDb && isSystemTables) {
                            shouldPut = true;
                            key = new TableMetaData("SYSTEM TABLE", catalog, null, rs.getString(1));
                        } else if (!isSystemDb && isTables) {
                            shouldPut = true;
                            key = new TableMetaData("TABLE", catalog, null, rs.getString(1));
                        }
                        if (!shouldPut) continue;
                        data[3] = "TABLE";
                        map.put(key, data);
                        continue;
                    }
                    if ("VIEW".equals(tableType)) {
                        if (!isViews) continue;
                        key = new TableMetaData("VIEW", catalog, null, rs.getString(1));
                        data[3] = "VIEW";
                        map.put(key, data);
                        continue;
                    }
                    if ("SYSTEM VIEW".equals(tableType)) {
                        if (!isSystemViews) continue;
                        key = new TableMetaData("SYSTEM VIEW", catalog, null, rs.getString(1));
                        data[3] = "SYSTEM VIEW";
                        map.put(key, data);
                        continue;
                    }
                    if ("SYSTEM TABLE".equals(tableType)) {
                        if (!isSystemTables) continue;
                        key = new TableMetaData("SYSTEM TABLE", catalog, null, rs.getString(1));
                        data[3] = "SYSTEM TABLE";
                        map.put(key, data);
                        continue;
                    }
                    if ("LOCAL TEMPORARY".equals(tableType)) {
                        if (!isLocalTemporaries) continue;
                        key = new TableMetaData("LOCAL TEMPORARY", catalog, null, rs.getString(1));
                        data[3] = "LOCAL TEMPORARY";
                        map.put(key, data);
                        continue;
                    }
                    key = new TableMetaData("TABLE", catalog, null, rs.getString(1));
                    data[3] = "TABLE";
                    map.put(key, data);
                    continue;
                }
                key = new TableMetaData("TABLE", catalog, null, rs.getString(1));
                data[3] = "TABLE";
                map.put(key, data);
            }
            Object[] a = map.values().toArray();
            String[][] val = new String[map.size()][];
            for (int j = 0; j < a.length; ++j) {
                val[j] = (String[])a[j];
            }
            JDBC4ResultSet jDBC4ResultSet = JDBC4ResultSet.createResultSet(columnNames, columnTypes, val, this.protocol);
            return jDBC4ResultSet;
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        String tableNamePatternWithNoBacktick = tableNamePattern;
        if (tableNamePatternWithNoBacktick != null && tableNamePatternWithNoBacktick.length() > 2 && tableNamePatternWithNoBacktick.startsWith("`") && tableNamePatternWithNoBacktick.endsWith("`")) {
            tableNamePatternWithNoBacktick = tableNamePatternWithNoBacktick.substring(1, tableNamePatternWithNoBacktick.length() - 1);
        }
        Options options = this.urlParser.getOptions();
        String sql = "SELECT TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM, TABLE_NAME, COLUMN_NAME," + this.dataTypeClause("COLUMN_TYPE") + " DATA_TYPE," + JDBC4DatabaseMetaData.columnTypeClause(options) + " TYPE_NAME,  CASE DATA_TYPE  WHEN 'time' THEN " + (this.datePrecisionColumnExist ? "IF(DATETIME_PRECISION = 0, 10, CAST(11 + DATETIME_PRECISION as signed integer))" : "10") + "  WHEN 'date' THEN 10  WHEN 'datetime' THEN " + (this.datePrecisionColumnExist ? "IF(DATETIME_PRECISION = 0, 19, CAST(20 + DATETIME_PRECISION as signed integer))" : "19") + "  WHEN 'timestamp' THEN " + (this.datePrecisionColumnExist ? "IF(DATETIME_PRECISION = 0, 19, CAST(20 + DATETIME_PRECISION as signed integer))" : "19") + (options.yearIsDateType ? "" : " WHEN 'year' THEN 5") + "  ELSE   IF(NUMERIC_PRECISION IS NULL, LEAST(CHARACTER_MAXIMUM_LENGTH," + Integer.MAX_VALUE + "), NUMERIC_PRECISION)  END COLUMN_SIZE, 65535 BUFFER_LENGTH,  CONVERT (CASE DATA_TYPE WHEN 'year' THEN " + (options.yearIsDateType ? "NUMERIC_SCALE" : "0") + " WHEN 'tinyint' THEN " + (options.tinyInt1isBit ? "0" : "NUMERIC_SCALE") + " ELSE NUMERIC_SCALE END, UNSIGNED INTEGER) DECIMAL_DIGITS, 10 NUM_PREC_RADIX, IF(IS_NULLABLE = 'yes',1,0) NULLABLE,COLUMN_COMMENT REMARKS, COLUMN_DEFAULT COLUMN_DEF, 0 SQL_DATA_TYPE, 0 SQL_DATETIME_SUB,   LEAST(CHARACTER_OCTET_LENGTH," + Integer.MAX_VALUE + ") CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE, NULL SCOPE_CATALOG, NULL SCOPE_SCHEMA, NULL SCOPE_TABLE, NULL SOURCE_DATA_TYPE, IF(EXTRA = 'auto_increment','YES','NO') IS_AUTOINCREMENT,  IF(EXTRA in ('VIRTUAL', 'PERSISTENT', 'VIRTUAL GENERATED', 'STORED GENERATED') ,'YES','NO') IS_GENERATEDCOLUMN  FROM INFORMATION_SCHEMA.COLUMNS  WHERE " + this.catalogCond("TABLE_SCHEMA", catalog) + this.patternCond("TABLE_NAME", tableNamePatternWithNoBacktick) + this.patternCond("COLUMN_NAME", columnNamePattern) + " ORDER BY TABLE_CAT, TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION";
        try {
            return this.executeQuery(sql);
        }
        catch (SQLException sqlException) {
            if (sqlException.getMessage().contains("Unknown column 'DATETIME_PRECISION'")) {
                this.datePrecisionColumnExist = false;
                return this.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
            throw sqlException;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return this.keysQuery(schema, table, null, null, "ORDER BY fktable_schem, fktable_name, key_seq");
        }
        if (table == null) {
            throw new SQLException("Table not specified.");
        }
        ArrayList<String> tableNameList = this.getALlTableNames(catalog);
        try (ResultSet allTableRS = this.getAllTablesResultSet(tableNameList, catalog);){
            ArrayList<String[]> list = new ArrayList<String[]>();
            while (allTableRS.next()) {
                String tableType = allTableRS.getString("Type");
                if (tableType == null || !tableType.toUpperCase(Locale.ROOT).equals("INNODB") && !tableType.toUpperCase(Locale.ROOT).equals("SUPPORTS_FK")) continue;
                String tableComment = allTableRS.getString("Comment").trim();
                String fkTableName = allTableRS.getString("Name");
                if (tableComment == null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(tableComment, ";", false);
                if (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                }
                while (stringTokenizer.hasMoreTokens()) {
                    String keys = stringTokenizer.nextToken();
                    int fkParamOpenIndex = keys.indexOf("(");
                    if (fkParamOpenIndex == -1) {
                        throw new SQLException("Error parsing foreign keys definition, couldn't find start of local columns list.");
                    }
                    String constraintName = keys.substring(1, fkParamOpenIndex);
                    int fkParamCloseIndex = (keys = keys.substring(fkParamOpenIndex)).indexOf(")");
                    if (fkParamCloseIndex == -1) {
                        throw new SQLException("Error parsing foreign keys definition, couldn't find start of local columns list.");
                    }
                    String fkParamNames = keys.substring(1, fkParamCloseIndex);
                    int refIndex = keys.indexOf("REFER");
                    if (refIndex == -1) {
                        throw new SQLException("Error parsing foreign keys definition, couldn't find start of referenced tables list");
                    }
                    int refParamOpenIndex = keys.indexOf("(", refIndex);
                    if (refParamOpenIndex == -1) {
                        throw new SQLException("Error parsing foreign keys definition, couldn't find start of referenced columns list");
                    }
                    String refCatalogAndTable = keys.substring(refIndex + "REFER".length() + 1, refParamOpenIndex);
                    int slashIndex = refCatalogAndTable.indexOf("/");
                    if (slashIndex == -1) {
                        throw new SQLException("Error parsing foreign keys definition, couldn't find name of referenced catalog.");
                    }
                    String refCatalog = refCatalogAndTable.substring(0, slashIndex);
                    refCatalog = this.removeQuoted(refCatalog);
                    String refTableName = refCatalogAndTable.substring(slashIndex + 1);
                    refTableName = this.removeQuoted(refTableName);
                    boolean isExportKeys = true;
                    if (!refTableName.equals(table) && isExportKeys) continue;
                    int refParamCloseIndex = keys.indexOf(")", refParamOpenIndex);
                    if (refParamCloseIndex == -1) {
                        throw new SQLException("Error parsing foreign keys definition, couldn't find end of referenced columns list.");
                    }
                    String refParamNames = keys.substring(refParamOpenIndex + 1, refParamCloseIndex);
                    String[] refParamList = refParamNames.split(",");
                    String[] fkParamList = fkParamNames.split(",");
                    int fkCur = 0;
                    int refCur = 0;
                    int keySeq = 1;
                    while (fkCur < fkParamList.length) {
                        String lColumnName = this.removeQuoted(fkParamList[fkCur++]);
                        String rColumnName = null;
                        if (refCur < refParamList.length) {
                            rColumnName = this.removeQuoted(refParamList[refCur++]);
                        }
                        int updateRuleAction = 3;
                        int deleteRuleAction = 3;
                        int lastIndex = keys.lastIndexOf(")");
                        if (lastIndex != keys.length() - 1) {
                            String options = keys.substring(lastIndex + 1);
                            String optionsForUpdate = options.substring(options.indexOf("ON UPDATE"));
                            if (optionsForUpdate.startsWith("ON UPDATE CASCADE")) {
                                updateRuleAction = 0;
                            } else if (optionsForUpdate.startsWith("ON UPDATE SET NUL")) {
                                updateRuleAction = 2;
                            } else if (optionsForUpdate.startsWith("ON UPDATE RESTRICT")) {
                                updateRuleAction = 1;
                            } else if (optionsForUpdate.startsWith("ON UPDATE NO ACTION")) {
                                updateRuleAction = 3;
                            }
                            String optionsForDelete = options.substring(options.indexOf("ON DELETE"));
                            if (optionsForDelete.startsWith("ON DELETE CASCADE")) {
                                deleteRuleAction = 0;
                            } else if (optionsForDelete.startsWith("ON DELETE SET NUL")) {
                                deleteRuleAction = 2;
                            } else if (optionsForDelete.startsWith("ON DELETE RESTRICT")) {
                                deleteRuleAction = 1;
                            } else if (optionsForDelete.startsWith("ON DELETE NO ACTIO")) {
                                deleteRuleAction = 3;
                            }
                        }
                        String[] data = new String[]{refCatalog, null, isExportKeys ? refTableName : table, rColumnName, catalog, null, isExportKeys ? fkTableName : table, lColumnName, Integer.toString(keySeq++), Integer.toString(updateRuleAction), Integer.toString(deleteRuleAction), constraintName, null, Integer.toString(7)};
                        list.add(data);
                    }
                }
            }
            String[][] val = new String[list.size()][];
            for (int j = 0; j < list.size(); ++j) {
                val[j] = (String[])list.get(j);
            }
            JDBC4ResultSet jDBC4ResultSet = SelectResultSet.createResultSet(this.exportKeysColumnNames, this.exportKeysColumnTypes, val, this.protocol);
            return jDBC4ResultSet;
        }
    }

    String removeQuoted(String str) {
        String tmp = str.trim();
        if (tmp.startsWith("`") && tmp.endsWith("`")) {
            return tmp.substring(1, tmp.length() - 1);
        }
        return tmp;
    }

    ArrayList<String> getALlTableNames(String catalog) throws SQLException {
        try (ResultSet rs = this.getTables(catalog, "", "%", new String[]{"TABLE"});){
            ArrayList<String> tableNameList = new ArrayList<String>();
            while (rs.next()) {
                tableNameList.add(rs.getString("TABLE_NAME"));
            }
            ArrayList<String> arrayList = tableNameList;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet getAllTablesResultSet(ArrayList<String> tableNameList, String catalog) throws SQLException {
        String[] columnNames = new String[]{"Name", "Type", "Comment"};
        ColumnType[] columnTypes = new ColumnType[]{ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR};
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (catalog == null || catalog.length() == 0) {
            catalog = this.connection.getCatalog();
        }
        try (ResultSet rs = null;){
            for (int i = 0; i < tableNameList.size(); ++i) {
                StringBuilder query = new StringBuilder();
                query.append("SHOW CREATE TABLE ");
                query.append("`");
                query.append(catalog);
                query.append("`.");
                String name = OceanBaseConnection.quoteIdentifier(tableNameList.get(i));
                query.append(name);
                rs = this.executeQuery(query.toString());
                String[] data = new String[3];
                StringBuilder sb = new StringBuilder("comment; ");
                while (rs.next()) {
                    String constraintName = null;
                    String columnName = null;
                    String refColumnName = null;
                    String referencedCatalog = null;
                    String referencedTable = null;
                    data[0] = rs.getString(1);
                    data[1] = "SUPPORTS_FK";
                    String createTableString = rs.getString(2);
                    StringTokenizer stringTokenizer = new StringTokenizer(createTableString, "\n");
                    boolean firstTime = true;
                    while (stringTokenizer.hasMoreTokens()) {
                        int fkIndex;
                        String str = stringTokenizer.nextToken().trim();
                        if (str.toUpperCase(Locale.ROOT).startsWith("CONSTRAINT")) {
                            int beginIndex = str.indexOf("`");
                            int endIndex = 0;
                            boolean useBackTicks = false;
                            if (beginIndex == -1) {
                                beginIndex = str.indexOf("\"");
                                useBackTicks = true;
                            }
                            if (beginIndex != -1 && (endIndex = !useBackTicks ? str.indexOf("`", beginIndex + 1) : str.indexOf("\"", beginIndex + 1)) != -1) {
                                constraintName = str.substring(beginIndex + 1, endIndex);
                                str = str.substring(endIndex + 1, str.length()).trim();
                            }
                        }
                        if (!str.toUpperCase(Locale.ROOT).startsWith("FOREIGN KEY")) continue;
                        if (str.endsWith(",")) {
                            str = str.substring(0, str.length() - 1);
                        }
                        if ((fkIndex = str.indexOf("FOREIGN KEY")) != -1) {
                            int startIndex = fkIndex + "FOREIGN KEY".length();
                            int refIndex = str.toUpperCase(Locale.ROOT).indexOf("REFERENCES", startIndex);
                            if (refIndex != -1) {
                                int paramOpenIndex = str.indexOf("(", startIndex);
                                int paramCloseIndex = str.indexOf(")", paramOpenIndex);
                                if (paramCloseIndex == -1 || paramOpenIndex == -1) {
                                    throw new SQLException("Parsing REFERENCES failed !");
                                }
                                columnName = str.substring(paramOpenIndex + 1, paramCloseIndex);
                                int afterRefIndex = refIndex + "REFERENCES".length();
                                int referenceParamOpenIndex = str.indexOf("(", afterRefIndex);
                                if (referenceParamOpenIndex != -1) {
                                    String refTableName = str.substring(afterRefIndex, referenceParamOpenIndex);
                                    int referenceParamCloseIndex = str.indexOf(")", referenceParamOpenIndex);
                                    refColumnName = str.substring(referenceParamOpenIndex + 1, referenceParamCloseIndex);
                                    int catalogEndIndex = refTableName.indexOf(".");
                                    if (catalogEndIndex != -1) {
                                        referencedCatalog = refTableName.substring(0, catalogEndIndex);
                                        referencedTable = refTableName.substring(catalogEndIndex + 1);
                                    }
                                }
                            }
                        }
                        if (!firstTime) {
                            sb.append("comment; ");
                        } else {
                            firstTime = false;
                        }
                        if (constraintName != null) {
                            sb.append(constraintName);
                        } else {
                            sb.append("not_availabl");
                        }
                        sb.append("(");
                        sb.append(columnName);
                        sb.append(") REFER");
                        sb.append(referencedCatalog);
                        sb.append("/");
                        sb.append(referencedTable);
                        sb.append("(");
                        sb.append(refColumnName);
                        sb.append(")");
                        int lastParenIndex = str.lastIndexOf(")");
                        if (lastParenIndex == str.length() - 1) continue;
                        String cascadeOptions = str.substring(lastParenIndex + 1);
                        sb.append(" ");
                        sb.append(cascadeOptions);
                    }
                    data[2] = sb.toString();
                }
                list.add(data);
            }
        }
        String[][] val = new String[list.size()][];
        for (int j = 0; j < list.size(); ++j) {
            val[j] = (String[])list.get(j);
        }
        return SelectResultSet.createResultSet(columnNames, columnTypes, val, this.protocol);
    }

    public ResultSet getImportedKeysUsingInformationSchema(String catalog, String table) throws SQLException {
        if (table == null) {
            throw new SQLException("'table' parameter in getImportedKeys cannot be null");
        }
        String sql = "SELECT KCU.REFERENCED_TABLE_SCHEMA PKTABLE_CAT, NULL PKTABLE_SCHEM,  KCU.REFERENCED_TABLE_NAME PKTABLE_NAME, KCU.REFERENCED_COLUMN_NAME PKCOLUMN_NAME, KCU.TABLE_SCHEMA FKTABLE_CAT, NULL FKTABLE_SCHEM,  KCU.TABLE_NAME FKTABLE_NAME, KCU.COLUMN_NAME FKCOLUMN_NAME, KCU.POSITION_IN_UNIQUE_CONSTRAINT KEY_SEQ, CASE update_rule    WHEN 'RESTRICT' THEN 1   WHEN 'NO ACTION' THEN 3   WHEN 'CASCADE' THEN 0   WHEN 'SET NULL' THEN 2   WHEN 'SET DEFAULT' THEN 4 END UPDATE_RULE, CASE DELETE_RULE  WHEN 'RESTRICT' THEN 1  WHEN 'NO ACTION' THEN 3  WHEN 'CASCADE' THEN 0  WHEN 'SET NULL' THEN 2  WHEN 'SET DEFAULT' THEN 4 END DELETE_RULE, RC.CONSTRAINT_NAME FK_NAME, NULL PK_NAME,7 DEFERRABILITY FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE KCU INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS RC ON KCU.CONSTRAINT_SCHEMA = RC.CONSTRAINT_SCHEMA AND KCU.CONSTRAINT_NAME = RC.CONSTRAINT_NAME WHERE " + this.catalogCond("KCU.TABLE_SCHEMA", catalog) + " AND  KCU.TABLE_NAME = " + this.escapeQuote(table) + " ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ";
        return this.executeQuery(sql);
    }

    public ResultSet getImportedKeysUsingShowCreateTable(String catalog, String table) throws Exception {
        if (catalog == null || catalog.isEmpty()) {
            throw new IllegalArgumentException("catalog");
        }
        if (table == null || table.isEmpty()) {
            throw new IllegalArgumentException("table");
        }
        Throwable throwable = null;
        try (ResultSet rs = this.executeQuery("SHOW CREATE TABLE " + OceanBaseConnection.quoteIdentifier(catalog) + "." + OceanBaseConnection.quoteIdentifier(table));){
            if (rs.next()) {
                String tableDef = rs.getString(2);
                ResultSet resultSet = JDBC4DatabaseMetaData.getImportedKeys(tableDef, table, catalog, this.connection);
                return resultSet;
            }
            try {
                throw new SQLException("Fail to retrieve table information using SHOW CREATE TABLE");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        if (table == null) {
            throw new SQLException("'table' parameter cannot be null in getBestRowIdentifier()");
        }
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getBestRowIdentifier(catalog, schema, table, scope, nullable);
        }
        if (table.contains("`")) {
            table = table.replace("`", "");
        }
        catalog = catalog == null ? this.connection.getProtocol().getCatalog() : catalog;
        String sql = "SELECT 2 SCOPE, COLUMN_NAME," + this.dataTypeClause("COLUMN_TYPE") + " DATA_TYPE, DATA_TYPE TYPE_NAME, IF(NUMERIC_PRECISION IS NULL, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION) COLUMN_SIZE, IF(NUMERIC_PRECISION IS NULL, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION)  BUFFER_LENGTH, NUMERIC_SCALE DECIMAL_DIGITS," + 1 + " PSEUDO_COLUMN FROM INFORMATION_SCHEMA.COLUMNS WHERE (COLUMN_KEY  = 'PRI' OR (COLUMN_KEY = 'UNI' AND NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE COLUMN_KEY = 'PRI' AND " + this.catalogCond("TABLE_SCHEMA", catalog) + " AND TABLE_NAME = " + this.escapeQuote(table) + " ))) AND " + this.catalogCond("TABLE_SCHEMA", catalog) + " AND TABLE_NAME = " + this.escapeQuote(table) + (nullable ? "" : " AND IS_NULLABLE = 'NO'");
        return this.executeQuery(sql);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.connection.createStatement().executeQuery("SELECT ' ' TABLE_CAT, ' ' TABLE_SCHEM,' ' TABLE_NAME, ' ' COLUMN_NAME, 0 DATA_TYPE, 0 COLUMN_SIZE, 0 DECIMAL_DIGITS,10 NUM_PREC_RADIX, ' ' COLUMN_USAGE,  ' ' REMARKS, 0 CHAR_OCTET_LENGTH, 'YES' IS_NULLABLE FROM DUAL WHERE 1=0");
    }

    @Override
    public boolean allProceduresAreCallable() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.allProceduresAreCallable();
        }
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.allTablesAreSelectable();
        }
        return true;
    }

    @Override
    public String getURL() {
        return this.urlParser.getInitialUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getUserName();
        }
        return this.urlParser.getUsername();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return !this.nullsAreSortedHigh();
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.nullsAreSortedAtEnd();
        }
        return !this.nullsAreSortedAtStart();
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        if (this.connection.getProtocol().getOptions().useCompatibleMetadata) {
            if (this.protocol.isOracleMode()) {
                return "Oracle";
            }
            return "MySQL";
        }
        return "OceanBase";
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.connection.getProtocol().getObServerVersion();
    }

    @Override
    public int getDatabaseMajorVersion() {
        return this.connection.getProtocol().getMajorServerVersion();
    }

    @Override
    public int getDatabaseMinorVersion() {
        return this.connection.getProtocol().getMinorServerVersion();
    }

    public String getOceanBaseServerVersion() {
        return this.connection.getProtocol().getObServerVersion();
    }

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public String getDriverVersion() {
        return Version.version;
    }

    @Override
    public int getDriverMajorVersion() {
        return Version.majorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        return Version.minorVersion;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.supportsMixedCaseIdentifiers();
        }
        return this.connection.getLowercaseTableNames() == 0;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.storesUpperCaseIdentifiers();
        }
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.storesLowerCaseIdentifiers();
        }
        return this.connection.getLowercaseTableNames() == 1;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.storesMixedCaseIdentifiers();
        }
        return this.connection.getLowercaseTableNames() != 1;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.supportsMixedCaseIdentifiers();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.storesUpperCaseIdentifiers();
        }
        return true;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.storesLowerCaseIdentifiers();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.storesMixedCaseIdentifiers();
    }

    @Override
    public String getIdentifierQuoteString() {
        if (this.protocol.isOracleMode()) {
            return "\"";
        }
        return "`";
    }

    @Override
    public String getSQLKeywords() {
        if (this.protocol.isOracleMode()) {
            return "ACCESS, ADD, ALTER, AUDIT, CLUSTER, COLUMN, COMMENT, COMPRESS, CONNECT, DATE, DROP, EXCLUSIVE, FILE, IDENTIFIED, IMMEDIATE, INCREMENT, INDEX, INITIAL, INTERSECT, LEVEL, LOCK, LONG, MAXEXTENTS, MINUS, MODE, NOAUDIT, NOCOMPRESS, NOWAIT, NUMBER, OFFLINE, ONLINE, PCTFREE, PRIOR, all_PL_SQL_reserved_ words";
        }
        return "ACCESSIBLE,ANALYZE,ASENSITIVE,BEFORE,BIGINT,BINARY,BLOB,CALL,CHANGE,CONDITION,DATABASE,DATABASES,DAY_HOUR,DAY_MICROSECOND,DAY_MINUTE,DAY_SECOND,DELAYED,DETERMINISTIC,DISTINCTROW,DIV,DUAL,EACH,ELSEIF,ENCLOSED,ESCAPED,EXIT,EXPLAIN,FLOAT4,FLOAT8,FORCE,FULLTEXT,GENERAL,HIGH_PRIORITY,HOUR_MICROSECOND,HOUR_MINUTE,HOUR_SECOND,IF,IGNORE,IGNORE_SERVER_IDS,INDEX,INFILE,INOUT,INT1,INT2,INT3,INT4,INT8,ITERATE,KEY,KEYS,KILL,LEAVE,LIMIT,LINEAR,LINES,LOAD,LOCALTIME,LOCALTIMESTAMP,LOCK,LONG,LONGBLOB,LONGTEXT,LOOP,LOW_PRIORITY,MASTER_HEARTBEAT_PERIOD,MASTER_SSL_VERIFY_SERVER_CERT,MAXVALUE,MEDIUMBLOB,MEDIUMINT,MEDIUMTEXT,MIDDLEINT,MINUTE_MICROSECOND,MINUTE_SECOND,MOD,MODIFIES,NO_WRITE_TO_BINLOG,OPTIMIZE,OPTIONALLY,OUT,OUTFILE,PURGE,RANGE,READ_WRITE,READS,REGEXP,RELEASE,RENAME,REPEAT,REPLACE,REQUIRE,RESIGNAL,RESTRICT,RETURN,RLIKE,SCHEMAS,SECOND_MICROSECOND,SENSITIVE,SEPARATOR,SHOW,SIGNAL,SLOW,SPATIAL,SPECIFIC,SQL_BIG_RESULT,SQL_CALC_FOUND_ROWS,SQL_SMALL_RESULT,SQLEXCEPTION,SSL,STARTING,STRAIGHT_JOIN,TERMINATED,TINYBLOB,TINYINT,TINYTEXT,TRIGGER,UNDO,UNLOCK,UNSIGNED,USE,UTC_DATE,UTC_TIME,UTC_TIMESTAMP,VARBINARY,VARCHARACTER,WHILE,XOR,YEAR_MONTH,ZEROFILL";
    }

    @Override
    public String getNumericFunctions() {
        if (this.protocol.isOracleMode()) {
            return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
        }
        return "DIV,ABS,ACOS,ASIN,ATAN,ATAN2,CEIL,CEILING,CONV,COS,COT,CRC32,DEGREES,EXP,FLOOR,GREATEST,LEAST,LN,LOG,LOG10,LOG2,MOD,OCT,PI,POW,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    public String getStringFunctions() {
        if (this.protocol.isOracleMode()) {
            return "ASCII,CHAR,CHAR_LENGTH,CHARACTER_LENGTH,CONCAT,LCASE,LENGTH,LTRIM,OCTET_LENGTH,REPLACE,RTRIM,SOUNDEX,SUBSTRING,UCASE";
        }
        return "ASCII,BIN,BIT_LENGTH,CAST,CHARACTER_LENGTH,CHAR_LENGTH,CONCAT,CONCAT_WS,CONVERT,ELT,EXPORT_SET,EXTRACTVALUE,FIELD,FIND_IN_SET,FORMAT,FROM_BASE64,HEX,INSTR,LCASE,LEFT,LENGTH,LIKE,LOAD_FILE,LOCATE,LOWER,LPAD,LTRIM,MAKE_SET,MATCH AGAINST,MID,NOT LIKE,NOT REGEXP,OCTET_LENGTH,ORD,POSITION,QUOTE,REPEAT,REPLACE,REVERSE,RIGHT,RPAD,RTRIM,SOUNDEX,SOUNDS LIKE,SPACE,STRCMP,SUBSTR,SUBSTRING,SUBSTRING_INDEX,TO_BASE64,TRIM,UCASE,UNHEX,UPDATEXML,UPPER,WEIGHT_STRING";
    }

    @Override
    public String getSystemFunctions() {
        if (this.protocol.isOracleMode()) {
            return "USER";
        }
        return "DATABASE,USER,SYSTEM_USER,SESSION_USER,LAST_INSERT_ID,VERSION";
    }

    @Override
    public String getTimeDateFunctions() {
        if (this.protocol.isOracleMode()) {
            return "CURRENT_DATE,CURRENT_TIMESTAMP,CURDATE,EXTRACT,HOUR,MINUTE,MONTH,SECOND,YEAR";
        }
        return "ADDDATE,ADDTIME,CONVERT_TZ,CURDATE,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURTIME,DATEDIFF,DATE_ADD,DATE_FORMAT,DATE_SUB,DAY,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,EXTRACT,FROM_DAYS,FROM_UNIXTIME,GET_FORMAT,HOUR,LAST_DAY,LOCALTIME,LOCALTIMESTAMP,MAKEDATE,MAKETIME,MICROSECOND,MINUTE,MONTH,MONTHNAME,NOW,PERIOD_ADD,PERIOD_DIFF,QUARTER,SECOND,SEC_TO_TIME,STR_TO_DATE,SUBDATE,SUBTIME,SYSDATE,TIMEDIFF,TIMESTAMPADD,TIMESTAMPDIFF,TIME_FORMAT,TIME_TO_SEC,TO_DAYS,TO_SECONDS,UNIX_TIMESTAMP,UTC_DATE,UTC_TIME,UTC_TIMESTAMP,WEEK,WEEKDAY,WEEKOFYEAR,YEAR,YEARWEEK";
    }

    @Override
    public String getSearchStringEscape() {
        if (this.protocol.isOracleMode()) {
            return "/";
        }
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        if (this.protocol.isOracleMode()) {
            return "$#";
        }
        return "#@";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.supportsConvert();
        }
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        switch (fromType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                switch (toType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: {
                        return true;
                    }
                }
                return false;
            }
            case 2004: {
                switch (toType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: {
                        return true;
                    }
                }
                return false;
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                switch (toType) {
                    case -16: 
                    case -15: 
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2004: 
                    case 2005: 
                    case 2011: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 92: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.supportsANSI92IntermediateSQL();
        }
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.supportsANSI92FullSQL();
        }
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.supportsSchemasInTableDefinitions();
        }
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.supportsCatalogsInTableDefinitions();
        }
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.supportsOpenCursorsAcrossCommit();
        }
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.supportsOpenCursorsAcrossRollback();
        }
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.supportsOpenStatementsAcrossCommit();
        }
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.supportsOpenStatementsAcrossRollback();
        }
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0xFFFFF8;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0xFFFFF8;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 64;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 64;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 16;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 64;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 256;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 256;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 32;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 256;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.doesMaxRowSizeIncludeBlobs();
        }
        return false;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 64;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 256;
    }

    @Override
    public int getMaxUserNameLength() {
        return 16;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 4;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        switch (level) {
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getProcedures(catalog, schemaPattern, procedureNamePattern);
        }
        String sql = "SELECT ROUTINE_SCHEMA PROCEDURE_CAT,NULL PROCEDURE_SCHEM, ROUTINE_NAME PROCEDURE_NAME, NULL RESERVED1, NULL RESERVED2, NULL RESERVED3, CASE ROUTINE_TYPE   WHEN 'FUNCTION' THEN 2  WHEN 'PROCEDURE' THEN 1  ELSE 0 END PROCEDURE_TYPE, ROUTINE_COMMENT REMARKS, SPECIFIC_NAME  FROM INFORMATION_SCHEMA.ROUTINES  WHERE " + this.catalogCond("ROUTINE_SCHEMA", catalog) + this.patternCond("ROUTINE_NAME", procedureNamePattern) + "/* AND ROUTINE_TYPE='PROCEDURE' */";
        return this.executeQuery(sql);
    }

    private boolean haveInformationSchemaParameters() {
        return this.connection.getProtocol().haveInformationSchemaParameters();
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (this.protocol.isOracleMode()) {
            return this.getProcedureColumnsForOracle(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        if (procedureNamePattern != null && procedureNamePattern.contains("`")) {
            procedureNamePattern = procedureNamePattern.replace("`", "");
        }
        if (this.haveInformationSchemaParameters()) {
            StringBuilder sb = new StringBuilder("SELECT SPECIFIC_SCHEMA PROCEDURE_CAT, NULL PROCEDURE_SCHEM, SPECIFIC_NAME PROCEDURE_NAME, PARAMETER_NAME COLUMN_NAME,  CASE PARAMETER_MODE   WHEN 'IN' THEN 1  WHEN 'OUT' THEN 4  WHEN 'INOUT' THEN 2  ELSE IF(PARAMETER_MODE IS NULL,5,0) END COLUMN_TYPE," + this.dataTypeClause("DTD_IDENTIFIER") + " DATA_TYPE,DATA_TYPE TYPE_NAME, CASE DATA_TYPE  WHEN 'time' THEN IF(DATETIME_PRECISION = 0, 10, CAST(11 + DATETIME_PRECISION as signed integer))  WHEN 'date' THEN 10  WHEN 'datetime' THEN IF(DATETIME_PRECISION = 0, 19, CAST(20 + DATETIME_PRECISION as signed integer))  WHEN 'timestamp' THEN IF(DATETIME_PRECISION = 0, 19, CAST(20 + DATETIME_PRECISION as signed integer))  ELSE   IF(NUMERIC_PRECISION IS NULL, LEAST(CHARACTER_MAXIMUM_LENGTH," + Integer.MAX_VALUE + "), NUMERIC_PRECISION)  END `PRECISION`, CASE DATA_TYPE  WHEN 'time' THEN IF(DATETIME_PRECISION = 0, 10, CAST(11 + DATETIME_PRECISION as signed integer))  WHEN 'date' THEN 10  WHEN 'datetime' THEN IF(DATETIME_PRECISION = 0, 19, CAST(20 + DATETIME_PRECISION as signed integer))  WHEN 'timestamp' THEN IF(DATETIME_PRECISION = 0, 19, CAST(20 + DATETIME_PRECISION as signed integer))  ELSE   IF(NUMERIC_PRECISION IS NULL, LEAST(CHARACTER_MAXIMUM_LENGTH," + Integer.MAX_VALUE + "), NUMERIC_PRECISION)  END `LENGTH`, CASE DATA_TYPE  WHEN 'time' THEN CAST(DATETIME_PRECISION as signed integer)  WHEN 'datetime' THEN CAST(DATETIME_PRECISION as signed integer)  WHEN 'timestamp' THEN CAST(DATETIME_PRECISION as signed integer)  ELSE NUMERIC_SCALE  END `SCALE`,10 RADIX," + 2 + " NULLABLE,NULL REMARKS,NULL COLUMN_DEF,0 SQL_DATA_TYPE,0 SQL_DATETIME_SUB,CHARACTER_OCTET_LENGTH CHAR_OCTET_LENGTH ,ORDINAL_POSITION, '' IS_NULLABLE, SPECIFIC_NAME  FROM INFORMATION_SCHEMA.PARAMETERS");
            boolean firstCondition = this.catalogCond(true, sb, "SPECIFIC_SCHEMA", catalog);
            firstCondition = this.patternCond(firstCondition, sb, "SPECIFIC_NAME", procedureNamePattern);
            this.patternCond(firstCondition, sb, "PARAMETER_NAME", columnNamePattern);
            sb.append(" ORDER BY SPECIFIC_SCHEMA, SPECIFIC_NAME, ORDINAL_POSITION");
            return this.executeQuery(sb.toString());
        }
        String[] columnNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME"};
        ColumnType[] columnTypes = new ColumnType[]{ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.NUMBER, ColumnType.SMALLINT, ColumnType.VARCHAR, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.SMALLINT, ColumnType.SMALLINT, ColumnType.SMALLINT, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.VARCHAR, ColumnType.VARCHAR};
        return this.getProcAndFuncs(catalog, procedureNamePattern, true, false, columnNames, columnTypes, false, columnNamePattern, schemaPattern);
    }

    private boolean catalogCond(boolean firstCondition, StringBuilder sb, String columnName, String catalog) {
        if (catalog == null) {
            return firstCondition;
        }
        if (catalog.isEmpty()) {
            sb.append(firstCondition ? " WHERE " : " AND ").append(columnName).append(" = database()");
            return false;
        }
        sb.append(firstCondition ? " WHERE " : " AND ").append(columnName).append("=").append(this.escapeQuote(catalog));
        return false;
    }

    private boolean patternCond(boolean firstCondition, StringBuilder sb, String columnName, String tableName) {
        if (tableName != null && !"%".equals(tableName)) {
            sb.append(firstCondition ? " WHERE " : " AND ").append(columnName).append(tableName.indexOf(37) == -1 && tableName.indexOf(95) == -1 ? "=" : " LIKE ").append("'").append(JDBC4DatabaseMetaData.escapeString(tableName, (this.connection.getProtocol().getServerStatus() & 0x200) != 0)).append("'");
            return false;
        }
        return firstCondition;
    }

    public static String escapeString(String value, boolean noBackslashEscapes) {
        return noBackslashEscapes ? value.replace("'", "''") : value.replace("\\", "\\\\").replace("'", "\\'").replace("\u0000", "\\0").replace("\"", "\\\"");
    }

    ResultSet getProcAndFuncs(String catalog, String procedureNamePattern, boolean isProcedure, boolean isFunction, String[] columnNames, ColumnType[] columnTypes, boolean forGetFunctionColumns, String columnPattern, String schemaPattern) throws SQLException {
        String db = catalog;
        ResultSet results = null;
        StringBuilder procSql = new StringBuilder();
        if (this.protocol.isOracleMode()) {
            procSql.append("select object_name as name,object_type as type  from  all_objects where ");
            if (isProcedure && !isFunction) {
                procSql.append("object_type = 'PROCEDURE' AND ");
            } else if (!isProcedure && isFunction) {
                procSql.append("object_type = 'FUNCTION' AND ");
            }
            procSql.append("object_name LIKE ? AND owner = ? ORDER BY object_name, object_type");
        } else {
            procSql.append("SELECT name, type, comment  FROM mysql.proc WHERE ");
            if (isProcedure && !isFunction) {
                procSql.append("type = 'PROCEDURE' AND ");
            } else if (!isProcedure && isFunction) {
                procSql.append("type = 'FUNCTION' AND ");
            }
            procSql.append("name LIKE ? AND db <=> ? ORDER BY name, type");
        }
        ClientSidePreparedStatement proceduresStmt = null;
        try {
            proceduresStmt = this.connection.clientPrepareStatement(procSql.toString());
            if (procedureNamePattern == null || procedureNamePattern.length() == 0) {
                procedureNamePattern = "%";
            }
            proceduresStmt.setString(1, procedureNamePattern);
            if (schemaPattern != null && schemaPattern.length() != 0) {
                proceduresStmt.setString(2, schemaPattern);
            } else if (db != null || this.protocol.getDatabase() != null) {
                String tmp = this.protocol.getDatabase();
                if (this.protocol.isOracleMode() && tmp != null && !tmp.startsWith("'")) {
                    tmp = tmp.toUpperCase();
                }
                db = db == null ? tmp : db;
                proceduresStmt.setString(2, db);
                catalog = db;
            } else {
                proceduresStmt.setNull(2, 12);
            }
        }
        catch (SQLException e) {
            if (isFunction) {
                proceduresStmt = this.connection.clientPrepareStatement("SHOW FUNCTION STATUS LIKE ?");
            } else if (isProcedure) {
                proceduresStmt = this.connection.clientPrepareStatement("SHOW PROCEDURE STATUS LIKE ?");
            }
            if (procedureNamePattern == null || procedureNamePattern.length() == 0) {
                procedureNamePattern = "%";
            }
            proceduresStmt.setString(1, procedureNamePattern);
        }
        proceduresStmt.closeOnCompletion();
        ((OceanBaseStatement)proceduresStmt).setInternal();
        results = proceduresStmt.executeQuery();
        return this.getCallStmtParameterTypes(catalog, results, columnNames, columnTypes, forGetFunctionColumns, columnPattern, schemaPattern);
    }

    private int mapMariaDbTypeToJdbc(String str) {
        switch (str.toUpperCase(Locale.ROOT)) {
            case "BIT": {
                return -7;
            }
            case "TINYINT": {
                return -6;
            }
            case "SMALLINT": {
                return 5;
            }
            case "MEDIUMINT": {
                return 4;
            }
            case "INT": {
                return 4;
            }
            case "INTEGER": {
                return 4;
            }
            case "LONG": {
                return 4;
            }
            case "BIGINT": {
                return -5;
            }
            case "INT24": {
                return 4;
            }
            case "REAL": {
                return 8;
            }
            case "FLOAT": {
                return 6;
            }
            case "DECIMAL": {
                return 3;
            }
            case "NUMERIC": {
                return 2;
            }
            case "DOUBLE": {
                return 8;
            }
            case "CHAR": {
                return 1;
            }
            case "VARCHAR": {
                return 12;
            }
            case "DATE": {
                return 91;
            }
            case "TIME": {
                return 92;
            }
            case "YEAR": {
                return 5;
            }
            case "TIMESTAMP": {
                return 93;
            }
            case "DATETIME": {
                return 93;
            }
            case "TINYBLOB": {
                return -2;
            }
            case "BLOB": {
                return -4;
            }
            case "MEDIUMBLOB": {
                return -4;
            }
            case "LONGBLOB": {
                return -4;
            }
            case "TINYTEXT": {
                return 12;
            }
            case "TEXT": {
                return -1;
            }
            case "MEDIUMTEXT": {
                return -1;
            }
            case "LONGTEXT": {
                return -1;
            }
            case "ENUM": {
                return 12;
            }
            case "SET": {
                return 12;
            }
            case "GEOMETRY": {
                return -4;
            }
            case "VARBINARY": {
                return -3;
            }
        }
        return 1111;
    }

    protected int getColumnType(boolean isOutParam, boolean isInParam, boolean isReturnParam, boolean forGetFunctionColumns) {
        if (isInParam && isOutParam) {
            return forGetFunctionColumns ? 2 : 2;
        }
        if (isInParam) {
            return forGetFunctionColumns ? 1 : 1;
        }
        if (isOutParam) {
            return forGetFunctionColumns ? 3 : 4;
        }
        if (isReturnParam) {
            return forGetFunctionColumns ? 4 : 5;
        }
        return forGetFunctionColumns ? 0 : 0;
    }

    private ResultSet parseParamListProc(boolean isFunction, ArrayList<String> paramListArray, String catalog, ArrayList<String> nameArray, String[] columnNames, ColumnType[] columnTypes, boolean forGetFunctionColumns, String columnPattern) throws SQLException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        int origin = 1;
        for (int i = 0; i < paramListArray.size(); ++i) {
            String paramList = paramListArray.get(i);
            String procName = nameArray.get(i);
            Matcher matcher1 = this.protocol.isOracleMode() ? ORALCLE_PARAMETER_PATTERN.matcher(paramList) : PARAMETER_PATTERN.matcher(paramList);
            TypeInfo typeInfo = null;
            boolean isInParam = false;
            boolean isOutParam = false;
            boolean isReturnParam = false;
            String[] data = new String[20];
            if (paramList != null && paramList.indexOf("(") != 0 && !matcher1.find()) {
                String[] tokens = new String[]{"LANGUAGE", "NOT", "DETERMINISTIC", "CONTAINS", "NO", "READ", "MODIFIES", "SQL", "COMMENT", "BEGIN", "RETURN"};
                int startIndex = 0;
                int endIndex = -1;
                for (int j = 0; j < tokens.length; ++j) {
                    endIndex = paramList.substring(startIndex).toUpperCase(Locale.ROOT).indexOf(tokens[j]);
                    if (endIndex == -1) continue;
                    startIndex = endIndex + 1;
                }
                if (endIndex != -1) {
                    paramList = paramList.substring(0, endIndex);
                }
                isInParam = false;
                isOutParam = false;
                isReturnParam = true;
                typeInfo = new TypeInfo(paramList.toUpperCase(Locale.ROOT));
                String[] tmp = this.getRowData(catalog, "", procName, forGetFunctionColumns, isInParam, isOutParam, isReturnParam, typeInfo, 0);
                list.add(tmp);
                continue;
            }
            Matcher matcher2 = this.protocol.isOracleMode() ? ORALCLE_PARAMETER_PATTERN.matcher(paramList) : PARAMETER_PATTERN.matcher(paramList);
            while (matcher2.find()) {
                String direction = matcher2.group(1);
                if (direction != null) {
                    direction = direction.trim();
                }
                isInParam = false;
                isOutParam = false;
                isReturnParam = false;
                if (direction == null || direction.equalsIgnoreCase("IN")) {
                    isInParam = true;
                } else if (direction.equalsIgnoreCase("OUT")) {
                    isOutParam = true;
                } else if (direction.equalsIgnoreCase("INOUT")) {
                    isInParam = true;
                    isOutParam = true;
                } else {
                    throw new SQLException("unknown parameter direction " + direction + "for ");
                }
                String paramName = matcher2.group(2).trim();
                if (paramName.startsWith("`") && paramName.endsWith("`")) {
                    paramName = paramName.substring(1, paramName.length() - 1);
                } else if (paramName.startsWith("") && paramName.endsWith("")) {
                    paramName = paramName.substring(1, paramName.length() - 1);
                }
                if (columnPattern != null && !columnPattern.equals("%") && !paramName.equals(columnPattern)) continue;
                typeInfo = this.protocol.isOracleMode() ? new TypeInfo(matcher2.group(4).trim().toUpperCase(Locale.ROOT)) : (matcher2.group(5) != null ? new TypeInfo(matcher2.group(4).trim().toUpperCase(Locale.ROOT) + matcher2.group(5).trim().toUpperCase(Locale.ROOT)) : new TypeInfo(matcher2.group(4).trim().toUpperCase(Locale.ROOT)));
                String[] tmp = this.getRowData(catalog, paramName, procName, forGetFunctionColumns, isInParam, isOutParam, isReturnParam, typeInfo, origin++);
                list.add(tmp);
            }
        }
        String[][] val = new String[list.size()][];
        for (int j = 0; j < list.size(); ++j) {
            val[j] = (String[])list.get(j);
        }
        return JDBC4ResultSet.createResultSet(columnNames, columnTypes, val, this.protocol);
    }

    String[] getRowData(String catalog, String paramName, String procName, boolean forGetFunctionColumns, boolean isInParam, boolean isOutParam, boolean isReturnParam, TypeInfo typeInfo, int origin) throws SQLException {
        String[] data = new String[20];
        if (paramName.startsWith("`") && paramName.endsWith("`")) {
            paramName = paramName.substring(1, paramName.length() - 1);
        } else if (paramName.startsWith("'") && paramName.endsWith("'")) {
            paramName = paramName.substring(1, paramName.length() - 1);
        }
        data[0] = catalog;
        data[1] = null;
        data[2] = procName;
        data[3] = paramName;
        data[4] = String.valueOf(this.getColumnType(isOutParam, isInParam, isReturnParam, forGetFunctionColumns));
        data[5] = Integer.toString(typeInfo.sqlType);
        data[6] = typeInfo.typeName;
        data[7] = String.valueOf(typeInfo.columnSize);
        data[8] = data[7];
        data[9] = typeInfo.decimalDigits;
        data[10] = String.valueOf(typeInfo.numPrecRadix);
        switch (typeInfo.nullability) {
            case 0: {
                data[11] = String.valueOf(0);
                break;
            }
            case 1: {
                data[11] = String.valueOf(1);
                break;
            }
            case 2: {
                data[11] = String.valueOf(2);
                break;
            }
            default: {
                throw new SQLException("Internal error while parsing callable statement metadata (unknown nullability value fount");
            }
        }
        data[12] = null;
        if (forGetFunctionColumns) {
            data[13] = null;
            data[14] = Integer.toString(origin);
            data[15] = typeInfo.isNullable;
            data[16] = procName;
        } else {
            data[13] = null;
            data[14] = null;
            data[15] = null;
            data[16] = null;
            data[17] = Integer.toString(origin);
            data[18] = typeInfo.isNullable;
            data[19] = procName;
        }
        String[] tmp = new String[20];
        System.arraycopy(data, 0, tmp, 0, data.length);
        return tmp;
    }

    ResultSet getCallStmtParameterTypes(String catalog, ResultSet procsAndOrFuncsRs, String[] columnNames, ColumnType[] columnTypes, boolean forGetFunctionColumns, String columnPattern, String schemaPattern) throws SQLException {
        ArrayList<String> paramListArray = new ArrayList<String>();
        ArrayList<String> nameArray = new ArrayList<String>();
        while (procsAndOrFuncsRs.next()) {
            String paramList;
            int startIndex;
            String procedureDDl;
            ResultSet paramRetrievalRs;
            String name = procsAndOrFuncsRs.getString("name");
            StringBuilder procNameBuf = new StringBuilder();
            String type = procsAndOrFuncsRs.getString("type");
            if (this.protocol.isOracleMode()) {
                if (!this.connection.getDatabase().equalsIgnoreCase(schemaPattern) && schemaPattern != null && schemaPattern.length() > 0) {
                    procNameBuf.append("\"");
                    procNameBuf.append(schemaPattern);
                    procNameBuf.append("\"");
                    procNameBuf.append(".");
                }
                procNameBuf.append("\"");
                procNameBuf.append(name);
                procNameBuf.append("\"");
            } else {
                procNameBuf.append("`");
                procNameBuf.append(catalog);
                procNameBuf.append("`.`");
                procNameBuf.append(name);
                procNameBuf.append("`");
            }
            if ("FUNCTION".equals(type)) {
                paramRetrievalRs = this.connection.createStatement().executeQuery("SHOW CREATE FUNCTION " + procNameBuf.toString());
                paramRetrievalRs.next();
                procedureDDl = paramRetrievalRs.getString("Create Function");
                startIndex = procedureDDl.indexOf("(");
                int returnIndex = procedureDDl.indexOf("RETURNS");
                if (returnIndex != -1 && returnIndex > startIndex) {
                    String returnList = procedureDDl.substring(returnIndex + "RESTURNS".length());
                    paramListArray.add(returnList);
                    nameArray.add(name);
                    String paramList2 = procedureDDl.substring(startIndex - 1, returnIndex - 1);
                    paramListArray.add(paramList2);
                    nameArray.add(name);
                    continue;
                }
                paramList = procedureDDl.substring(procedureDDl.indexOf("(") - 1);
                paramListArray.add(paramList);
                nameArray.add(name);
                continue;
            }
            paramRetrievalRs = this.connection.createStatement().executeQuery("SHOW CREATE PROCEDURE " + procNameBuf.toString());
            paramRetrievalRs.next();
            procedureDDl = paramRetrievalRs.getString("Create Procedure");
            startIndex = procedureDDl.indexOf("(");
            int endIdex = procedureDDl.toUpperCase().indexOf("\\bBEGIN\\b");
            paramList = null;
            paramList = endIdex != -1 && endIdex > startIndex ? procedureDDl.substring(startIndex - 1, endIdex - 1) : procedureDDl.substring(procedureDDl.indexOf("(") - 1);
            paramListArray.add(paramList);
            nameArray.add(name);
        }
        return this.parseParamListProc(false, paramListArray, catalog, nameArray, columnNames, columnTypes, forGetFunctionColumns, columnPattern);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        if (this.protocol.isOracleMode()) {
            return super.getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
        }
        if (functionNamePattern != null && functionNamePattern.contains("`")) {
            functionNamePattern = functionNamePattern.replace("`", "");
        }
        if (this.haveInformationSchemaParameters()) {
            StringBuilder sb = new StringBuilder("SELECT SPECIFIC_SCHEMA `FUNCTION_CAT`, NULL `FUNCTION_SCHEM`, SPECIFIC_NAME FUNCTION_NAME, PARAMETER_NAME COLUMN_NAME,  CASE PARAMETER_MODE   WHEN 'IN' THEN 1  WHEN 'OUT' THEN 3  WHEN 'INOUT' THEN 2  ELSE 4 END COLUMN_TYPE," + this.dataTypeClause("DTD_IDENTIFIER") + " DATA_TYPE,DATA_TYPE TYPE_NAME,NUMERIC_PRECISION `PRECISION`,CHARACTER_MAXIMUM_LENGTH LENGTH,NUMERIC_SCALE SCALE,10 RADIX," + 2 + " NULLABLE,NULL REMARKS,CHARACTER_OCTET_LENGTH CHAR_OCTET_LENGTH ,ORDINAL_POSITION, '' IS_NULLABLE, SPECIFIC_NAME  FROM INFORMATION_SCHEMA.PARAMETERS");
            boolean firstCondition = this.catalogCond(true, sb, "SPECIFIC_SCHEMA", catalog);
            firstCondition = this.patternCond(firstCondition, sb, "SPECIFIC_NAME", functionNamePattern);
            sb.append((firstCondition = this.patternCond(firstCondition, sb, "PARAMETER_NAME", columnNamePattern)) ? " WHERE " : " AND ").append(" ROUTINE_TYPE='FUNCTION' ORDER BY FUNCTION_CAT, SPECIFIC_NAME, ORDINAL_POSITION");
            return this.executeQuery(sb.toString());
        }
        String[] columnNames = new String[]{"FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME"};
        ColumnType[] columnTypes = new ColumnType[]{ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.NUMBER, ColumnType.SMALLINT, ColumnType.VARCHAR, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.SMALLINT, ColumnType.SMALLINT, ColumnType.SMALLINT, ColumnType.VARCHAR, ColumnType.NUMBER, ColumnType.NUMBER, ColumnType.VARCHAR, ColumnType.VARCHAR};
        ResultSet procsAndOrFuncsRs = this.getProcAndFuncs(catalog, functionNamePattern, false, true, columnNames, columnTypes, true, columnNamePattern, schemaPattern);
        return procsAndOrFuncsRs;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getSchemas();
        }
        return this.executeQuery("SELECT '' TABLE_SCHEM, '' TABLE_catalog  FROM DUAL WHERE 1=0");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getSchemas(catalog, schemaPattern);
        }
        return this.executeQuery("SELECT  ' ' table_schem, ' ' table_catalog FROM DUAL WHERE 1=0");
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getCatalogs();
        }
        return this.executeQuery("SELECT SCHEMA_NAME  TABLE_CAT FROM INFORMATION_SCHEMA.SCHEMATA ORDER BY 1");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getTableTypes();
        }
        return this.executeQuery("SELECT 'TABLE' TABLE_TYPE UNION SELECT 'SYSTEM VIEW' TABLE_TYPE UNION SELECT 'VIEW' TABLE_TYPE");
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (table == null) {
            throw new SQLException("'table' parameter must not be null");
        }
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getColumnPrivileges(catalog, schema, table, columnNamePattern);
        }
        String sql = "SELECT TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, NULL AS GRANTOR, GRANTEE, PRIVILEGE_TYPE AS PRIVILEGE, IS_GRANTABLE FROM  INFORMATION_SCHEMA.COLUMN_PRIVILEGES WHERE " + this.catalogCond("TABLE_SCHEMA", catalog) + " AND  TABLE_NAME = " + this.escapeQuote(table) + this.patternCond("COLUMN_NAME", columnNamePattern) + " ORDER BY COLUMN_NAME, PRIVILEGE_TYPE";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getTablePrivileges(catalog, schemaPattern, tableNamePattern);
        }
        String sql = "SELECT TABLE_SCHEMA TABLE_CAT,NULL  TABLE_SCHEM, TABLE_NAME, NULL GRANTOR,GRANTEE, PRIVILEGE_TYPE  PRIVILEGE, IS_GRANTABLE  FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES  WHERE " + this.catalogCond("TABLE_SCHEMA", catalog) + this.patternCond("TABLE_NAME", tableNamePattern) + "ORDER BY TABLE_SCHEMA, TABLE_NAME,  PRIVILEGE_TYPE ";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String sql = "SELECT 0 SCOPE, ' ' COLUMN_NAME, 0 DATA_TYPE, ' ' TYPE_NAME, 0 COLUMN_SIZE, 0 BUFFER_LENGTH, 0 DECIMAL_DIGITS, 0 PSEUDO_COLUMN  FROM DUAL WHERE 1 = 0";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return this.keysQuery(parentSchema, parentTable, foreignSchema, foreignTable, "ORDER BY fktable_schem, fktable_name, key_seq");
        }
        ArrayList<String> tableNameList = this.getALlTableNames(parentCatalog);
        ResultSet allTableRS = this.getAllTablesResultSet(tableNameList, parentCatalog);
        ArrayList<String[]> list = new ArrayList<String[]>();
        while (allTableRS.next()) {
            String tableType = allTableRS.getString("Type");
            if (tableType == null || !tableType.toUpperCase(Locale.ROOT).equals("INNODB") && !tableType.toUpperCase(Locale.ROOT).equals("SUPPORTS_FK")) continue;
            String tableComment = allTableRS.getString("Comment").trim();
            String fkTableName = allTableRS.getString("Name");
            if (tableComment == null) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(tableComment, ";", false);
            if (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
            }
            while (stringTokenizer.hasMoreTokens()) {
                String keys = stringTokenizer.nextToken();
                int fkParamOpenIndex = keys.indexOf("(");
                if (fkParamOpenIndex == -1) {
                    throw new SQLException("Error parsing foreign keys definition, couldn't find start of local columns list.");
                }
                String constraintName = keys.substring(1, fkParamOpenIndex);
                int fkParamCloseIndex = (keys = keys.substring(fkParamOpenIndex)).indexOf(")");
                if (fkParamCloseIndex == -1) {
                    throw new SQLException("Error parsing foreign keys definition, couldn't find start of local columns list.");
                }
                String fkParamNames = keys.substring(1, fkParamCloseIndex);
                int refIndex = keys.indexOf("REFER");
                if (refIndex == -1) {
                    throw new SQLException("Error parsing foreign keys definition, couldn't find start of referenced tables list");
                }
                int refParamOpenIndex = keys.indexOf("(", refIndex);
                if (refParamOpenIndex == -1) {
                    throw new SQLException("Error parsing foreign keys definition, couldn't find start of referenced columns list");
                }
                String refCatalogAndTable = keys.substring(refIndex + "REFER".length() + 1, refParamOpenIndex);
                int slashIndex = refCatalogAndTable.indexOf("/");
                if (slashIndex == -1) {
                    throw new SQLException("Error parsing foreign keys definition, couldn't find name of referenced catalog.");
                }
                String refCatalog = refCatalogAndTable.substring(0, slashIndex);
                refCatalog = this.removeQuoted(refCatalog);
                String refTableName = refCatalogAndTable.substring(slashIndex + 1);
                refTableName = this.removeQuoted(refTableName);
                if (fkTableName.compareTo(foreignTable) != 0) continue;
                int refParamCloseIndex = keys.indexOf(")", refParamOpenIndex);
                if (refParamCloseIndex == -1) {
                    throw new SQLException("Error parsing foreign keys definition, couldn't find end of referenced columns list.");
                }
                String refParamNames = keys.substring(refParamOpenIndex + 1, refParamCloseIndex);
                String[] refParamList = refParamNames.split(",");
                String[] fkParamList = fkParamNames.split(",");
                int fkCur = 0;
                int refCur = 0;
                int keySeq = 0;
                while (fkCur < fkParamList.length) {
                    String lColumnName = this.removeQuoted(fkParamList[fkCur++]);
                    String rColumnName = null;
                    if (refCur < refParamList.length) {
                        rColumnName = this.removeQuoted(refParamList[refCur++]);
                    }
                    if (refTableName.compareTo(parentTable) != 0) continue;
                    int updateRuleAction = 3;
                    int deleteRuleAction = 3;
                    int lastIndex = keys.lastIndexOf(")");
                    if (lastIndex != keys.length() - 1) {
                        String options = keys.substring(lastIndex + 1);
                        String optionsForUpdate = options.substring(options.indexOf("ON UPDATE"));
                        if (optionsForUpdate.startsWith("ON UPDATE CASCADE")) {
                            updateRuleAction = 0;
                        } else if (optionsForUpdate.startsWith("ON UPDATE SET NUL")) {
                            updateRuleAction = 2;
                        } else if (optionsForUpdate.startsWith("ON UPDATE RESTRICT")) {
                            updateRuleAction = 1;
                        } else if (optionsForUpdate.startsWith("ON UPDATE NO ACTION")) {
                            updateRuleAction = 3;
                        }
                        String optionsForDelete = options.substring(options.indexOf("ON DELETE"));
                        if (optionsForDelete.startsWith("ON DELETE CASCADE")) {
                            deleteRuleAction = 0;
                        } else if (optionsForDelete.startsWith("ON DELETE SET NUL")) {
                            deleteRuleAction = 2;
                        } else if (optionsForDelete.startsWith("ON DELETE RESTRICT")) {
                            deleteRuleAction = 1;
                        } else if (optionsForDelete.startsWith("ON DELETE NO ACTIO")) {
                            deleteRuleAction = 3;
                        }
                    }
                    String[] data = new String[]{parentCatalog, parentSchema, refTableName, rColumnName, foreignCatalog, foreignSchema, fkTableName, lColumnName, Integer.toString(keySeq++), Integer.toString(updateRuleAction), Integer.toString(deleteRuleAction), null, null, Integer.toString(7)};
                    list.add(data);
                }
            }
        }
        String[][] val = new String[list.size()][];
        for (int j = 0; j < list.size(); ++j) {
            val[j] = (String[])list.get(j);
        }
        return SelectResultSet.createResultSet(this.exportKeysColumnNames, this.exportKeysColumnTypes, val, this.protocol);
    }

    @Override
    public ResultSet getTypeInfo() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getTypeInfo();
        }
        String[] columnNames = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        ColumnType[] columnTypes = new ColumnType[]{ColumnType.VARCHAR, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.INTEGER, ColumnType.BIT, ColumnType.SMALLINT, ColumnType.BIT, ColumnType.BIT, ColumnType.BIT, ColumnType.VARCHAR, ColumnType.SMALLINT, ColumnType.SMALLINT, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.INTEGER};
        String[][] data = new String[][]{{"BIT", "-7", "1", "", "", "", "1", "1", "3", "0", "0", "0", "BIT", "0", "0", "0", "0", "10"}, {"BOOL", "-7", "1", "", "", "", "1", "1", "3", "0", "0", "0", "BOOL", "0", "0", "0", "0", "10"}, {"TINYINT", "-6", "3", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "TINYINT", "0", "0", "0", "0", "10"}, {"TINYINT UNSIGNED", "-6", "3", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "TINYINT UNSIGNED", "0", "0", "0", "0", "10"}, {"BIGINT", "-5", "19", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "BIGINT", "0", "0", "0", "0", "10"}, {"BIGINT UNSIGNED", "-5", "20", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "BIGINT UNSIGNED", "0", "0", "0", "0", "10"}, {"LONG VARBINARY", "-4", "16777215", "'", "'", "", "1", "1", "3", "0", "0", "0", "LONG VARBINARY", "0", "0", "0", "0", "10"}, {"MEDIUMBLOB", "-4", "16777215", "'", "'", "", "1", "1", "3", "0", "0", "0", "MEDIUMBLOB", "0", "0", "0", "0", "10"}, {"LONGBLOB", "-4", "2147483647", "'", "'", "", "1", "1", "3", "0", "0", "0", "LONGBLOB", "0", "0", "0", "0", "10"}, {"BLOB", "-4", "65535", "'", "'", "", "1", "1", "3", "0", "0", "0", "BLOB", "0", "0", "0", "0", "10"}, {"TINYBLOB", "-4", "255", "'", "'", "", "1", "1", "3", "0", "0", "0", "TINYBLOB", "0", "0", "0", "0", "10"}, {"VARBINARY", "-3", "255", "'", "'", "(M)", "1", "1", "3", "0", "0", "0", "VARBINARY", "0", "0", "0", "0", "10"}, {"BINARY", "-2", "255", "'", "'", "(M)", "1", "1", "3", "0", "0", "0", "BINARY", "0", "0", "0", "0", "10"}, {"LONG VARCHAR", "-1", "16777215", "'", "'", "", "1", "0", "3", "0", "0", "0", "LONG VARCHAR", "0", "0", "0", "0", "10"}, {"MEDIUMTEXT", "-1", "16777215", "'", "'", "", "1", "0", "3", "0", "0", "0", "MEDIUMTEXT", "0", "0", "0", "0", "10"}, {"LONGTEXT", "-1", "2147483647", "'", "'", "", "1", "0", "3", "0", "0", "0", "LONGTEXT", "0", "0", "0", "0", "10"}, {"TEXT", "-1", "65535", "'", "'", "", "1", "0", "3", "0", "0", "0", "TEXT", "0", "0", "0", "0", "10"}, {"TINYTEXT", "-1", "255", "'", "'", "", "1", "0", "3", "0", "0", "0", "TINYTEXT", "0", "0", "0", "0", "10"}, {"CHAR", "1", "255", "'", "'", "(M)", "1", "0", "3", "0", "0", "0", "CHAR", "0", "0", "0", "0", "10"}, {"NUMERIC", "2", "65", "", "", "[(M,D])] [ZEROFILL]", "1", "0", "3", "0", "0", "1", "NUMERIC", "-308", "308", "0", "0", "10"}, {"DECIMAL", "3", "65", "", "", "[(M,D])] [ZEROFILL]", "1", "0", "3", "0", "0", "1", "DECIMAL", "-308", "308", "0", "0", "10"}, {"INTEGER", "4", "10", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "INTEGER", "0", "0", "0", "0", "10"}, {"INTEGER UNSIGNED", "4", "10", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "INTEGER UNSIGNED", "0", "0", "0", "0", "10"}, {"INT", "4", "10", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "INT", "0", "0", "0", "0", "10"}, {"INT UNSIGNED", "4", "10", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "INT UNSIGNED", "0", "0", "0", "0", "10"}, {"MEDIUMINT", "4", "7", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "MEDIUMINT", "0", "0", "0", "0", "10"}, {"MEDIUMINT UNSIGNED", "4", "8", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "MEDIUMINT UNSIGNED", "0", "0", "0", "0", "10"}, {"SMALLINT", "5", "5", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "SMALLINT", "0", "0", "0", "0", "10"}, {"SMALLINT UNSIGNED", "5", "5", "", "", "[(M)] [ZEROFILL]", "1", "0", "3", "1", "0", "1", "SMALLINT UNSIGNED", "0", "0", "0", "0", "10"}, {"FLOAT", "7", "10", "", "", "[(M|D)] [ZEROFILL]", "1", "0", "3", "0", "0", "1", "FLOAT", "-38", "38", "0", "0", "10"}, {"DOUBLE", "8", "17", "", "", "[(M|D)] [ZEROFILL]", "1", "0", "3", "0", "0", "1", "DOUBLE", "-308", "308", "0", "0", "10"}, {"DOUBLE PRECISION", "8", "17", "", "", "[(M,D)] [ZEROFILL]", "1", "0", "3", "0", "0", "1", "DOUBLE PRECISION", "-308", "308", "0", "0", "10"}, {"REAL", "8", "17", "", "", "[(M,D)] [ZEROFILL]", "1", "0", "3", "0", "0", "1", "REAL", "-308", "308", "0", "0", "10"}, {"VARCHAR", "12", "255", "'", "'", "(M)", "1", "0", "3", "0", "0", "0", "VARCHAR", "0", "0", "0", "0", "10"}, {"ENUM", "12", "65535", "'", "'", "", "1", "0", "3", "0", "0", "0", "ENUM", "0", "0", "0", "0", "10"}, {"SET", "12", "64", "'", "'", "", "1", "0", "3", "0", "0", "0", "SET", "0", "0", "0", "0", "10"}, {"DATE", "91", "10", "'", "'", "", "1", "0", "3", "0", "0", "0", "DATE", "0", "0", "0", "0", "10"}, {"TIME", "92", "18", "'", "'", "[(M)]", "1", "0", "3", "0", "0", "0", "TIME", "0", "0", "0", "0", "10"}, {"DATETIME", "93", "27", "'", "'", "[(M)]", "1", "0", "3", "0", "0", "0", "DATETIME", "0", "0", "0", "0", "10"}, {"TIMESTAMP", "93", "27", "'", "'", "[(M)]", "1", "0", "3", "0", "0", "0", "TIMESTAMP", "0", "0", "0", "0", "10"}};
        return SelectResultSet.createResultSet(columnNames, columnTypes, data, this.connection.getProtocol());
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (table == null || table.length() == 0) {
            throw new SQLException();
        }
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getIndexInfo(catalog, schema, table, unique, approximate);
        }
        if (table.contains("`")) {
            table = table.replace("`", "");
        }
        String sql = "SELECT TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM, TABLE_NAME, if(i.NON_UNIQUE != 0,'true','false') as NON_UNIQUE,  TABLE_SCHEMA INDEX_QUALIFIER, INDEX_NAME, 3 TYPE, SEQ_IN_INDEX ORDINAL_POSITION, COLUMN_NAME, COLLATION ASC_OR_DESC, IFNULL(i.CARDINALITY,'0') as CARDINALITY , 0 PAGES, NULL FILTER_CONDITION FROM INFORMATION_SCHEMA.STATISTICS i WHERE TABLE_NAME = " + this.escapeQuote(table) + " AND " + this.catalogCond("TABLE_SCHEMA", catalog) + (unique ? " AND NON_UNIQUE = 0" : "") + " ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION";
        return this.executeQuery(sql);
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1004 || type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return type == 1004 || type == 1003;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return this.supportsResultSetType(type);
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return this.supportsResultSetType(type);
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return this.supportsResultSetType(type);
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String sql = "SELECT ' ' TYPE_CAT, NULL TYPE_SCHEM, ' ' TYPE_NAME, ' ' CLASS_NAME, 0 DATA_TYPE, ' ' REMARKS, 0 BASE_TYPE FROM DUAL WHERE 1=0";
        return this.executeQuery(sql);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return this.connection.getProtocol().isOracleMode();
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        String sql = "SELECT  ' ' TYPE_CAT, NULL TYPE_SCHEM, ' ' TYPE_NAME, ' ' SUPERTYPE_CAT, ' ' SUPERTYPE_SCHEM, ' '  SUPERTYPE_NAME FROM DUAL WHERE 1=0";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String sql = "SELECT  ' ' TABLE_CAT, ' ' TABLE_SCHEM, ' ' TABLE_NAME, ' ' SUPERTABLE_NAME FROM DUAL WHERE 1=0";
        return this.executeQuery(sql);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            throw new SQLFeatureNotSupportedException("Oracle model Unsupported features");
        }
        String sql = "SELECT ' ' TYPE_CAT, ' ' TYPE_SCHEM, ' ' TYPE_NAME, ' ' ATTR_NAME, 0 DATA_TYPE, ' ' ATTR_TYPE_NAME, 0 ATTR_SIZE, 0 DECIMAL_DIGITS, 0 NUM_PREC_RADIX, 0 NULLABLE, ' ' REMARKS, ' ' ATTR_DEF,  0 SQL_DATA_TYPE, 0 SQL_DATETIME_SUB, 0 CHAR_OCTET_LENGTH, 0 ORDINAL_POSITION, ' ' IS_NULLABLE, ' ' SCOPE_CATALOG, ' ' SCOPE_SCHEMA, ' ' SCOPE_TABLE, 0 SOURCE_DATA_TYPE FROM DUAL  WHERE 1=0";
        return this.executeQuery(sql);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.locatorsUpdateCopy();
        }
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        if (this.protocol.isOracleMode()) {
            return RowIdLifetime.ROWID_VALID_FOREVER;
        }
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() {
        ColumnDefinition[] columns = new ColumnDefinition[4];
        boolean isOracleMode = this.protocol.isOracleMode();
        columns[0] = ColumnDefinition.create("NAME", ColumnType.STRING, isOracleMode, this.protocol.getOptions().getCharacterEncoding(), this.protocol.getOptions());
        columns[1] = ColumnDefinition.create("MAX_LEN", ColumnType.INTEGER, isOracleMode, this.protocol.getOptions().getCharacterEncoding(), this.protocol.getOptions());
        columns[2] = ColumnDefinition.create("DEFAULT_VALUE", ColumnType.STRING, isOracleMode, this.protocol.getOptions().getCharacterEncoding(), this.protocol.getOptions());
        columns[3] = ColumnDefinition.create("DESCRIPTION", ColumnType.STRING, isOracleMode, this.protocol.getOptions().getCharacterEncoding(), this.protocol.getOptions());
        byte[] sixteenMb = new byte[]{49, 54, 55, 55, 55, 50, 49, 53};
        byte[] empty = new byte[]{};
        ColumnType[] types = new ColumnType[]{ColumnType.STRING, ColumnType.INTEGER, ColumnType.STRING, ColumnType.STRING};
        ArrayList<byte[]> rows = new ArrayList<byte[]>(3);
        rows.add(StandardPacketInputStream.create(new byte[][]{"ApplicationName".getBytes(), sixteenMb, empty, "The name of the application currently utilizing the connection".getBytes()}, types));
        rows.add(StandardPacketInputStream.create(new byte[][]{"ClientUser".getBytes(), sixteenMb, empty, "The name of the user that the application using the connection is performing work for. This may not be the same as the user name that was used in establishing the connection.".getBytes()}, types));
        rows.add(StandardPacketInputStream.create(new byte[][]{"ClientHostname".getBytes(), sixteenMb, empty, "The hostname of the computer the application using the connection is running on".getBytes()}, types));
        return new SelectResultSet(columns, rows, this.connection.getProtocol(), 1004);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            return super.getFunctions(catalog, schemaPattern, functionNamePattern);
        }
        String sql = "SELECT ROUTINE_SCHEMA FUNCTION_CAT,NULL FUNCTION_SCHEM, ROUTINE_NAME FUNCTION_NAME, ROUTINE_COMMENT REMARKS,1 FUNCTION_TYPE, SPECIFIC_NAME  FROM INFORMATION_SCHEMA.ROUTINES  WHERE " + this.catalogCond("ROUTINE_SCHEMA", catalog) + this.patternCond("ROUTINE_NAME", functionNamePattern) + " AND ROUTINE_TYPE='FUNCTION'";
        return this.executeQuery(sql);
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 0xFFFFFFFFL;
    }

    @Override
    public boolean supportsRefCursors() {
        return false;
    }

    private ResultSet getProcedureColumnsForOracle(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (!(!"".equals(catalog) || schemaPattern != null && this.haveWildcardsInSql(schemaPattern) || procedureNamePattern == null || this.haveWildcardsInSql(procedureNamePattern))) {
            if (schemaPattern != null) {
                schemaPattern = this.stripSqlEscapes(schemaPattern);
            }
            procedureNamePattern = this.stripSqlEscapes(procedureNamePattern);
            return this.getOraPLColumnsWithNoWildcardsAndUnPakaged(schemaPattern, procedureNamePattern, columnNamePattern);
        }
        if (catalog == null || catalog.isEmpty() || this.haveWildcardsInSql(catalog) || schemaPattern != null && this.haveWildcardsInSql(schemaPattern)) {
            return this.getOraPLColumnsWithWildcards(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        catalog = this.stripSqlEscapes(catalog);
        if (schemaPattern != null) {
            schemaPattern = this.stripSqlEscapes(schemaPattern);
        }
        return this.getOraPLColumnsWithNoWildcardsAndPakaged(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    private ResultSet getOraPLColumnsWithWildcards(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "%";
        } else if (schemaPattern.isEmpty()) {
            schemaPattern = this.getUserName().toUpperCase();
        }
        if (procedureNamePattern == null) {
            procedureNamePattern = "%";
        } else if (procedureNamePattern.isEmpty()) {
            throw new SQLException("Invalid name or pattern");
        }
        if (columnNamePattern != null && columnNamePattern.isEmpty()) {
            throw new SQLException("Invalid name or pattern");
        }
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        String actualSql = this.buildProcedureColumnsSql(true, true, columnNamePattern);
        if (catalog != null) {
            actualSql = catalog.isEmpty() ? actualSql + " AND package_name IS NULL" : actualSql + " AND package_name LIKE ? ESCAPE '/'";
        }
        actualSql = columnNamePattern.equals("%") ? actualSql + " AND (argument_name LIKE ? ESCAPE '/' OR (argument_name IS NULL AND data_type IS NOT NULL)) " : actualSql + " AND argument_name LIKE ? ESCAPE '/'";
        actualSql = actualSql + " ORDER BY procedure_schem, procedure_name, overload, sequence";
        PreparedStatement ps = this.connection.prepareStatement(actualSql);
        ps.setString(1, schemaPattern);
        ps.setString(2, procedureNamePattern);
        if (catalog == null || catalog.isEmpty()) {
            ps.setString(3, columnNamePattern);
        } else {
            ps.setString(3, catalog);
            ps.setString(4, columnNamePattern);
        }
        ps.closeOnCompletion();
        return ps.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getOraPLColumnsWithNoWildcardsAndPakaged(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if ("".equals(columnNamePattern)) {
            throw new SQLException("Invalid name or pattern");
        }
        try (CallableStatement cs = null;){
            cs = this.connection.prepareCall("declare   in_package_name varchar2(32) := null;   in_owner varchar2(32) := null;   in_name varchar2(32) := null;   my_user_name varchar2(32) := null;   cnt number := 0;   temp_package_name varchar2(32) := null;   temp_owner varchar2(32) := null;   out_package_name varchar2(32) := null;   out_owner varchar2(32) := null;   loc varchar2(32) := null;   status number := 0;   TYPE recursion_check_type is table of number index by varchar2(65);   recursion_check recursion_check_type;   dotted_name varchar2(65);   recursion_cnt number := 0; \nbegin   in_package_name := ?;   in_owner := ?;   in_name := ?;   select user into my_user_name from dual;   if( my_user_name = in_owner ) then     select count(*) into cnt from user_arguments where package_name = in_package_name;     if( cnt >= 1 ) then       out_owner := in_owner;       out_package_name := in_package_name;       loc := 'USER_ARGUMENTS';     end if;   else     select count(*) into cnt from all_arguments where owner = in_owner and package_name = in_package_name;     if( cnt >= 1 ) then       out_owner := in_owner;       out_package_name := in_package_name;       loc := 'ALL_ARGUMENTS';     end if;   end if;   if loc is null then   temp_owner := in_owner;   temp_package_name := in_package_name;   loop     begin       dotted_name := temp_owner || '.' ||temp_package_name;       begin         recursion_cnt := recursion_check(dotted_name );         status := -1;         exit;       exception       when NO_DATA_FOUND then         recursion_check( dotted_name ) := 1;       end;       select table_owner, table_name into out_owner, out_package_name from all_synonyms          where  owner = temp_owner and synonym_name = temp_package_name;       cnt := cnt + 1;       temp_owner  := out_owner;       temp_package_name := out_package_name;       exception       when NO_DATA_FOUND then         exit;       end;     end loop;     if( not(out_owner is null) ) then       loc := 'ALL_SYNONYMS';     end if;   end if;  ? := out_owner;  ? := out_package_name;  ? := status;  end; ");
            cs.setString(1, catalog);
            cs.setString(2, schemaPattern);
            cs.setString(3, procedureNamePattern);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 12);
            cs.registerOutParameter(6, 2);
            cs.execute();
            int status = cs.getInt(6);
            if (status != 0) {
                throw new SQLException("Detected synonym loop");
            }
            String outOwner = cs.getString(4);
            String outPackageName = cs.getString(5);
            String sql = this.buildProcedureColumnsSql(false, true, columnNamePattern);
            PreparedStatement ps = this.connection.prepareStatement(sql);
            ps.setString(1, outOwner);
            ps.setString(2, procedureNamePattern);
            ps.setString(3, outPackageName);
            ps.setString(4, columnNamePattern == null ? "%" : columnNamePattern);
            ps.closeOnCompletion();
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getOraPLColumnsWithNoWildcardsAndUnPakaged(String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if ("".equals(columnNamePattern)) {
            throw new SQLException("Invalid name or pattern");
        }
        try (CallableStatement cs = null;){
            cs = this.connection.prepareCall("declare   in_owner varchar2(32) := null;   in_name varchar2(32) := null;   my_user_name varchar2(32) := null;   cnt number := 0;   temp_owner varchar2(32) := null;   temp_name  varchar2(32):= null;   out_owner varchar2(32) := null;   out_name  varchar2(32):= null;   loc varchar2(32) := null;   status number := 0;   TYPE recursion_check_type is table of number index by varchar2(65);   recursion_check recursion_check_type;   dotted_name varchar2(65);   recursion_cnt number := 0; \nbegin\n  in_owner := ?;   in_name := ?;   select user into my_user_name from dual;   if( my_user_name = in_owner ) then     select count(*) into cnt from user_procedures where object_name = in_name;     if( cnt = 1 ) then       out_owner := in_owner;       out_name := in_name;       loc := 'USER_PROCEDURES';     end if;   else     select count(*) into cnt from all_arguments where owner = in_owner and object_name = in_name;     if( cnt >= 1 ) then       out_owner := in_owner;       out_name := in_name;       loc := 'ALL_ARGUMENTS';     end if;   end if;   if loc is null then     temp_owner := in_owner;     temp_name := in_name;     loop       begin         dotted_name := temp_owner || '.' ||temp_name;         begin           recursion_cnt := recursion_check(dotted_name );           status := -1;           exit;         exception         when NO_DATA_FOUND then           recursion_check( dotted_name ) := 1;         end;         select table_owner, table_name into out_owner, out_name from all_synonyms            where  owner = temp_owner and synonym_name = temp_name;         cnt := cnt + 1;         temp_owner  := out_owner;         temp_name := out_name;         exception         when NO_DATA_FOUND then           exit;         end;       end loop;       if( not(out_owner is null) ) then         loc := 'ALL_SYNONYMS';     end if;   end if; \n  ? := out_owner;  ? := out_name;  ? := status;  end; ");
            cs.setString(1, schemaPattern);
            cs.setString(2, procedureNamePattern);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 2);
            cs.execute();
            int status = cs.getInt(5);
            if (status != 0) {
                throw new SQLException("Detected synonym loop");
            }
            String outOwner = cs.getString(3);
            String outName = cs.getString(4);
            String sql = this.buildProcedureColumnsSql(false, false, columnNamePattern);
            PreparedStatement ps = this.connection.prepareStatement(sql);
            ps.setString(1, outOwner);
            ps.setString(2, outName);
            ps.setString(3, columnNamePattern == null ? "%" : columnNamePattern);
            ps.closeOnCompletion();
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
    }

    private String buildProcedureColumnsSql(boolean hasWildcards, boolean packaged, String columnNamePattern) {
        String actualSql = "";
        String orderSql = " ORDER BY procedure_schem, procedure_name, overload, sequence ";
        String sqlForOjdbc6 = String.format("SELECT package_name AS procedure_cat,  owner AS procedure_schem,  object_name AS procedure_name,  argument_name AS column_name,  DECODE(position, 0, 5,                   DECODE(in_out, 'IN', 1,                                  'OUT', 4,                                  'IN/OUT', 2,                                  0)) AS column_type,  DECODE (data_type, 'CHAR', 1,                     'VARCHAR2', 12,                     'NUMBER', 3,                     'LONG', -1,                     'DATE', %s,                     'RAW', -3,                     'LONG RAW', -4,                     'TIMESTAMP', 93,                      'TIMESTAMP WITH TIME ZONE', -101,                      'TIMESTAMP WITH LOCAL TIME ZONE', -102,                      'INTERVAL YEAR TO MONTH', -103,                      'INTERVAL DAY TO SECOND', -104,                      'BINARY_FLOAT', 100, 'BINAvRY_DOUBLE', 101, 1111) AS data_type,  DECODE(data_type, 'OBJECT', type_owner || '.' || type_name, data_type) AS type_name,  DECODE (data_precision, NULL, data_length, data_precision) AS precision,  data_length AS length,  data_scale AS scale,  10 AS radix,  1 AS nullable,  NULL AS remarks,  NULL AS column_def,  NULL as sql_data_type,  NULL AS sql_datetime_sub,  DECODE(data_type, 'CHAR', 32767,                    'VARCHAR2', 32767,                    'LONG', 32767,                    'RAW', 32767,                    'LONG RAW', 32767,                    NULL) AS char_octet_length,  (sequence - 1) AS ordinal_position,  'YES' AS is_nullable,  NULL AS specific_name,  sequence,  overload,  NULL AS default_value  FROM all_arguments \n ", this.protocol.getOptions().mapDateToTimestamp ? "93 " : "91 ");
        String sqlForOjdbc8 = String.format("SELECT arg.package_name AS procedure_cat,         arg.owner AS procedure_schem,         arg.object_name AS procedure_name,         arg.argument_name AS column_name,         DECODE(arg.position, 0, 5,                          DECODE(arg.in_out, 'IN', 1,                                         'OUT', 4,                                         'IN/OUT', 2,                                         0)) AS column_type,    DECODE(substr(arg.data_type, 1, 9),       'TIMESTAMP',         DECODE(substr(arg.data_type, 10, 1),           '(',             DECODE(substr(arg.data_type, 19, 5),               'LOCAL', -102, 'TIME ', -101, 93),           DECODE(substr(arg.data_type, 16, 5),             'LOCAL', -102, 'TIME ', -101, 93)),       'INTERVAL ',         DECODE(substr(arg.data_type, 10, 3),          'DAY', -104, 'YEA', -103),       DECODE(arg.data_type,         'BINARY_DOUBLE', 101,         'BINARY_FLOAT', 100,         'BFILE', -13,         'BLOB', 2004,         'CHAR', 1,         'CLOB', 2005,         'COLLECTION', 2003,         'DATE', %s,       'FLOAT', 6,         'LONG', -1,         'LONG RAW', -4,         'NCHAR', -15,         'NCLOB', 2011,         'NUMBER', 2,         'NVARCHAR', -9,         'NVARCHAR2', -9,         'OBJECT', 2002,         'OPAQUE/XMLTYPE', 2009,         'RAW', -3,         'REF', 2006,         'ROWID', -8,         'SQLXML', 2009,         'UROWID', -8,         'VARCHAR2', 12,         'VARRAY', 2003,         'XMLTYPE', 2009,         DECODE((SELECT a.typecode           FROM ALL_TYPES a           WHERE a.type_name = arg.data_type          ),           'OBJECT', 2002,           'COLLECTION', 2003, 1111)))    AS data_type,         DECODE(arg.data_type, 'OBJECT', arg.type_owner || '.' || arg.type_name,               arg.data_type) AS type_name,         DECODE (arg.data_precision, NULL, arg.data_length,                                 arg.data_precision) AS precision,         arg.data_length AS length,         arg.data_scale AS scale,         10 AS radix,         1 AS nullable,         NULL AS remarks,         NULL AS column_def,         NULL as sql_data_type,         NULL AS sql_datetime_sub,         DECODE(arg.data_type,                           'CHAR', 32767,                           'VARCHAR2', 32767,                           'LONG', 32767,                           'RAW', 32767,                           'LONG RAW', 32767,                           NULL) AS char_octet_length,         (arg.sequence - 1) AS ordinal_position,         'YES' AS is_nullable,         NULL AS specific_name,         arg.sequence,         arg.overload,         NULL as default_value   FROM all_arguments arg", this.protocol.getOptions().mapDateToTimestamp ? "93 " : "91 ");
        actualSql = sqlForOjdbc6;
        if (this.protocol.getOptions().compatibleOjdbcVersion == 8) {
            actualSql = sqlForOjdbc8;
        }
        if (hasWildcards) {
            actualSql = this.protocol.getOptions().compatibleOjdbcVersion == 6 ? actualSql + " WHERE owner LIKE ? ESCAPE '/' AND object_name LIKE ? ESCAPE '/' AND data_level = 0 " : actualSql + ", all_procedures proc  WHERE arg.owner LIKE ? ESCAPE '/'   AND arg.object_name LIKE ? ESCAPE '/' AND arg.data_level = 0   AND arg.owner = proc.owner   AND arg.object_id = proc.object_id   AND arg.subprogram_id = proc.subprogram_id  ";
        } else {
            actualSql = packaged ? actualSql + " WHERE owner = ? \n  AND object_name LIKE ? ESCAPE '/' \n AND data_level = 0\n AND package_name = ? " : actualSql + " WHERE owner = ? \n  AND object_name = ?\n AND data_level = 0\n AND package_name is null";
            if (this.protocol.getOptions().compatibleOjdbcVersion == 6) {
                actualSql = actualSql + "  AND argument_name LIKE ? ESCAPE '/' \n";
            }
            if (this.protocol.getOptions().compatibleOjdbcVersion == 8) {
                actualSql = columnNamePattern != null && !columnNamePattern.equals("%") ? actualSql + "  AND argument_name LIKE ? ESCAPE '/' \n" : actualSql + " AND (argument_name LIKE ? ESCAPE '/'\n      OR (argument_name IS NULL\n          AND data_type IS NOT NULL))\n ";
            }
            actualSql = actualSql + orderSql;
        }
        return actualSql;
    }

    private boolean haveWildcardsInSql(String pattern) {
        Matcher matcher = SQL_WILDCARD_PATTERN.matcher(pattern);
        return matcher.find();
    }

    private String stripSqlEscapes(String pattern) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = SQL_ESCAPE_PATTERN.matcher(pattern);
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    class TypeInfo {
        int bufferLength = 65535;
        int columnSize;
        String decimalDigits = null;
        String isNullable;
        int nullability;
        int numPrecRadix = 10;
        String typeName;
        int sqlType;

        TypeInfo(String fullTypeName) {
            int length;
            StringTokenizer tokenizer;
            String sub;
            boolean isUnsigned = false;
            this.nullability = 1;
            this.isNullable = "YES";
            String mysqlType = fullTypeName.indexOf("(") != -1 ? fullTypeName.substring(0, fullTypeName.indexOf("(")).trim() : fullTypeName;
            int indexOfUnsignedInMysqlType = mysqlType.toLowerCase(Locale.ROOT).indexOf("unsigned");
            if (indexOfUnsignedInMysqlType != -1) {
                mysqlType = mysqlType.substring(0, indexOfUnsignedInMysqlType - 1);
            }
            this.typeName = mysqlType;
            this.sqlType = JDBC4DatabaseMetaData.this.mapMariaDbTypeToJdbc(mysqlType);
            int indexUnsigned = fullTypeName.toLowerCase(Locale.ROOT).indexOf("unsigned");
            if (indexUnsigned != -1) {
                fullTypeName = fullTypeName.substring(0, indexUnsigned - 1);
                isUnsigned = true;
            }
            if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("enum")) {
                sub = fullTypeName.substring(fullTypeName.indexOf("("), fullTypeName.indexOf(")"));
                tokenizer = new StringTokenizer(sub, ",");
                length = 0;
                while (tokenizer.hasMoreTokens()) {
                    length = Math.max(length, tokenizer.nextToken().length() - 2);
                }
                this.columnSize = length;
            }
            if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("set")) {
                sub = fullTypeName.substring(fullTypeName.indexOf("("), fullTypeName.indexOf(")"));
                tokenizer = new StringTokenizer(sub, ",");
                length = 0;
                this.columnSize = 0;
                int num = tokenizer.countTokens();
                if (num > 0) {
                    length += num - 1;
                }
                while (tokenizer.hasMoreTokens()) {
                    String setMember = tokenizer.nextToken().trim();
                    if (setMember.startsWith("'") && setMember.endsWith("'")) {
                        length += setMember.length() - 2;
                        continue;
                    }
                    length += setMember.length();
                }
                this.columnSize = length;
            } else if (fullTypeName.indexOf(",") != -1) {
                this.columnSize = Integer.valueOf(fullTypeName.substring(fullTypeName.indexOf("(") + 1, fullTypeName.indexOf(",")));
                this.decimalDigits = fullTypeName.substring(fullTypeName.indexOf(",") + 1, fullTypeName.indexOf(")"));
            } else if ((fullTypeName.toLowerCase(Locale.ROOT).indexOf("char") != -1 || fullTypeName.toLowerCase(Locale.ROOT).indexOf("text") != -1 || fullTypeName.toLowerCase(Locale.ROOT).indexOf("binary") != -1 || fullTypeName.toLowerCase(Locale.ROOT).indexOf("blob") != -1 || fullTypeName.toLowerCase(Locale.ROOT).indexOf("bit") != -1) && fullTypeName.indexOf("(") != -1) {
                int endIndex = fullTypeName.indexOf(")");
                if (endIndex == -1) {
                    endIndex = fullTypeName.length();
                }
                this.columnSize = Integer.valueOf(fullTypeName.substring(fullTypeName.indexOf("(") + 1, endIndex));
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("tinyint")) {
                this.columnSize = 5;
                this.decimalDigits = "0";
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("smallint")) {
                this.columnSize = 5;
                this.decimalDigits = "0";
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("mediumint")) {
                this.columnSize = isUnsigned ? 8 : 7;
                this.decimalDigits = "0";
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("int")) {
                this.columnSize = 10;
                this.decimalDigits = "0";
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("integer")) {
                this.columnSize = 10;
                this.decimalDigits = "0";
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("bigint")) {
                this.columnSize = isUnsigned ? 20 : 19;
                this.decimalDigits = "0";
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("int24")) {
                this.columnSize = 19;
                this.decimalDigits = "0";
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("real")) {
                this.columnSize = 12;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("float")) {
                this.columnSize = 12;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("decimal")) {
                this.columnSize = 12;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("numeric")) {
                this.columnSize = 12;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("double")) {
                this.columnSize = 12;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("char")) {
                this.columnSize = 1;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("varchar")) {
                this.columnSize = 255;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("timestamp")) {
                this.columnSize = 19;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("datetime")) {
                this.columnSize = 19;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("date")) {
                this.columnSize = 10;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("time")) {
                this.columnSize = 8;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("tinyblob")) {
                this.columnSize = 255;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("blob")) {
                this.columnSize = 65535;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("mediumblob")) {
                this.columnSize = 0xFFFFFF;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("longblob")) {
                this.columnSize = Integer.MAX_VALUE;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("tinytext")) {
                this.columnSize = 255;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("text")) {
                this.columnSize = 65535;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("mediumtext")) {
                this.columnSize = 0xFFFFFF;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("longtext")) {
                this.columnSize = Integer.MAX_VALUE;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("enum")) {
                this.columnSize = 255;
            } else if (fullTypeName.toLowerCase(Locale.ROOT).startsWith("set")) {
                this.columnSize = 255;
            }
        }
    }

    protected class TableMetaData
    implements Comparable<TableMetaData> {
        String type;
        String catalog;
        String schema;
        String name;

        TableMetaData(String type, String catalog, String schema, String name) {
            this.type = type == null ? "" : type;
            this.catalog = catalog == null ? "" : catalog;
            this.schema = schema == null ? "" : schema;
            this.name = name == null ? "" : name;
        }

        @Override
        public int compareTo(TableMetaData tablesKey) {
            int ret = this.type.compareTo(tablesKey.type);
            if (ret != 0) {
                return ret;
            }
            ret = this.catalog.compareTo(tablesKey.catalog);
            if (ret != 0) {
                return ret;
            }
            ret = this.schema.compareTo(tablesKey.schema);
            if (ret != 0) {
                return ret;
            }
            return this.name.compareTo(tablesKey.name);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TableMetaData)) {
                return false;
            }
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            return this.compareTo((TableMetaData)obj) == 0;
        }
    }

    protected static enum TableType {
        LOCAL_TEMPORARY("LOCAL TEMPORARY"),
        SYSTEM_TABLE("SYSTEM TABLE"),
        SYSTEM_VIEW("SYSTEM VIEW"),
        TABLE("TABLE", new String[]{"BASE TABLE"}),
        VIEW("VIEW"),
        UNKNOWN("UNKNOWN");

        private String name;
        private byte[] nameAsBytes;
        private String[] synonyms;

        private TableType(String tableTypeName) {
            this(tableTypeName, null);
        }

        private TableType(String tableTypeName, String[] tableTypeSynonyms) {
            this.name = tableTypeName;
            this.nameAsBytes = tableTypeName.getBytes();
            this.synonyms = tableTypeSynonyms;
        }

        String getName() {
            return this.name;
        }

        byte[] asBytes() {
            return this.nameAsBytes;
        }

        boolean equalsTo(String tableTypeName) {
            return this.name.equalsIgnoreCase(tableTypeName);
        }

        static TableType getTableTypeEqualTo(String tableTypeName) {
            for (TableType tableType : TableType.values()) {
                if (!tableType.equalsTo(tableTypeName)) continue;
                return tableType;
            }
            return UNKNOWN;
        }

        boolean compliesWith(String tableTypeName) {
            if (this.equalsTo(tableTypeName)) {
                return true;
            }
            if (this.synonyms != null) {
                for (String synonym : this.synonyms) {
                    if (!synonym.equalsIgnoreCase(tableTypeName)) continue;
                    return true;
                }
            }
            return false;
        }

        static TableType getTableTypeCompliantWith(String tableTypeName) {
            for (TableType tableType : TableType.values()) {
                if (!tableType.compliesWith(tableTypeName)) continue;
                return tableType;
            }
            return UNKNOWN;
        }
    }
}

