/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.helpdesk.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.helpdesk.v1.model.SubscribeEventReq;
import com.lark.oapi.service.helpdesk.v1.model.SubscribeEventResp;
import com.lark.oapi.service.helpdesk.v1.model.UnsubscribeEventReq;
import com.lark.oapi.service.helpdesk.v1.model.UnsubscribeEventResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Event {
    private static final Logger log = LoggerFactory.getLogger(Event.class);
    private final Config config;

    public Event(Config config) {
        this.config = config;
    }

    public SubscribeEventResp subscribe(SubscribeEventReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/events/subscribe", Sets.newHashSet(AccessTokenType.Tenant), req);
        SubscribeEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SubscribeEventResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/events/subscribe", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public SubscribeEventResp subscribe(SubscribeEventReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/events/subscribe", Sets.newHashSet(AccessTokenType.Tenant), req);
        SubscribeEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SubscribeEventResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/events/subscribe", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public UnsubscribeEventResp unsubscribe(UnsubscribeEventReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/events/unsubscribe", Sets.newHashSet(AccessTokenType.Tenant), req);
        UnsubscribeEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UnsubscribeEventResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/events/unsubscribe", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public UnsubscribeEventResp unsubscribe(UnsubscribeEventReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/events/unsubscribe", Sets.newHashSet(AccessTokenType.Tenant), req);
        UnsubscribeEventResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UnsubscribeEventResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/events/unsubscribe", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

