/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.ws;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.okhttp.Response;
import com.lark.oapi.okhttp.WebSocket;
import com.lark.oapi.okhttp.WebSocketListener;
import com.lark.oapi.okio.ByteString;
import com.lark.oapi.ws.Client;
import com.lark.oapi.ws.exception.ClientException;
import com.lark.oapi.ws.exception.ServerException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Listener
extends WebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(Listener.class);
    private Client cli;

    public Listener(Client cli) {
        this.cli = cli;
    }

    @Override
    public void onOpen(WebSocket webSocket, Response response) {
        this.cli.conn = webSocket;
        log.info(this.cli.fmtLog("connected to %s", this.cli.connUrl));
    }

    @Override
    public void onMessage(WebSocket webSocket, String text) {
        super.onMessage(webSocket, text);
    }

    @Override
    public void onMessage(WebSocket webSocket, ByteString bytes) {
        this.cli.executor.execute(() -> this.cli.handleMessage(bytes.toByteArray()));
    }

    @Override
    public void onClosing(WebSocket webSocket, int code, String reason) {
        super.onClosing(webSocket, code, reason);
    }

    @Override
    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.cli.disconnect();
        if (this.cli.autoReconnect.booleanValue()) {
            this.cli.reconnect();
        }
    }

    @Override
    public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
        block11: {
            try {
                if (response == null) {
                    throw t;
                }
                String code = response.header("handshake-status");
                String msg = response.header("handshake-msg");
                if (Strings.isEmpty(code) || Strings.isEmpty(msg)) {
                    throw t;
                }
                int c = Integer.parseInt(code);
                switch (c) {
                    case 514: {
                        String authCode = response.header("handshake-autherrcode");
                        if (String.valueOf(1000040350).equals(authCode)) {
                            throw new ClientException(c, msg);
                        }
                        throw new ServerException(c, msg);
                    }
                    case 403: {
                        throw new ClientException(c, msg);
                    }
                }
                throw new ServerException(c, msg);
            }
            catch (ClientException e) {
                log.error(e.toString());
            }
            catch (Throwable e) {
                log.error(e.toString());
                if (this.cli.isReconnecting.booleanValue()) {
                    return;
                }
                this.cli.disconnect();
                if (!this.cli.autoReconnect.booleanValue()) break block11;
                this.cli.reconnect();
            }
        }
    }
}

