/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.board.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.service.board.v1.enums.TextFontWeightEnum;
import com.lark.oapi.service.board.v1.enums.TextHorizontalAlignEnum;
import com.lark.oapi.service.board.v1.enums.TextVerticalAlignEnum;

public class Text {
    @SerializedName(value="text")
    private String text;
    @SerializedName(value="font_weight")
    private String fontWeight;
    @SerializedName(value="font_size")
    private Integer fontSize;
    @SerializedName(value="horizontal_align")
    private String horizontalAlign;
    @SerializedName(value="vertical_align")
    private String verticalAlign;

    public Text() {
    }

    public Text(Builder builder) {
        this.text = builder.text;
        this.fontWeight = builder.fontWeight;
        this.fontSize = builder.fontSize;
        this.horizontalAlign = builder.horizontalAlign;
        this.verticalAlign = builder.verticalAlign;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public String getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(String horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
    }

    public String getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(String verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    public static class Builder {
        private String text;
        private String fontWeight;
        private Integer fontSize;
        private String horizontalAlign;
        private String verticalAlign;

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder fontWeight(String fontWeight) {
            this.fontWeight = fontWeight;
            return this;
        }

        public Builder fontWeight(TextFontWeightEnum fontWeight) {
            this.fontWeight = fontWeight.getValue();
            return this;
        }

        public Builder fontSize(Integer fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public Builder horizontalAlign(String horizontalAlign) {
            this.horizontalAlign = horizontalAlign;
            return this;
        }

        public Builder horizontalAlign(TextHorizontalAlignEnum horizontalAlign) {
            this.horizontalAlign = horizontalAlign.getValue();
            return this;
        }

        public Builder verticalAlign(String verticalAlign) {
            this.verticalAlign = verticalAlign;
            return this;
        }

        public Builder verticalAlign(TextVerticalAlignEnum verticalAlign) {
            this.verticalAlign = verticalAlign.getValue();
            return this;
        }

        public Text build() {
            return new Text(this);
        }
    }
}

