/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.util.AbstractList;

public class RangeArray
extends Expr {
    private Expr start;
    private Expr end;

    public RangeArray(Expr start, Expr end, Location location) {
        if (start == null) {
            throw new ParseException("The start value of range array can not be blank", location);
        }
        if (end == null) {
            throw new ParseException("The end value of range array can not be blank", location);
        }
        this.start = start;
        this.end = end;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object startValue = this.start.eval(scope);
        if (!(startValue instanceof Integer)) {
            throw new TemplateException("The start value of range array must be Integer", this.location);
        }
        Object endValue = this.end.eval(scope);
        if (!(endValue instanceof Integer)) {
            throw new TemplateException("The end value of range array must be Integer", this.location);
        }
        return new RangeList((Integer)startValue, (Integer)endValue, this.location);
    }

    public static class RangeList
    extends AbstractList<Integer> {
        final int start;
        final int size;
        final boolean increase;
        final Location location;

        public RangeList(int start, int end, Location location) {
            this.start = start;
            this.increase = start <= end;
            this.size = Math.abs(end - start) + 1;
            this.location = location;
        }

        @Override
        public Integer get(int index) {
            if (index < 0 || index >= this.size) {
                throw new TemplateException("Index out of bounds. Index: " + index + ", Size: " + this.size, this.location);
            }
            return this.increase ? this.start + index : this.start - index;
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

