/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.json;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class JsonPatchStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MAVEN_COORDINATE = "com.flipkart.zjsonpatch:zjsonpatch";
    private static final String DEFAULT_VERSION = "0.4.16";
    public static final String NAME = "apply-json-patch";
    private final JarState.Promised jarState;
    @Nullable
    private final List<Map<String, Object>> patch;
    @Nullable
    private final String patchString;

    private JsonPatchStep(JarState.Promised jarState, @Nullable String patchString, @Nullable List<Map<String, Object>> patch) {
        this.jarState = jarState;
        this.patchString = patchString;
        this.patch = patch;
    }

    public static FormatterStep create(String patchString, Provisioner provisioner) {
        return JsonPatchStep.create(DEFAULT_VERSION, patchString, provisioner);
    }

    public static FormatterStep create(String zjsonPatchVersion, String patchString, Provisioner provisioner) {
        Objects.requireNonNull(zjsonPatchVersion, "zjsonPatchVersion cannot be null");
        Objects.requireNonNull(patchString, "patchString cannot be null");
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.create(NAME, new JsonPatchStep(JarState.promise(() -> JarState.from("com.flipkart.zjsonpatch:zjsonpatch:" + zjsonPatchVersion, provisioner)), patchString, null), JsonPatchStep::equalityState, State::toFormatter);
    }

    public static FormatterStep create(List<Map<String, Object>> patch, Provisioner provisioner) {
        return JsonPatchStep.create(DEFAULT_VERSION, patch, provisioner);
    }

    public static FormatterStep create(String zjsonPatchVersion, List<Map<String, Object>> patch, Provisioner provisioner) {
        Objects.requireNonNull(zjsonPatchVersion, "zjsonPatchVersion cannot be null");
        Objects.requireNonNull(patch, "patch cannot be null");
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.create(NAME, new JsonPatchStep(JarState.promise(() -> JarState.from("com.flipkart.zjsonpatch:zjsonpatch:" + zjsonPatchVersion, provisioner)), null, patch), JsonPatchStep::equalityState, State::toFormatter);
    }

    private State equalityState() {
        return new State(this.jarState.get(), this.patchString, this.patch);
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JarState jarState;
        @Nullable
        private final List<Map<String, Object>> patch;
        @Nullable
        private final String patchString;

        State(JarState jarState, @Nullable String patchString, @Nullable List<Map<String, Object>> patch) {
            this.jarState = jarState;
            this.patchString = patchString;
            this.patch = patch;
        }

        FormatterFunc toFormatter() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            Class<?> formatterFunc = this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.json.JsonPatchFormatterFunc");
            if (this.patch != null) {
                Constructor<?> constructor = formatterFunc.getConstructor(List.class);
                return (FormatterFunc)constructor.newInstance(this.patch);
            }
            Constructor<?> constructor = formatterFunc.getConstructor(String.class);
            return (FormatterFunc)constructor.newInstance(this.patchString);
        }
    }
}

