/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.openalex;

import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.common.interfaces.SearchService;
import com.alibaba.cloud.ai.toolcalling.openalex.OpenAlexProperties;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class OpenAlexService
implements SearchService,
Function<Request, Response> {
    private static final Logger log = LoggerFactory.getLogger(OpenAlexService.class);
    private final OpenAlexProperties properties;
    private final WebClientTool webClientTool;
    private final ObjectMapper objectMapper;

    public OpenAlexService(OpenAlexProperties properties, JsonParseTool jsonParseTool, WebClientTool webClientTool) {
        this.properties = properties;
        this.webClientTool = webClientTool;
        this.objectMapper = new ObjectMapper();
    }

    public SearchService.Response query(String query) {
        return this.apply(Request.simpleQuery(query));
    }

    @Override
    public Response apply(Request request) {
        if (!StringUtils.hasText((String)request.getQuery())) {
            return Response.errorResponse(request.getQuery(), "Search query cannot be empty.");
        }
        try {
            String searchUrl = this.buildSearchUrl(request);
            log.debug("OpenAlex search URL: {}", (Object)searchUrl);
            String responseBody = (String)this.webClientTool.get(searchUrl).block();
            if (responseBody == null) {
                return Response.errorResponse(request.getQuery(), "Empty response from OpenAlex API");
            }
            return this.parseResponse(responseBody, request);
        }
        catch (Exception e) {
            log.error("Error searching OpenAlex: ", (Throwable)e);
            return Response.errorResponse(request.getQuery(), "Failed to search OpenAlex: " + e.getMessage());
        }
    }

    private String buildSearchUrl(Request request) {
        StringBuilder url = new StringBuilder();
        switch (request.entityType().toLowerCase()) {
            case "author": 
            case "authors": {
                url.append("/authors");
                break;
            }
            case "source": 
            case "sources": 
            case "journal": 
            case "journals": {
                url.append("/sources");
                break;
            }
            case "institution": 
            case "institutions": {
                url.append("/institutions");
                break;
            }
            case "topic": 
            case "topics": {
                url.append("/topics");
                break;
            }
            case "publisher": 
            case "publishers": {
                url.append("/publishers");
                break;
            }
            case "funder": 
            case "funders": {
                url.append("/funders");
                break;
            }
            default: {
                url.append("/works");
            }
        }
        url.append("?filter=");
        if (request.entityType().equals("works") || request.entityType().equals("work")) {
            url.append("title.search:");
        } else if (request.entityType().equals("authors") || request.entityType().equals("author")) {
            url.append("display_name.search:");
        } else {
            url.append("display_name.search:");
        }
        url.append(URLEncoder.encode(request.getQuery(), StandardCharsets.UTF_8));
        if (StringUtils.hasText((String)request.author())) {
            url.append(",author.id:").append(URLEncoder.encode(request.author(), StandardCharsets.UTF_8));
        }
        if (StringUtils.hasText((String)request.institution())) {
            url.append(",institutions.id:").append(URLEncoder.encode(request.institution(), StandardCharsets.UTF_8));
        }
        if (request.fromYear() != null && request.fromYear() > 0) {
            url.append(",from_publication_date:").append(request.fromYear()).append("-01-01");
        }
        if (request.toYear() != null && request.toYear() > 0) {
            url.append(",to_publication_date:").append(request.toYear()).append("-12-31");
        }
        if (request.isOpenAccess() != null && request.isOpenAccess().booleanValue()) {
            url.append(",is_oa:true");
        }
        url.append("&per-page=").append(Math.min(request.perPage() != null ? request.perPage().intValue() : this.properties.getPerPage(), 200));
        url.append("&sort=").append(request.sortBy() != null ? request.sortBy() : "cited_by_count:desc");
        return url.toString();
    }

    private Response parseResponse(String responseBody, Request request) {
        try {
            JsonNode rootNode = this.objectMapper.readTree(responseBody);
            JsonNode resultsNode = rootNode.get("results");
            ArrayList<OpenAlexResult> results = new ArrayList<OpenAlexResult>();
            if (resultsNode != null && resultsNode.isArray()) {
                for (JsonNode resultNode : resultsNode) {
                    try {
                        OpenAlexResult result = this.parseResult(resultNode, request.entityType());
                        if (result == null) continue;
                        results.add(result);
                    }
                    catch (Exception e) {
                        log.warn("Error parsing OpenAlex result: ", (Throwable)e);
                    }
                }
            }
            log.debug("Found {} search results", (Object)results.size());
            return new Response(request.getQuery(), results, null);
        }
        catch (Exception e) {
            log.error("Error parsing OpenAlex response: ", (Throwable)e);
            return Response.errorResponse(request.getQuery(), "Failed to parse response: " + e.getMessage());
        }
    }

    private OpenAlexResult parseResult(JsonNode node, String entityType) {
        String id = node.has("id") ? node.get("id").asText() : "";
        String displayName = node.has("display_name") ? node.get("display_name").asText() : "";
        String title = node.has("title") ? node.get("title").asText() : displayName;
        Object description = "";
        if (entityType.equals("works") || entityType.equals("work")) {
            if (node.has("host_venue") && node.get("host_venue").has("display_name")) {
                description = "\u53d1\u8868\u4e8e: " + node.get("host_venue").get("display_name").asText();
            }
            if (node.has("publication_year")) {
                description = (String)description + " (" + node.get("publication_year").asText() + ")";
            }
        } else if (entityType.equals("authors") || entityType.equals("author")) {
            JsonNode firstInst;
            JsonNode institutions;
            if (node.has("last_known_institutions") && (institutions = node.get("last_known_institutions")).isArray() && institutions.size() > 0 && (firstInst = institutions.get(0)).has("display_name")) {
                description = "\u96b6\u5c5e\u4e8e: " + firstInst.get("display_name").asText();
            }
            if (node.has("works_count")) {
                description = (String)description + " | \u4f5c\u54c1\u6570: " + node.get("works_count").asText();
            }
        }
        String url = node.has("id") ? node.get("id").asText() : "";
        Integer citationCount = null;
        if (node.has("cited_by_count") && !node.get("cited_by_count").isNull()) {
            citationCount = node.get("cited_by_count").asInt();
        }
        Integer year = null;
        if (node.has("publication_year") && !node.get("publication_year").isNull()) {
            year = node.get("publication_year").asInt();
        }
        String doi = null;
        if (node.has("doi") && !node.get("doi").isNull()) {
            doi = node.get("doi").asText();
        }
        return new OpenAlexResult(id, title, displayName, (String)description, url, doi, citationCount, year, entityType);
    }

    @JsonClassDescription(value="OpenAlex Search Request. Search for scholarly works, authors, institutions, etc.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Request(@JsonProperty(required=true, value="query") @JsonPropertyDescription(value="Search query terms") String query, @JsonProperty(value="entity_type", defaultValue="works") @JsonPropertyDescription(value="Type of entity to search: works, authors, sources, institutions, topics, publishers, funders") String entityType, @JsonProperty(value="author") @JsonPropertyDescription(value="Filter by author ID or name") String author, @JsonProperty(value="institution") @JsonPropertyDescription(value="Filter by institution ID or name") String institution, @JsonProperty(value="from_year") @JsonPropertyDescription(value="Start year for publication date filter") Integer fromYear, @JsonProperty(value="to_year") @JsonPropertyDescription(value="End year for publication date filter") Integer toYear, @JsonProperty(value="is_open_access") @JsonPropertyDescription(value="Filter for open access works only") Boolean isOpenAccess, @JsonProperty(value="per_page", defaultValue="25") @JsonPropertyDescription(value="Number of results per page (max 200)") Integer perPage, @JsonProperty(value="sort_by", defaultValue="cited_by_count:desc") @JsonPropertyDescription(value="Sort order: cited_by_count:desc, publication_date:desc, relevance_score:desc") String sortBy) implements SearchService.Request
    {
        public String getQuery() {
            return this.query();
        }

        public static Request simpleQuery(String query) {
            return new Request(query, "works", null, null, null, null, null, 25, "cited_by_count:desc");
        }

        public static Request authorSearch(String query) {
            return new Request(query, "authors", null, null, null, null, null, 25, "works_count:desc");
        }

        public static Request institutionSearch(String query) {
            return new Request(query, "institutions", null, null, null, null, null, 25, "works_count:desc");
        }
    }

    @JsonClassDescription(value="OpenAlex Search Response")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Response(@JsonProperty(value="query") String query, @JsonProperty(value="results") List<OpenAlexResult> results, @JsonProperty(value="error") String error) implements SearchService.Response
    {
        public static Response errorResponse(String query, String errorMsg) {
            return new Response(query, null, errorMsg);
        }

        public SearchService.SearchResult getSearchResult() {
            if (this.results == null) {
                return new SearchService.SearchResult(List.of());
            }
            return new SearchService.SearchResult(this.results().stream().map(item -> new SearchService.SearchContent(item.title(), item.description(), item.url(), null)).toList());
        }
    }

    public record OpenAlexResult(String id, String title, String displayName, String description, String url, String doi, Integer citationCount, Integer year, String entityType) {
    }
}

