/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.List;
import java.util.Map;

public class JsonParseTool {
    private final ObjectMapper objectMapper;

    JsonParseTool() {
        this.objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public JsonParseTool(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> String objectToJson(T obj) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(obj);
    }

    public <T> T jsonToObject(String json, Class<T> clazz) throws JsonProcessingException {
        return (T)this.objectMapper.readValue(json, clazz);
    }

    public <T> T jsonToObject(String json, TypeReference<T> typeRef) throws JsonProcessingException {
        return (T)this.objectMapper.readValue(json, typeRef);
    }

    public <T> List<T> jsonToList(String json, Class<T> clazz) throws JsonProcessingException {
        CollectionType type = this.objectMapper.getTypeFactory().constructCollectionType(List.class, clazz);
        return (List)this.objectMapper.readValue(json, (JavaType)type);
    }

    public <T> List<T> jsonToList(String json, TypeReference<T> typeRef) throws JsonProcessingException {
        JavaType type = this.objectMapper.getTypeFactory().constructType(typeRef);
        return (List)this.objectMapper.readValue(json, type);
    }

    public <T> Map<String, T> jsonToMap(String json, Class<T> clazz) throws JsonProcessingException {
        MapType type = this.objectMapper.getTypeFactory().constructMapType(Map.class, String.class, clazz);
        return (Map)this.objectMapper.readValue(json, (JavaType)type);
    }

    public <T> T getFieldValue(String json, TypeReference<T> typeRef, String fieldName) throws JsonProcessingException {
        JsonNode rootNode = this.objectMapper.readTree(json);
        JsonNode fieldNode = rootNode.path(fieldName);
        return (T)this.objectMapper.treeToValue((TreeNode)fieldNode, typeRef);
    }

    public <T> T getFieldValue(String json, Class<T> clazz, String fieldName) throws JsonProcessingException {
        JsonNode rootNode = this.objectMapper.readTree(json);
        JsonNode fieldNode = rootNode.path(fieldName);
        return (T)this.objectMapper.treeToValue((TreeNode)fieldNode, clazz);
    }

    public String getFieldValueAsString(String json, String fieldName) throws JsonProcessingException {
        JsonNode rootNode = this.objectMapper.readTree(json);
        JsonNode fieldNode = rootNode.path(fieldName);
        return fieldNode.toString();
    }

    public String getFieldValueAsText(String json, String fieldName) throws JsonProcessingException {
        JsonNode rootNode = this.objectMapper.readTree(json);
        JsonNode fieldNode = rootNode.get(fieldName);
        return fieldNode.asText();
    }

    public <T> T getDepthFieldValue(String json, TypeReference<T> typeRef, String ... fieldNames) throws JsonProcessingException {
        return this.jsonToObject(this.getDepthFieldValueAsString(json, fieldNames), typeRef);
    }

    public String getDepthFieldValueAsString(String json, String ... fieldNames) throws JsonProcessingException {
        for (String fieldName : fieldNames) {
            json = this.getFieldValueAsString(json, fieldName);
        }
        return json;
    }

    public String setFieldValue(String json, String fieldName, String value) throws JsonProcessingException {
        JsonNode jsonNode = this.objectMapper.readTree(json);
        if (!(jsonNode instanceof ObjectNode)) {
            throw new RuntimeException("no json object string");
        }
        ObjectNode rootNode = (ObjectNode)jsonNode;
        rootNode.put(fieldName, value);
        return this.objectMapper.writeValueAsString((Object)rootNode);
    }

    public Object setFieldValue(String json, String fieldName, JsonNode value) throws JsonProcessingException {
        JsonNode jsonNode = this.objectMapper.readTree(json);
        if (!(jsonNode instanceof ObjectNode)) {
            throw new RuntimeException("no json object string");
        }
        ObjectNode rootNode = (ObjectNode)jsonNode;
        return rootNode.set(fieldName, value);
    }

    public Object removeFieldValue(String json, String fieldName) throws JsonProcessingException {
        JsonNode jsonNode = this.objectMapper.readTree(json);
        if (!(jsonNode instanceof ObjectNode)) {
            throw new RuntimeException("no json object string");
        }
        ObjectNode rootNode = (ObjectNode)jsonNode;
        return rootNode.remove(fieldName);
    }

    public Object replaceFieldValue(String json, String fieldName, JsonNode value) throws JsonProcessingException {
        JsonNode jsonNode = this.objectMapper.readTree(json);
        if (!(jsonNode instanceof ObjectNode)) {
            throw new RuntimeException("no json object string");
        }
        ObjectNode rootNode = (ObjectNode)jsonNode;
        rootNode.replace(fieldName, value);
        return jsonNode;
    }

    public String setFieldJsonObjectAsString(String json, String fieldName, String objectJson) throws JsonProcessingException {
        JsonNode jsonNode = this.objectMapper.readTree(json);
        if (!(jsonNode instanceof ObjectNode)) {
            throw new RuntimeException("no json object string");
        }
        ObjectNode rootNode = (ObjectNode)jsonNode;
        JsonNode objectNode = this.objectMapper.readTree(objectJson);
        rootNode.set(fieldName, objectNode);
        return this.objectMapper.writeValueAsString((Object)rootNode);
    }

    public String setFieldJsonObjectAsString(String json, String fieldName, List<String> objectJsons) throws JsonProcessingException {
        JsonNode jsonNode = this.objectMapper.readTree(json);
        if (!(jsonNode instanceof ObjectNode)) {
            throw new RuntimeException("no json object string");
        }
        ObjectNode rootNode = (ObjectNode)jsonNode;
        ArrayNode arrayNode = this.objectMapper.createArrayNode();
        for (String objectJson : objectJsons) {
            JsonNode newNode = this.objectMapper.readTree(objectJson);
            arrayNode.add(newNode);
        }
        rootNode.set(fieldName, (JsonNode)arrayNode);
        return this.objectMapper.writeValueAsString((Object)rootNode);
    }

    public String getFirstElementFromJsonArrayString(String arrayJson) throws JsonProcessingException {
        JsonNode jsonNode = this.objectMapper.readTree(arrayJson);
        if (jsonNode.isArray() && !jsonNode.isEmpty()) {
            JsonNode firstElement = jsonNode.get(0);
            return this.objectMapper.writeValueAsString((Object)firstElement);
        }
        return null;
    }
}

