/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.spark;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.functions.Function;
import com.agentsflex.core.llm.functions.Parameter;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.message.FunctionCall;
import com.agentsflex.core.message.HumanMessage;
import com.agentsflex.core.message.MessageStatus;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.impl.DefaultAiMessageParser;
import com.agentsflex.core.prompt.DefaultPromptFormat;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.HashUtil;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.MessageUtil;
import com.agentsflex.llm.spark.SparkLlmConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class SparkLlmUtil {
    private static final PromptFormat promptFormat = new DefaultPromptFormat(){

        protected void buildFunctionJsonArray(List<Map<String, Object>> functionsJsonArray, List<Function> functions) {
            for (Function function : functions) {
                HashMap<String, Maps> propertiesMap = new HashMap<String, Maps>();
                ArrayList<String> requiredProperties = new ArrayList<String>();
                Parameter[] parameters = function.getParameters();
                if (parameters != null) {
                    for (Parameter parameter : parameters) {
                        if (parameter.isRequired()) {
                            requiredProperties.add(parameter.getName());
                        }
                        propertiesMap.put(parameter.getName(), Maps.of((String)"type", (Object)parameter.getType()).set("description", (Object)parameter.getDescription()));
                    }
                }
                Maps builder = Maps.of((String)"name", (Object)function.getName()).set("description", (Object)function.getDescription()).set("parameters", (Object)Maps.of((String)"type", (Object)"object").set("properties", propertiesMap).set("required", requiredProperties));
                functionsJsonArray.add((Map<String, Object>)builder);
            }
        }
    };

    public static AiMessageParser getAiMessageParser() {
        DefaultAiMessageParser aiMessageParser = new DefaultAiMessageParser(){

            public AiMessage parse(JSONObject rootJson) {
                if (!rootJson.containsKey((Object)"payload")) {
                    throw new JSONException("json not contains payload: " + rootJson);
                }
                return super.parse(rootJson);
            }
        };
        aiMessageParser.setContentPath("$.payload.choices.text[0].content");
        aiMessageParser.setIndexPath("$.payload.choices.text[0].index");
        aiMessageParser.setCompletionTokensPath("$.payload.usage.text.completion_tokens");
        aiMessageParser.setPromptTokensPath("$.payload.usage.text.prompt_tokens");
        aiMessageParser.setTotalTokensPath("$.payload.usage.text.total_tokens");
        aiMessageParser.setStatusParser(content -> {
            Integer status = (Integer)JSONPath.eval((Object)content, (String)"$.payload.choices.status");
            if (status == null) {
                return MessageStatus.UNKNOW;
            }
            switch (status) {
                case 0: {
                    return MessageStatus.START;
                }
                case 1: {
                    return MessageStatus.MIDDLE;
                }
                case 2: {
                    return MessageStatus.END;
                }
            }
            return MessageStatus.UNKNOW;
        });
        aiMessageParser.setCallsParser(content -> {
            JSONArray toolCalls = (JSONArray)JSONPath.eval((Object)content, (String)"$.payload.choices.text");
            if (toolCalls == null || toolCalls.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<FunctionCall> functionCalls = new ArrayList<FunctionCall>();
            for (int i = 0; i < toolCalls.size(); ++i) {
                JSONObject jsonObject = toolCalls.getJSONObject(i);
                JSONObject functionObject = jsonObject.getJSONObject("function_call");
                if (functionObject == null) continue;
                FunctionCall functionCall = new FunctionCall();
                functionCall.setId(jsonObject.getString("id"));
                functionCall.setName(functionObject.getString("name"));
                Object arguments = functionObject.get((Object)"arguments");
                if (arguments instanceof Map) {
                    functionCall.setArgs((Map)arguments);
                } else if (arguments instanceof String) {
                    functionCall.setArgs((Map)JSON.parseObject((String)arguments.toString(), Map.class));
                }
                functionCalls.add(functionCall);
            }
            return functionCalls;
        });
        return aiMessageParser;
    }

    public static String promptToPayload(Prompt prompt, SparkLlmConfig config, ChatOptions options) {
        List messages = prompt.toMessages();
        HumanMessage message = MessageUtil.findLastHumanMessage((List)messages);
        Maps root = Maps.of((String)"header", (Object)Maps.of((String)"app_id", (Object)config.getAppId()).set("uid", (Object)UUID.randomUUID().toString().replaceAll("-", "")));
        root.set("parameter", (Object)Maps.of((String)"chat", (Object)Maps.of((String)"domain", (Object)SparkLlmUtil.getDomain(config.getVersion())).setIf(options.getTemperature().floatValue() > 0.0f, "temperature", (Object)options.getTemperature()).setIf(options.getMaxTokens() != null, "max_tokens", (Object)options.getMaxTokens()).setIfNotNull("top_k", (Object)options.getTopK())));
        root.set("payload", (Object)Maps.of((String)"message", (Object)Maps.of((String)"text", (Object)promptFormat.toMessagesJsonObject(messages))).setIfNotEmpty("functions", (Object)Maps.ofNotNull((String)"text", (Object)promptFormat.toFunctionsJsonObject(message))));
        root.setIfNotEmpty(options.getExtra());
        return JSON.toJSONString((Object)root);
    }

    public static String createURL(SparkLlmConfig config) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss '+0000'", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = sdf.format(new Date());
        String header = "host: spark-api.xf-yun.com\n";
        header = header + "date: " + date + "\n";
        header = header + "GET /" + config.getVersion() + "/chat HTTP/1.1";
        String base64 = HashUtil.hmacSHA256ToBase64((String)header, (String)config.getApiSecret());
        String authorization_origin = "api_key=\"" + config.getApiKey() + "\", algorithm=\"hmac-sha256\", headers=\"host date request-line\", signature=\"" + base64 + "\"";
        String authorization = Base64.getEncoder().encodeToString(authorization_origin.getBytes());
        return "ws://spark-api.xf-yun.com/" + config.getVersion() + "/chat?authorization=" + authorization + "&date=" + SparkLlmUtil.urlEncode(date) + "&host=spark-api.xf-yun.com";
    }

    private static String urlEncode(String content) {
        try {
            return URLEncoder.encode(content, "utf-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getDomain(String version) {
        switch (version) {
            case "v4.0": {
                return "4.0Ultra";
            }
            case "v3.5": {
                return "generalv3.5";
            }
            case "v3.1": {
                return "generalv3";
            }
            case "v2.1": {
                return "generalv2";
            }
            case "v1.1": {
                return "lite";
            }
        }
        return "general";
    }

    public static String embedPayload(SparkLlmConfig config, Document document) {
        String text = Maps.of((String)"messages", Collections.singletonList(Maps.of((String)"content", (Object)document.getContent()).set("role", (Object)"user"))).toJSON();
        String textBase64 = Base64.getEncoder().encodeToString(text.getBytes());
        return Maps.of((String)"header", (Object)Maps.of((String)"app_id", (Object)config.getAppId()).set("uid", (Object)UUID.randomUUID()).set("status", (Object)3)).set("parameter", (Object)Maps.of((String)"emb", (Object)Maps.of((String)"domain", (Object)"para").set("feature", (Object)Maps.of((String)"encoding", (Object)"utf8").set("compress", (Object)"raw").set("format", (Object)"plain")))).set("payload", (Object)Maps.of((String)"messages", (Object)Maps.of((String)"encoding", (Object)"utf8").set("compress", (Object)"raw").set("format", (Object)"json").set("status", (Object)3).set("text", (Object)textBase64))).toJSON();
    }

    public static String createEmbedURL(SparkLlmConfig config) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss '+0000'", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = sdf.format(new Date());
        String header = "host: emb-cn-huabei-1.xf-yun.com\n";
        header = header + "date: " + date + "\n";
        header = header + "POST / HTTP/1.1";
        String base64 = HashUtil.hmacSHA256ToBase64((String)header, (String)config.getApiSecret());
        String authorization_origin = "api_key=\"" + config.getApiKey() + "\", algorithm=\"hmac-sha256\", headers=\"host date request-line\", signature=\"" + base64 + "\"";
        String authorization = Base64.getEncoder().encodeToString(authorization_origin.getBytes());
        return "http://emb-cn-huabei-1.xf-yun.com/?authorization=" + authorization + "&date=" + SparkLlmUtil.urlEncode(date) + "&host=emb-cn-huabei-1.xf-yun.com";
    }
}

