/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.image.tencent;

import com.agentsflex.core.image.EditImageRequest;
import com.agentsflex.core.image.GenerateImageRequest;
import com.agentsflex.core.image.ImageModel;
import com.agentsflex.core.image.ImageResponse;
import com.agentsflex.core.image.VaryImageRequest;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.util.Maps;
import com.agentsflex.image.tencent.TencentImageModelConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tencentcloudapi.common.DatatypeConverter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentImageModel
implements ImageModel {
    private static final Logger LOG = LoggerFactory.getLogger(TencentImageModel.class);
    private final TencentImageModelConfig config;
    private final HttpClient httpClient = new HttpClient();
    private static final Object LOCK = new Object();
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final String CT_JSON = "application/json; charset=utf-8";

    public TencentImageModel(TencentImageModelConfig config) {
        this.config = config;
    }

    public ImageResponse generate(GenerateImageRequest request) {
        try {
            String payload = TencentImageModel.promptToPayload(request);
            Map<String, String> headers = this.createAuthorizationToken("SubmitHunyuanImageJob", payload);
            String response = this.httpClient.post(this.config.getEndpoint(), headers, payload);
            JSONObject jsonObject = JSON.parseObject((String)response);
            JSONObject error = jsonObject.getJSONObject("Response").getJSONObject("Error");
            if (error != null && !error.isEmpty()) {
                return ImageResponse.error((String)error.getString("Message"));
            }
            Object jobId = jsonObject.getJSONObject("Response").get((Object)"JobId");
            if (Objects.isNull(jobId)) {
                return ImageResponse.error((String)"response is no jobId");
            }
            String id = (String)jobId;
            return this.getImage(id);
        }
        catch (Exception e) {
            return ImageResponse.error((String)e.getMessage());
        }
    }

    public ImageResponse img2imggenerate(GenerateImageRequest request) {
        return null;
    }

    public ImageResponse edit(EditImageRequest request) {
        throw new IllegalStateException("TencentImageModel Can not support edit image.");
    }

    public ImageResponse vary(VaryImageRequest request) {
        throw new IllegalStateException("TencentImageModel Can not support vary image.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageResponse getImage(String jobId) {
        ImageResponse imageResponse = null;
        while (true) {
            Object object = LOCK;
            synchronized (object) {
                imageResponse = this.callService(jobId);
                if (!Objects.isNull(imageResponse)) {
                    break;
                }
                try {
                    LOCK.wait(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    imageResponse = ImageResponse.error((String)e.toString());
                    break;
                }
            }
        }
        return imageResponse;
    }

    public ImageResponse callService(String jobId) {
        try {
            String payload = Maps.of((String)"JobId", (Object)jobId).toJSON();
            Map<String, String> headers = this.createAuthorizationToken("QueryHunyuanImageJob", payload);
            String resp = this.httpClient.post(this.config.getEndpoint(), headers, payload);
            JSONObject resultJson = JSONObject.parseObject((String)resp).getJSONObject("Response");
            JSONObject error = resultJson.getJSONObject("Error");
            if (error != null && !error.isEmpty()) {
                return ImageResponse.error((String)error.getString("Message"));
            }
            if (Objects.isNull(resultJson.get((Object)"JobStatusCode"))) {
                return ImageResponse.error((String)"response is no JobStatusCode");
            }
            Integer jobStatusCode = resultJson.getInteger("JobStatusCode");
            if (Objects.equals(5, jobStatusCode)) {
                if (Objects.isNull(resultJson.get((Object)"ResultImage"))) {
                    return ImageResponse.error((String)"response is no ResultImage");
                }
                JSONArray imagesArray = resultJson.getJSONArray("ResultImage");
                ImageResponse response = new ImageResponse();
                for (int i = 0; i < imagesArray.size(); ++i) {
                    String imageObj = imagesArray.getString(i);
                    response.addImage(imageObj);
                }
                return response;
            }
            if (Objects.equals(4, jobStatusCode)) {
                return ImageResponse.error((String)resultJson.getString("JobErrorMsg"));
            }
        }
        catch (Exception e) {
            return ImageResponse.error((String)e.getMessage());
        }
        return null;
    }

    public static String promptToPayload(GenerateImageRequest request) {
        return Maps.of((String)"Prompt", (Object)request.getPrompt()).setIfNotEmpty("NegativePrompt", (Object)request.getNegativePrompt()).setIfNotEmpty("Style", (Object)request.getSize()).setIfNotEmpty("Resolution", (Object)request.getQuality()).setIfNotEmpty("Num", (Object)request.getN()).setIfNotEmpty(request.getOptions()).toJSON();
    }

    public static byte[] hmac256(byte[] key, String msg) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, mac.getAlgorithm());
        mac.init(secretKeySpec);
        return mac.doFinal(msg.getBytes(UTF8));
    }

    public static String sha256Hex(String s) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] d = md.digest(s.getBytes(UTF8));
        return DatatypeConverter.printHexBinary((byte[])d).toLowerCase();
    }

    public Map<String, String> createAuthorizationToken(String action, String payload) {
        try {
            String service = this.config.getService();
            String host = this.config.getHost();
            String version = "2023-09-01";
            String algorithm = "TC3-HMAC-SHA256";
            String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String date = sdf.format(new Date(Long.parseLong(timestamp + "000")));
            String httpRequestMethod = "POST";
            String canonicalUri = "/";
            String canonicalQueryString = "";
            String canonicalHeaders = "content-type:application/json; charset=utf-8\nhost:" + host + "\nx-tc-action:" + action.toLowerCase() + "\n";
            String signedHeaders = "content-type;host;x-tc-action";
            String hashedRequestPayload = TencentImageModel.sha256Hex(payload);
            String canonicalRequest = httpRequestMethod + "\n" + canonicalUri + "\n" + canonicalQueryString + "\n" + canonicalHeaders + "\n" + signedHeaders + "\n" + hashedRequestPayload;
            String credentialScope = date + "/" + service + "/tc3_request";
            String hashedCanonicalRequest = TencentImageModel.sha256Hex(canonicalRequest);
            String stringToSign = algorithm + "\n" + timestamp + "\n" + credentialScope + "\n" + hashedCanonicalRequest;
            byte[] secretDate = TencentImageModel.hmac256(("TC3" + this.config.getApiKey()).getBytes(UTF8), date);
            byte[] secretService = TencentImageModel.hmac256(secretDate, service);
            byte[] secretSigning = TencentImageModel.hmac256(secretService, "tc3_request");
            String signature = DatatypeConverter.printHexBinary((byte[])TencentImageModel.hmac256(secretSigning, stringToSign)).toLowerCase();
            String authorization = algorithm + " Credential=" + this.config.getApiSecret() + "/" + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", authorization);
            headers.put("Content-Type", CT_JSON);
            headers.put("Host", host);
            headers.put("X-TC-Action", action);
            headers.put("X-TC-Timestamp", timestamp);
            headers.put("X-TC-Version", version);
            headers.put("X-TC-Region", this.config.getRegion());
            return headers;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

