/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.prompt.template;

import com.agentsflex.core.prompt.TextPrompt;
import com.agentsflex.core.prompt.template.PromptTemplate;
import com.agentsflex.core.util.MapUtil;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextPromptTemplate
implements PromptTemplate<TextPrompt> {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{\\{\\s*(.+?)\\s*}}");
    private static final Map<String, TextPromptTemplate> CACHES = new ConcurrentHashMap<String, TextPromptTemplate>();
    private final String originalTemplate;
    private final List<TemplateToken> tokens;

    public TextPromptTemplate(String template) {
        this.originalTemplate = template != null ? template : "";
        this.tokens = this.parseTemplate(this.originalTemplate);
    }

    public static TextPromptTemplate of(String template) {
        String finalTemplate = template != null ? template : "";
        return MapUtil.computeIfAbsent(CACHES, finalTemplate, k -> new TextPromptTemplate(finalTemplate));
    }

    @Override
    public TextPrompt format(Map<String, Object> rootMap) {
        return new TextPrompt(this.formatToString(rootMap));
    }

    public String formatToString(Map<String, Object> rootMap) {
        if (this.tokens.isEmpty()) {
            return "";
        }
        if (rootMap == null) {
            rootMap = Collections.emptyMap();
        }
        StringBuilder sb = new StringBuilder(this.originalTemplate.length() + 256);
        for (TemplateToken token : this.tokens) {
            if (token.isStatic()) {
                sb.append(token.content);
                continue;
            }
            Object value = this.getValueByJsonPath(rootMap, token.expression);
            String replacement = value != null ? value.toString() : token.defaultValue;
            sb.append(replacement);
        }
        return sb.toString();
    }

    private List<TemplateToken> parseTemplate(String template) {
        ArrayList<TemplateToken> result = new ArrayList<TemplateToken>();
        if (template == null || template.isEmpty()) {
            return result;
        }
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(template);
        int lastEnd = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (start > lastEnd) {
                result.add(TemplateToken.staticText(template.substring(lastEnd, start)));
            }
            String content = matcher.group(1);
            ParseResult parseResult = this.parseExpressionWithDefault(content);
            result.add(TemplateToken.dynamic(parseResult.expression, parseResult.defaultValue));
            lastEnd = end;
        }
        if (lastEnd < template.length()) {
            result.add(TemplateToken.staticText(template.substring(lastEnd)));
        }
        return result;
    }

    private ParseResult parseExpressionWithDefault(String content) {
        String[] parts = content.split("\\s*\\?\\?\\s*", 2);
        if (parts.length == 2) {
            String expr = parts[0].trim();
            String defaultValue = this.unquote(parts[1].trim());
            return new ParseResult(expr, defaultValue);
        }
        return new ParseResult(content.trim(), null);
    }

    private String unquote(String str) {
        if (str.startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private Object getValueByJsonPath(Map<String, Object> root, String path) {
        try {
            return JSONPath.eval(root, (String)("$." + path));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class ParseResult {
        String expression;
        String defaultValue;

        ParseResult(String expression, String defaultValue) {
            this.expression = expression;
            this.defaultValue = defaultValue;
        }
    }

    private static class TemplateToken {
        boolean isStatic;
        String content;
        String expression;
        String defaultValue;

        private TemplateToken(boolean isStatic, String content, String expression, String defaultValue) {
            this.isStatic = isStatic;
            this.content = content;
            this.expression = expression;
            this.defaultValue = defaultValue == null ? "" : defaultValue;
        }

        static TemplateToken staticText(String text) {
            return new TemplateToken(true, text, null, null);
        }

        static TemplateToken dynamic(String expr, String defaultValue) {
            return new TemplateToken(false, null, expr, defaultValue);
        }

        boolean isStatic() {
            return this.isStatic;
        }
    }
}

