/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQueryVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UntypedRangeQuery
extends RangeQueryBase<JsonData>
implements RangeQueryVariant {
    @Nullable
    private final String format;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<UntypedRangeQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UntypedRangeQuery::setupUntypedRangeQueryDeserializer);

    private UntypedRangeQuery(Builder builder) {
        super(builder);
        this.format = builder.format;
        this.timeZone = builder.timeZone;
    }

    public static UntypedRangeQuery of(Function<Builder, ObjectBuilder<UntypedRangeQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public RangeQuery.Kind _rangeQueryKind() {
        return RangeQuery.Kind.Untyped;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
    }

    protected static void setupUntypedRangeQueryDeserializer(ObjectDeserializer<Builder> op) {
        RangeQueryBase.setupRangeQueryBaseDeserializer(op, JsonData._DESERIALIZER);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
    }

    public static class Builder
    extends RangeQueryBase.AbstractBuilder<JsonData, Builder>
    implements ObjectBuilder<UntypedRangeQuery> {
        @Nullable
        private String format;
        @Nullable
        private String timeZone;

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UntypedRangeQuery build() {
            this._checkSingleUse();
            super.tSerializer(null);
            return new UntypedRangeQuery(this);
        }
    }
}

